varying vec2 t_coord;
varying vec3 dir;
varying vec2 screen_coord;
uniform sampler2D tex,sky;
uniform sampler2D rtex;
uniform sampler2D bump;

void main()
{
	vec3 N = normalize(2.0*texture2D(bump,t_coord).xyz-vec3(0.5));	// Bump mapping
	vec3 D = normalize(dir);
	vec4 col = texture2D(tex, t_coord);
	vec3 R = reflect(D,N);
	vec4 ref = texture2D(sky, R.xz*0.5+vec2(0.5,0.5));
	float trans = clamp(dot(N,D),0.0,1.0);
	col = mix(ref,col,trans)*vec4(1.0,1.0,1.0,0.5);
	vec2 scr_pos = screen_coord+0.01*N.xy;
	if (scr_pos.x<0.0)	scr_pos.x=0.0;
	else if (scr_pos.x>1.0)	scr_pos.x=1.0;
	if (scr_pos.y<0.0)	scr_pos.y=0.0;
	else if (scr_pos.y>1.0) scr_pos.y=1.0;
	vec4 scr_col = vec4(0.5,0.7,1.0,1.0)*texture2D(rtex,scr_pos);
	gl_FragColor = mix(col,scr_col,col.a);
}
