#include <assert.h>
#include "settings.h"
#include <allegro.h>
#include <string.h>

const char *config_keys[2][6] = 
{
	{"p1_key_left", "p1_key_right", "p1_key_down", "p1_key_up", "p1_key_action", "p1_key_alt"},	
	{"p2_key_left", "p2_key_right", "p2_key_down", "p2_key_up", "p2_key_action", "p2_key_alt"}
};

Settings::Settings()
{
   // these settings are the default
	// they are overriden by the info in xelda.cfg
	// and then by command line parameters
	music = true;
	soundOn = true;
	fpsOn = false;
#ifdef DEBUG
	// default in debug version
	windowed = true;
#else
	// default in release version
	windowed = false;
#endif
	runMode = RM_NORMAL;
	numPlayers = 1;
	
	button[0][btnLeft].setScancode (KEY_LEFT);
	button[0][btnRight].setScancode (KEY_RIGHT);
	button[0][btnDown].setScancode (KEY_DOWN);
	button[0][btnUp].setScancode (KEY_UP);
	button[0][btnAction].setScancode (KEY_RCONTROL);
	button[0][btnAlt].setScancode (KEY_RSHIFT);
	
	button[1][btnLeft].setScancode (KEY_A);
	button[1][btnRight].setScancode (KEY_D);
	button[1][btnDown].setScancode (KEY_S);
	button[1][btnUp].setScancode (KEY_W);
	button[1][btnAction].setScancode (KEY_LCONTROL);
	button[1][btnAlt].setScancode (KEY_LSHIFT);
	// end of config defaults
}

void Settings::getFromConfig()
{
	music = get_config_int ("fole1", "music", music);
	soundOn = get_config_int ("fole1", "sound", soundOn);
	fpsOn = get_config_int ("fole1", "fps", fpsOn);
	windowed = get_config_int ("fole1", "windowed", windowed);
	numPlayers = get_config_int ("fole1", "numplayers", numPlayers);
	
	for (int i = 0; i < 6; ++i)
	{
		button[0][i].setScancode (get_config_int ("fole1", config_keys[0][i], 
			button[0][i].getScancode()));
		button[1][i].setScancode (get_config_int ("fole1", config_keys[1][i], 
			button[1][i].getScancode()));
	}
}	

void Settings::getFromArgs(int argc, const char *const *argv)
{
		// parse command line arguments
	int i;
	for (i = 1; i < argc; i++)
	{
		if (strcmp (argv[i], "-smoketest") == 0)
		{
			runMode = RM_SMOKETEST;
		}
		else if (strcmp (argv[i], "-testview") == 0)
		{
			runMode = RM_TESTVIEW;
		}
		else if (strcmp (argv[i], "-nosound") == 0)
		{
			soundOn = false;
		}
		else if (strcmp (argv[i], "-windowed") == 0)
		{
			windowed = true;
		}
		else if (strcmp (argv[i], "-fullscreen") == 0)
		{
			windowed = false;
		}
		else if (strcmp (argv[i], "-showfps") == 0)
		{
			fpsOn = true;
		}
		else
		{
			allegro_message (
				"warning: Couldn't parse a command line argument %i\n%s",		
				i, argv[i]);
		}			
	}
}

void Settings::setSoundOn(bool value)	
{
	if (value != soundOn)
	{
		soundOn = value;
	}			
}

void Settings::setMusicOn(bool value)	
{
	if (value != music)
	{
		music = value;
	}			
}
