#include <assert.h>
#include "resources.h"
#include "anim.h"
#include <tegel.h>
#include "dom.h"
#include "level.h"

using namespace std;
using namespace xdom;

#ifndef PI
#define PI 3.1415926
#endif

// adds all filenames that match pattern to the vector
void glob(const char *pattern, vector<string> &result)
{
	char buf[1024];
	
	al_ffblk info;
	
	int temp = al_findfirst (pattern, &info, FA_RDONLY | FA_ARCH);
	
	while (temp == 0)
	{
		replace_filename(buf, pattern, info.name, sizeof(buf));
		result.push_back (std::string(buf));
		temp = al_findnext(&info);
	}
			
	al_findclose(&info);
}

void Resources::makeHitAnim (const string &id, const string &id2)
{
	Anim *src = getAnim (id);
	Anim *a = new Anim();		
	for (int dir = 0; dir < 4; ++dir)
	{
		Frame *srcFrame = src->getFrame (0, dir);		
		RLE_SPRITE * s = srcFrame->rle;
		BITMAP *temp = create_bitmap (s->w, s->h);
		clear_to_color (temp, makecol (255, 0, 255));
		draw_rle_sprite (temp, s, 0, 0);
		int x, y;
		for (x = 0; x < s->w; ++x)
			for (y = 0; y < s->h; ++y)
				if (getpixel (temp, x, y) != makecol (255, 0, 255)) 
					putpixel (temp, x, y, makecol (255, 255, 255));
		RLE_SPRITE *temp_rle = get_rle_sprite (temp);
		destroy_bitmap (temp);
		generated.push_back (temp_rle);
		Frame f;
		f.rle = temp_rle;
		f.time = 100;
		f.w = srcFrame->w;
		f.h = srcFrame->h;
		f.hotx = srcFrame->hotx;
		f.hoty = srcFrame->hoty;
		Frame f2;
		f2.rle = s;
		f2.time = 100;	
		f.w = srcFrame->w;
		f.h = srcFrame->h;
		f.hotx = srcFrame->hotx;
		f.hoty = srcFrame->hoty;
		a->add (f, dir);
		a->add (f2, dir);
	}
	a->totalLength[0] = 200;
	a->totalLength[1] = 200;
	a->totalLength[2] = 200;
	a->totalLength[3] = 200;
	a->totalDirs = src->totalDirs;
	animlist.insert (pair<string, Anim*>(id2, a));	
}

int Resources::init()
// returns 1 on succes, 0 on failure
{
	{
		// load all .dat files in data directory
		vector <string> datafilenames;
		glob ("data/*.dat", datafilenames);
		for (vector<string>::iterator i = datafilenames.begin();
			i != datafilenames.end(); ++i)
		{
			DATAFILE *temp;
			if (!(temp = teg_load_datafile (i->c_str())))
			{
				return 0;
			} else {
					data.push_back (temp);
			}
		}
	}
	
	{
		vector <string> modfilenames;
		glob ("data/*.MOD", modfilenames);
		for (vector<string>::iterator i = modfilenames.begin();
			i != modfilenames.end(); ++i)
		{
			unsigned int start = i->find_last_of ("\\/");
			if (start == string::npos) start = 0;
			else start += 1;
				
			unsigned int end = i->rfind (".");
			if (end == string::npos) end = i->size();
			else end -= 1;
			
			DUH *temp;
			if (!(temp = dumb_load_mod (i->c_str())))
			{
				return 0;
			}
			else
			{
				string name = i->substr(start, end-start+1);
				duhlist.insert (pair<string, DUH*>(name, temp));
			}
		}
	}

	vector <string> bmpfilenames;	
	glob ("data/*.bmp", bmpfilenames);
	
	for (vector<string>::iterator i = bmpfilenames.begin();
		i != bmpfilenames.end(); ++i)
	{
		unsigned int start = i->find_last_of ("\\/");
		if (start == string::npos) start = 0;
		else start += 1;
			
		unsigned int end = i->rfind (".");
		if (end == string::npos) end = i->size();
		else end -= 1;
			
		BITMAP *bmp;
		bmp = load_bitmap (i->c_str(), NULL);
		if (!bmp)
		{
			return 0;
		}
		else
		{
			string name = i->substr(start, end-start+1);
			sprites.insert (pair<string, RLE_SPRITE*>(name, get_rle_sprite(bmp)));
			destroy_bitmap (bmp);
		}
	}
	
	vector <string> mapfilenames;	
	glob ("data/*.map", mapfilenames);
	
	for (vector<string>::iterator i = mapfilenames.begin();
		i != mapfilenames.end(); ++i)
	{
		unsigned int start = i->find_last_of ("\\/");
		if (start == string::npos) start = 0;
		else start += 1;
			
		unsigned int end = i->rfind (".");
		if (end == string::npos) end = i->size();
		else end -= 1;
			
		TEG_MAP *tempmap;
		if (!(tempmap = teg_loadmap (i->c_str(), getTilelist ("tiles1")))) // TODO: remove hardcoded tilelist
		{
			return 0;
		} else {
			maps.push_back (tempmap);
			string name = i->substr(start, end-start+1);
			maplist.insert (pair<string, TEG_MAP*>(name, tempmap));
		}
	}
	
	// load xml data
	
	vector <string> xmlfilenames;	
	glob ("data/*.xml", xmlfilenames);

	for (vector <string>::iterator i = xmlfilenames.begin(); i != xmlfilenames.end(); ++i)
	{
		DomNode node = xmlParseFile(*i);
		
		vector<DomNode>::iterator n;
		for (n = node.children.begin(); n != node.children.end(); ++n)
		{
			if (n->name == "anim")
			{
				Anim::loadFromXml (&(*n), this, animlist);
			}
			else if (n->name == "roomset")
			{
				RoomSet::loadFromXml (&(*n), this, roomsetList);
			}
			else
			{
				assert (false); // unknown tag
			}
		}
	}
	makeHitAnim ("monster1", "monster1_h");
	makeHitAnim ("monster2", "monster2_h");
	makeHitAnim ("monster3", "monster3_h");
	makeHitAnim ("monster4", "monster4_h");
	return 1;
}

Resources::~Resources()
{
	{
		map<string, Anim*>::iterator i;
		for (i = animlist.begin(); i != animlist.end(); i++)
		{
			delete (i->second);
		}
	}
	{
		map<string, RoomSet*>::iterator i;
		for (i = roomsetList.begin(); i != roomsetList.end(); i++)
		{
			delete (i->second);
		}
	}
	{
		vector<DATAFILE*>::iterator i;
		for (i = data.begin(); i != data.end(); ++i)
		{
				teg_unload_datafile (*i);
				*i = NULL;
		}
	}
}

FONT *Resources::getFont (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_FONT)
					temp = NULL;
	}
	if (temp)
		return (FONT*)temp->dat;
	else
	{
		allegro_message ("Couldn't find FONT '%s'", id.c_str());			
		exit(1);
	}
	return NULL;	
}

RLE_SPRITE *Resources::getRle (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_RLE_SPRITE)
					temp = NULL;
	}
	
	if (temp)
			return (RLE_SPRITE*)temp->dat;
	else
	{
		if (sprites.find (id) == sprites.end())
		{
			allegro_message ("Couldn't find RLE sprite '%s'", id.c_str());			
			exit(1);
		}
		
		return sprites[id];
	}
	
	assert (false);
	return NULL;
}

SAMPLE *Resources::getSample (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_SAMPLE)
					temp = NULL;
	}
	if (temp)
			return (SAMPLE*)temp->dat;
	else
	{
		allegro_message ("Couldn't find SAMPLE '%s'", id.c_str());			
		exit(1);
	}		
	return NULL;
}

Anim *Resources::getAnim (string id)
{
	if (animlist.find (id) == animlist.end())
	{
		allegro_message ("Couldn't find Animation '%s'", id.c_str());			
		exit(1);
	}
	else
	{
		return animlist[id];
	}
}

TEG_MAP *Resources::getMap (string id)
{
	if (maplist.find (id) == maplist.end())
	{
		allegro_message ("Couldn't find MAP '%s'", id.c_str());			
		exit(1);
	}
	else
	{
		return maplist[id];
	}
}

TEG_TILELIST *Resources::getTilelist (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_TEG_TILELIST)
					temp = NULL;
	}
	if (temp)
			return (TEG_TILELIST*)temp->dat;
	else
	{
		allegro_message ("Couldn't find TILELIST '%s'", id.c_str());			
		exit(1);
	}		
	return NULL;
}

DUH *Resources::getDuh (string id)
{
    if (duhlist.find (id) == duhlist.end())
    {
		allegro_message ("Couldn't find DUH (Music) '%s'", id.c_str());	
		exit(1);
    }
    return duhlist[id];
}

RoomSet *Resources::getRoomSet (string id)
{
    if (roomsetList.find (id) == roomsetList.end())
    {
		allegro_message ("Couldn't find RoomSet '%s'", id.c_str());	
		exit(1);
    }
    return roomsetList[id];
}
