#include <assert.h>
#include "menu.h"
#include "main.h"
#include <math.h>

Menu::Menu(Engine *e) : blinkSpeed (4)
{
	isResume = false;
	subMenu = false;
	waitForKey = false;
	engine = e;
	blinkTimer = 0;
}

Menu::~Menu()
{
}

void Menu::draw (BITMAP *buffer)
{
	clear_to_color (buffer, BLACK);
	int i;
	for (i = 0; i < getMenuItemCount(); i++)
	{
		int color = CYAN;
		if (i == cursor) color = (waitForKey && blinkTimer < 0) ? YELLOW : RED;
		textprintf_centre_ex (buffer, menufont, buffer->w / 2,
			i * (subMenu ? 16 : 30) + 160, color, -1, getMenuItem (i).c_str());
	}				
	textprintf_centre_ex (buffer, menufont, buffer->w / 2,
		360, GREY, -1, getHint (cursor).c_str());
	draw_rle_sprite (buffer, cover, (buffer->w - cover->w) / 2, 80);
}

void Menu::update()
{
	if (++blinkTimer > blinkSpeed) blinkTimer = -blinkSpeed;
		
	if (!waitForKey)
	{
		if (keypressed())
		{
			switch (readkey() >> 8)
			{
				case KEY_ENTER: case KEY_SPACE:
				doMenuItem (cursor);
				engine->playSample (mugly);
				break;
				case KEY_UP: case KEY_LEFT:
				engine->playSample (pong);
				cursor--;				
				if (cursor < 0) cursor = getMenuItemCount() - 1;
				break;					
				case KEY_RIGHT: case KEY_DOWN: case KEY_TAB:
				engine->playSample (pong);
				cursor++;				
				if (cursor >= getMenuItemCount()) cursor = 0;
				break;					
				case KEY_ESC:
				state = 0;
				break;					
			}
		}
	}
	else
	{
		int c = getLastScancode();
		if (c != 0)
		{	
			clear_keybuf();
			if (c == KEY_ESC)
			{
			}
			else
			{				
				switch (cursor)
				{
					case 0: case 1: case 2: case 3: case 4: case 5:	
						settings->getButton(subMenuPlayer)[cursor].setScancode(c);
						set_config_int ("fole1", config_keys[subMenuPlayer][cursor], c);
						break;
					default:
						assert (false);
						break;
				}
			}
			waitForKey = false;
		}
	}
}

void Menu::init(Resources *resources, Settings *_settings)
{ 
	settings = _settings;
	menufont = resources->getFont("METRO");;
	pong = resources->getSample ("pong");
	mugly = resources->getSample ("mugly2");
	cover = resources->getRle("cover");
}

string Menu::getHint(int i)
{
	if (!subMenu)
	{
		switch (i)
		{
			case 1:
				return string ("press enter to turn sound on or off");
				break;
		}
		return string ("");
	}
	else
	{
		switch (i)
		{
			case 0:	case 1: case 2: case 3: case 4: case 5:
				if (!waitForKey)
					return string ("press enter to change key");
				else
					return string ("press a new key or esc to cancel");
				break;
			case 6:
				return string ("press enter to return to main menu");
				break;			
			default:
				assert (false);
				break;
		}
	}
}

int Menu::getMenuItemCount()
{
	if (!subMenu)
	{
		return 6;
	}
	else
	{
		return 7;
	}	
}

string Menu::getMenuItem(int i)
{
	if (!subMenu)
	{
		switch (i)
		{
			case 0:
				if (!isResume)
					return string ("Start game");
				else
					return string ("Resume game");
				break;
			case 1:
				if (settings->isSoundOn())
					return string ("Sound is on");
				else
					return string ("Sound is off");
				break;
			case 2:
				if (settings->numPlayers == 1) 
					return string ("1 player mode");
				else
					return string ("2 player mode");
				break;
			case 3:
				return string ("Configure player 1 keys");
				break;
			case 4:
				return string ("Configure player 2 keys");
				break;			
			case 5:
				return string ("Quit");
			default:
				assert (false);
		}
	}
	else
	{
		switch (i)
		{
			case 0: 
				return string ("left: [" + 
					string (settings->getButton(subMenuPlayer)[btnLeft].name()) + "]");
				break;
			case 1: 
				return string ("right: [" + 
					string (settings->getButton(subMenuPlayer)[btnRight].name()) + "]");
				break;
			case 2: 
				return string ("down: [" + 
					string (settings->getButton(subMenuPlayer)[btnDown].name()) + "]");
				break;
			case 3: 
				return string ("up: [" + 
					string (settings->getButton(subMenuPlayer)[btnUp].name()) + "]");
				break;
			case 4: 
				return string ("action: [" + 
					string (settings->getButton(subMenuPlayer)[btnAction].name()) + "]");
				break;
			case 5:
				return string ("alt: [" + 
					string (settings->getButton(subMenuPlayer)[btnAlt].name()) + "]");
				break;
			case 6:
				return string ("return");
				break;
			default:
				assert (false);
		}		
	}
}

void Menu::doMenuItem(int i)
{
	if (!subMenu)
	{
		switch (i)
		{
			case 0: // start game
				if (isResume) state = 2; else state = 1;
				break;
			case 1: // sound on / off
				settings->setSoundOn (!settings->isSoundOn());
				set_config_int ("fole1", "sound", settings->isSoundOn());
				break;
			case 2: // switch playernum
				if (!isResume)
				{
					settings->numPlayers = 3 - settings->numPlayers;
					set_config_int ("fole1", "numplayers", settings->numPlayers);
				}
				break;
			case 3: // player 1 keys				
				subMenu = true;
				subMenuPlayer = 0;
				cursor = 0;
				break;
			case 4: // player 2 keys
				subMenu = true;
				subMenuPlayer = 1;
				cursor = 0;
				break;
			case 5: // quit
				state = 0;
				break;
			default:
				assert (false);
		} 
	}
	else
	{
		switch (i)
		{
			case 0: case 1: case 2: case 3: case 4: case 5:
				waitForKey = true;
				resetLastScancode(); // start monitoring scancode
				break;
			case 6: // return to main menu
				subMenu = false;
				cursor = 3 + subMenuPlayer;
				break;
			default:
				assert (false);
		}
	}	
}

void Menu::initStart()
{
	isResume = false;
	state = -1;
	cursor = 0;
	clear_keybuf();
}

void Menu::initResume()
{
	isResume = true;
	state = -1;
	cursor = 0;
	clear_keybuf();
}


