#ifndef SETTINGS_H
#define SETTINGS_H

#include "button.h"

enum {	btnLeft = 0, btnRight, btnDown, btnUp, btnAction, btnAlt};

extern const char *config_keys[2][6];

class Settings
{
public:
	
	// game options
	bool fpsOn;
	bool windowed;
	
	int numPlayers;
	
	enum RunMode { RM_NORMAL, RM_TESTVIEW, RM_SMOKETEST };
	RunMode runMode;
	
	Button button[2][6];
	
	Settings(); //  set defaults
	void getFromConfig();
	void getFromArgs(int argc, const char *const *argv);
	
	Button* getButton(int p) { return button[p]; }
	bool isSoundOn() { return soundOn; }
	void setSoundOn(bool value); 
	bool isMusicOn() { return music; }
	void setMusicOn(bool value);

private:	
	bool soundOn;
	bool music;
};

#endif
