#ifndef ANIM_H
#define ANIM_H

#include "resources.h"
#include <stdio.h>
#include <vector>
#include <map>
#include <string>
#include <assert.h>
#include "dom.h"

class Frame
{
public:
	RLE_SPRITE *rle;
	int time;
	int w;
	int h;
	int hotx;
	int hoty;
};

class Anim
{
private:
	std::vector<Frame> frames[4];
public:
	int totalLength[4];
	int totalDirs;
	Anim();
// 	void add (Frame &f, int dir = 0);
	void add (Frame &f, int dir);
// 	int getTotalLength(int dir = 0) { return totalLength[dir]; }
	int getTotalLength(int dir) { return totalLength[dir]; }
	int getTotalDirs() { return totalDirs; }
// 	RLE_SPRITE *getFrameRle (int f, int dir = 0) 
 	RLE_SPRITE *getFrameRle (int f, int dir) 
	{
		assert (f >= 0 && f < getFrameCount(dir));
		assert (dir >= 0 && dir < 4);
		return frames[dir][f].rle;
	}
	Frame *getFrame (int f, int dir)
//	Frame *getFrame (int f, int dir = 0)
	{
		assert (f >= 0 && f < getFrameCount(dir));
		assert (dir >= 0 && dir < 4);
		return &(frames[dir][f]);
	}
//	int getFrameTime (int f, int dir = 0)
	int getFrameTime (int f, int dir)
	{
		assert (f >= 0 && f < getFrameCount(dir));
		assert (dir >= 0 && dir < 4);
		return frames[dir][f].time;
	}
//	int getFrameCount(int dir = 0)
	int getFrameCount(int dir)
	{
		assert (dir >= 0 && dir < 4);
		return frames[dir].size();
	}
	
	static void loadFromXml (xdom::DomNode *n, Resources *res, std::map<std::string, Anim*> &result);
};

#endif
