#!/usr/bin/perl

use strict;
use warnings;
use Archive::Zip qw( :ERROR_CODES :CONSTANTS );

my $zipbasename = "fole1_fix";
my $zipbasedir = "fole1";

my @zips = 
(
	{ 
		post => "win_bin",
		list => "zipbin.txt",
	},
	{ 
		post => "src",
		list => "zipsrc.txt",
	}
);
	
for my $zipinfo (@zips)
{
	open INFILE, $$zipinfo{list} or die "Couldn't open file, $!";
	my @lines = <INFILE>;
	chomp @lines;
	close INFILE;
	
	my @files;
	for (@lines)
	{
		my @temp = grep { -r } glob ($_);
		unless (@temp)
		{
			warn ("Warning: pattern '$_' in $$zipinfo{list} didn't match any files\n");
		}
		push @files, @temp;
	}	
	
	my $fnOut = $zipbasename . "_" . $$zipinfo{post} . ".zip";
	unlink $fnOut;
	my $zip = Archive::Zip->new();	
	for my $file (@files)
	{
		my $member = $zip->addFile( $file, $zipbasedir . "/" . $file );
	}
	die 'write error' unless $zip->writeToFileNamed($fnOut) == AZ_OK;
	print scalar @files, " files written to $fnOut\n";
}
