#include <assert.h>
#include <allegro.h>
#include "testview.h"
#include "resources.h"
#include <map>
#include "engine.h"
#include "anim.h"

void Testview::update ()
{
	framecounter += 25;
	if (key[KEY_UP])
	{
		y_pos--;
	}
	if (key[KEY_DOWN])
	{
		y_pos++;
	}
	if (key[KEY_ESC])
	{
		finished = true;
	}
}

void Testview::draw (BITMAP *buffer)
{
	clear_to_color (buffer, makecol (128, 128, 128));
	
	int x, y, minh;
	x = 5; y = 5; minh = 0;
	
	RLE_SPRITE *s;
	
	map<string, Anim*>::iterator i;
	for (i = resources->animlist.begin(); i != resources->animlist.end(); ++i)
	{
		Anim *a = i->second;
		
		for (int dir = 0; dir < a->getTotalDirs(); ++dir)
		{
			int length = a->getTotalLength(dir);
			int frame = 0;
			int remain = 0;
			if (length > 0) remain = framecounter % length;
			while (remain > a->getFrameTime(frame, dir))
			{
				remain -= a->getFrameTime(frame, dir);
				frame++;
			}
			s = a->getFrameRle (frame, dir);
			draw_rle_sprite (buffer, s, x, y - y_pos + 8);
			
			int width = s->w;			
			if (dir == 0)
			{
				textprintf_ex (buffer, font, x, y - y_pos, makecol (255, 255, 255), -1, 
					"%s", i->first.c_str());
				int text_width = text_length (font, i->first.c_str());
				if (text_width > width) width = text_width;
			}
			
			x += width + 10;
			if (minh < s->h) minh = s-> h;
			if (x > 600)
			{
				y += minh + 16;
				x = 5;
				minh = 0;
			}
		}
	}
}
