#include <assert.h>
#include "anim.h"

using namespace xdom;
using namespace std;

Anim::Anim() : frames()
{
	totalLength[0] = 0;
	totalLength[1] = 0;
	totalLength[2] = 0;
	totalLength[3] = 0;
	totalDirs = 0;
}

void Anim::add (Frame &f, int dir)
{
	frames[dir].push_back(f);
}

void Anim::loadFromXml (DomNode *n, Resources *res, map<string, Anim*> &result)
{
	assert (n->name == "anim");
	Anim *temp;
	string name = n->attributes["name"];
	vector<DomNode>::iterator i;
	vector<DomNode>::iterator h;
	temp = new Anim;
	temp->totalDirs = 0;
	for (h = n->children.begin(); h != n->children.end(); ++h)
	{
		int length = 0;	
		int dir;
		if (h->name == "all")
		{
			assert (temp->totalDirs == 0); // must be only one "all" tag
			dir = -1;
			temp->totalDirs = 1;
		}
		else if (h->name == "up")
		{
			temp->totalDirs++;
			dir = 0;
		}
		else if (h->name == "down")
		{
			temp->totalDirs++;
			dir = 1;
		}
		else if (h->name == "left")
		{
			temp->totalDirs++;
			dir = 2;
		}			
		else if (h->name == "right")
		{
			temp->totalDirs++;
			dir = 3;
		}
		else 
			assert (false); // unknown tag
		
		for (i = h->children.begin(); i != h->children.end(); ++i)
		{
			Frame frame;
			assert (i->name == "frame");
			frame.time = atoi(i->attributes["time"].c_str());
			length += frame.time;
			frame.rle = res->getRle (i->attributes["rle"]);
			if (!frame.rle)
			{
				allegro_message ("error loading frame of animation %s", name.c_str());
			}
			frame.w = atoi(i->attributes["w"].c_str());
			frame.h = atoi(i->attributes["h"].c_str());
			frame.hotx = atoi(i->attributes["hotx"].c_str());
			frame.hoty = atoi(i->attributes["hoty"].c_str());
			if (dir == -1)
			{
				for (int k = 0; k < 4; ++k)
					temp->frames[k].push_back(frame);
			}
			else
				temp->frames[dir].push_back(frame);
		}
		if (dir == -1)
		{
			for (int k = 0; k < 4; ++k)
				temp->totalLength[k] = length;
		}
		else
			temp->totalLength[dir] = length;
	}
	assert (temp->totalDirs == 1 || temp->totalDirs == 4); 
	// either "all"  (meaning all the same) or four dirs
	
	result.insert (pair<string, Anim*>(name, temp));
}
