#include <allegro.h>
#include <map>
#include <string>
#include <vector>
#include <tegel.h>
#include <aldumb.h>

#ifndef RESOURCES_H
#define RESOURCES_H

class Anim;
class RoomSet;
	
class Resources
{
	friend class Testview; // for debugging
	
	std::vector<DATAFILE*> data;
	std::vector<TEG_MAP*> maps; // seperately loaded maps
	std::map<std::string, RLE_SPRITE*> sprites; // seperately loaded bitmaps
	
	std::map <std::string, Anim*> animlist;
	std::map <std::string, RoomSet*> roomsetList;
	std::map <std::string, TEG_MAP*> maplist;	
	std::map <std::string, DUH*> duhlist;

	std::vector <RLE_SPRITE*> generated; // run-time generated RLE's
 	void makeHitAnim (const std::string &id, const std::string &id2);
public:
	int init(); // loads resources
	~Resources();
	
	Anim *getAnim (std::string id);
	FONT *getFont (std::string id);
	RLE_SPRITE *getRle (std::string id);
	SAMPLE *getSample (std::string id);  
	TEG_MAP *getMap (std::string id);
	TEG_TILELIST *getTilelist (std::string id);
	DUH *getDuh (std::string id);
	RoomSet *getRoomSet (std::string id);
};

#endif
