#ifndef OBJECT_H
#define OBJECT_H

#include <allegro.h>
#include <list>
#include <map>
#include "tegel.h"
#include "level.h"

// tile stack properties
#define TS_SOLID 0x01

class Objects;
class Engine;
class Anim;
class Resources;

enum Dir {UP, DOWN, LEFT, RIGHT};

enum ObjectType { OT_MONSTER, OT_BULLET, OT_PLAYER, OT_DOOR, OT_TELEPORT, OT_BANANA };

static const int dir_mult[2][4] = { { 0, 0, -1, 1 }, {-1, 1, 0, 0 } };

// in this class,
// current is not guaranteed to be set.
// parent is not guaranteed to be set,
// although it should be when the first update / draw is called.
class Room;

class Object
{
private:
	int frame;
	int animcounter;	

	fix z;
	int level;
	fix x, y;
	Anim *current;
	
	Resources *getResources(); // depracated
	Dir dir;
	
protected:

		
	int sprdx, sprdy;
	int w, h;
	bool solid;
	bool alive;
	bool visible;
	void setAnim (Anim *a);
	Objects* parent;
	Engine *e;
	Room *room;
	
	void kill () { alive = false; }
	int getTileStackFlags(int mx, int my);
public:
	Dir getDir() { return dir; }
	void setDir(Dir _dir);
	
	Object (Room *r);
	virtual ~Object () {}
	void setParent (Objects *p);
	
	//fixed getShadowX();
	
	//bool isWalking(); // walking or flying?
	bool isSolid() { return solid; } // can collide with other stuff?
	bool isVisible() { return visible; } // to be drawn?
	//bool hasShadow(); // draw a shadow?
	bool isAlive() { return alive; } // if not, scheduled to be killed
	//virtual int getType();
	//virtual int getClass();
			
	RLE_SPRITE *getSprite ();
	
	TEG_MAP *getMap();
	void try_move (fix dx, fix dy);
	virtual void setLocation (fix nx, fix ny);
	void setRoom (Room *_room);
	Room *getRoom () { return room; }
	int getSprx () { return x + sprdx; }
	int getSpry () { return y + sprdy; }
	fix getx () { return x; }
	fix gety () { return y; }
	int getw () { return w; }
	int geth () { return h; }
	virtual void update();
	int getLevel () { return level; }
	virtual ObjectType getType () = 0;
	virtual void handleCollission(Object *o) = 0;
};

class Objects
{
private:
	Engine *parent;
	std::list <Object*> objects;	
public:
	Objects (Engine *p) { parent = p; }
	Engine *getParent() { return parent; }
	void add(Object *o);
	
	void update();
	void killAll();
	void draw (BITMAP *buffer, Room *room, int cx, int cy, int cw, int ch, int xofst, int yofst);
	int size() { return objects.size(); }; // returns # of objects
};

#endif
