
#ifndef MENU_H
#define MENU_H

#include <allegro.h>
#include <string>
#include "settings.h"
#include "anim.h"

class Engine;

class Menu
{
	int state;
	// -1 = showing, 0 = quit, 1 = start new, 2 = resume

	bool subMenu;
	int subMenuPlayer;
		
	bool waitForKey;
	bool isResume;
	int blinkTimer;
	const int blinkSpeed;
	
	Engine *engine;
	Settings *settings;
	
	std::string getMenuItem(int i);
	std::string getHint(int i);
	void doMenuItem(int i);
	int cursor;
	FONT *menufont;
	
	SAMPLE *pong;
	SAMPLE *mugly;
	
	RLE_SPRITE *cover;
	
	int getMenuItemCount();
public:
	Menu(Engine *p);
	~Menu(); 
	void draw (BITMAP *buffer);
	void update();
	void init (Resources *resources, Settings *s); 

	void done () {  }
	void initStart();
	void initResume();  
	int getState() { return state; }
};

#endif

