#ifndef MAIN_H
#define MAIN_H

#include <allegro.h>
#include "resources.h"
#include "engine.h"
#include "menu.h"
#include "settings.h"
#include "testview.h"

class Main
{
private:
	BITMAP *buffer;
	Resources resources;
	Engine engine;
	Menu menu;
	Settings settings;
	Testview testview;
	
	int frame_count;
	int frame_counter;
	int last_fps;
	int update_counter;
	
	
	enum MainState {UNKNOWN1 = 0, MENU = 1, QUIT = 2, UNKNOWN2, GAME, TESTVIEW, SMOKETEST };
	//state machine
	MainState state; 
	// start menu, resume menu, playing, quitting
	
	void draw ();
	void update ();
	
	static void timer_handler();
	static volatile int counter;
public:
	static const int update_speed = 20;

	int getCounter () { return counter; }
	Settings *getSettings() { return &settings; }
	Resources* getResources () { return &resources; }
	
	Main ();
	int init(int argc, const char *const *argv);
	void run();
	void done();
	~Main();		
};

#endif
