#ifndef ENGINE_H
#define ENGINE_H

#include <allegro.h>
#include "object.h"
#include <tegel.h>
#include "button.h"
#include "settings.h"
#include "resources.h"
#include "view.h"
#include "level.h"
#include <aldumb.h>

using namespace std;

class Main;
class Player;

class Engine
{
public:
	enum GameState {GS_INTRO, GS_PLAY, GS_MENU_RESUME, GS_DONE, GS_OUTRO};
private:
	
	static const int defaultGameTime = 180000; // 180 sec = 3 min
	static const int defaultMonsterHp = 5;
	static const int monsterHpIncrease = 2;
	static const int gameTimeIncrease = 60000;

	GameState state;
	GameState oldState;

	int introTimer;
	int outroTimer;

	int gameTimer; // time left before game over!
	int bananaCount;

	unsigned int currentLevel; // index of current Level

	Main *parent;
	   
	Objects objects;
	Player *player[2];
	PlayerState ps[2];
	bool debug;
	
	Level *level;
	
	Settings *settings;
	Resources *resources;
	
	View view[2]; // a view for each player
	
	void teg_partdraw_rle (BITMAP *bmp, const TEG_MAP* map, int layer, int x, int y, int w, int h, int xview, int yview);

	FONT *gamefont;
	void drawStatus (BITMAP *buffer, int x, int y, PlayerState *ps);
	
	string gameover_message;

public:
	Player *getNearestPlayer (Object *o);
	int monsterHp;
	Engine (Main *p);
	Resources *getResources() { return resources; }
	Main *getParent() { return parent; }
	void initGame ();
	void init(); // call once during startup
	void resume ();
	void draw (BITMAP *buffer);
	void update ();
	GameState getState () { return state; }
	
	void nextLevel(); // called when player reaches exit
	void initLevel (); // for beginning a new level
	
	void doneLevel (); // clean up objects etc.
	void done(); // stop music
	bool isDebug () { return debug; }
	int getCurrentLevel () { return currentLevel; }

	int getCounter ();
		
	void playSample (SAMPLE *s);
	void playMusic (const char *id);
	void stopMusic ();

	Button* getButton(int p);	
	AL_DUH_PLAYER *dp;
};

#endif
