/****************************Project*******************************
 * This Project is called "Sudoku Assistant" It provides a Sudoku 
 * 9x9 grid for the player to solve Sudoku puzzels. I provide tool
 * options for the player like error detection and valid number 
 * identification. This program is not ment to solve Sudoku puzzels
 * by itself but rather augment a human player's ability yo solve the
 * puzzel. The Program will also have the ability to store puzzels 
 * previously solved by the player and rehash the numbers to make it seem 
 * a new puzzel.
 * 04/21/05
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the main function file. I hold the main funtion which creates 
 * the world and passes important data to it. I also am responsible
 * for the screen rendering, World update calling and maintaining 
 * the semaphores that prevent them from clobbering each other.
 * 
 * This File Was Written:
 * 04/21/05
 * By:
 * Wilson Saunders
 ******************************************************************/

#include <allegro.h>
#include "world.h"
#include "ScreenDiv.h"


// Globals
World * myWorld;



/******************************************************************
 * I am timer call back function
 *****************************************************************/
void UpdateFunc(){
//	myMenue->Update();
	myWorld->Update();
	return;
}

/******************************************************************
 * I am the program starting point and guardian of the game loop
 *****************************************************************/
int main(int argc, char *argv[])
{
	bool notDone = true;
	

		////////////////////////////////////////////
		//			Initilization Section
		////////////////////////////////////////////
	allegro_init();
	install_keyboard(); 
	install_mouse();

	set_color_depth(16);

		// initilize window
	//GFX_AUTODETECT_FULLSCREEN
	//GFX_AUTODETECT_WINDOWED
//	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 1024, 768, 0, 0) != 0) {
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 400, 540, 0, 0) != 0) {
			// if you are here graphic initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Graphics Initilization Failed");
		return 1;
	}
	
		// initilize world
	myWorld = new World;
//	myMenue = new Menue;
//	DrawBuffer = create_bitmap( SCREEN_W, SCREEN_H);
//	myGrid = new Grid;
//	myGrid->ink = load_bitmap("Textures\\numbers.bmp", palette);
//	myGrid->temp = create_bitmap( myGrid->ink->w/3, myGrid->ink->h/3);
	rest(100);	// wait for world to finish initilization
				// before starting timer


		// initilize timer
	if ( install_int(UpdateFunc, 40) != 0){
			// if you are here timer initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Timer Initilization Failed");
		return 1;
	}
		// intilize Mouse
	if ( install_mouse() == -1){
			// if you are here timer initilization failed
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Mouse Initilization Failed");
		return 1;
	}
		// initilize sound
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      allegro_message("Sound Initilization Failed");
      return 1;
    }
	

		////////////////////////////////////////////
		//			Game Loop Sections
		////////////////////////////////////////////
	while ( notDone )
	{
			// check keyboard for interface
		if (key[KEY_ESC]) notDone = false;	// we are now done
//		if (myMenue->isExit) notDone = false;


//		myMenue->Draw();
		myWorld->Draw();
		

		
		vsync();
//		blit( myMenue->myWorld->DrawBuffer , screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
		blit( myWorld->DrawBuffer , screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
//		blit( DrawBuffer , screen, 0,0, 0,0, SCREEN_W, SCREEN_H);

	}	
		////////////////////////////////////////////
		//			Clean Up Time
		////////////////////////////////////////////
	allegro_exit(); 
//	delete(myWorld);

	return 0;
}
END_OF_MAIN();