/****************************Project*******************************
 * This Project is called "Sudoku Assistant" It provides a Sudoku 
 * 9x9 grid for the player to solve Sudoku puzzels. I provide tool
 * options for the player like error detection and valid number 
 * identification. This program is not ment to solve Sudoku puzzels
 * by itself but rather augment a human player's ability yo solve the
 * puzzel. The Program will also have the ability to store puzzels 
 * previously solved by the player and rehash the numbers to make it seem 
 * a new puzzel.
 * 04/21/05
 * By:
 * Wilson Saunders
 ******************************File********************************
 * I am the Dependancey Grid Class I am a wrapper for an 81x21 array
 * of integers that store each sudoku grid node's relation to the
 * relating grid nodes of it's column row and square.
 * 
 * This File Was Written:
 * 04/21/05
 * By:
 * Wilson Saunders
 ******************************************************************/

#include "depGrid.h"

/*****************************************************************
 * I am the constructor I set the internal defaults
 ******************************************************************/
DepGrid::DepGrid(){
	int itor1, itor2;
	for(itor1 = 0; itor1 < 81; itor1++){
			// clear this entry to -1
		for(itor2 = 0; itor2 < 21; itor2 ++){
			data[itor1][itor2]= -1;
		}
			// first element for all nodes is the 
			// nodes own value
		addElement(itor1,itor1);
			// now fill the data with values of the square
			// row and collum
		fillSquare(itor1);
		fillRow(itor1);
		fillCol(itor1);
	}
}




/*****************************************************************
 * I am the destructor I exist for good form
 ******************************************************************/
DepGrid::~DepGrid(){}


/*****************************************************************
 * I am the accessor I return the value of the data indexed by loc 
 * and place. I do bounds checking to ensure we have valid data
 ******************************************************************/
int DepGrid::GetVal(int loc, int place){
	if (loc < 0) loc = 0;
	if (loc > 80) loc = 80;
	if (place < 0) place = 0;
	if (place > 20) place = 20;

	return data[loc][place];
}


/*****************************************************************
 * I am the element adder funciton. I add the value in val to the 
 * grid location specified at loc. If a duplicate is encountered
 * I return without adding the val to the list
 ******************************************************************/
void DepGrid::addElement(int loc, int val){
	int itor;

	for(itor = 0; itor < 21; itor++){
			// add val to end of valid data then return
		if(data[loc][itor] < 0){
			data[loc][itor] = val;
			return;
		}	
			// exit on duplicate
		if(data[loc][itor] == val) return;

	}
	return;
}

/*
		case 0:  case 1:  case 2:  case 3:  case 4:  case 5:  case 6:  case 7:  case 8:    
		case 9:  case 10: case 11: case 12: case 13: case 14: case 15: case 16: case 17:  
		case 18: case 19: case 20: case 21: case 22: case 23: case 24: case 25: case 26: 
		case 27: case 28: case 29: case 30: case 31: case 32: case 33: case 34: case 35: 
		case 36: case 37: case 38: case 39: case 40: case 41: case 42: case 43: case 44: 
		case 45: case 46: case 47: case 48: case 49: case 50: case 51: case 52: case 53: 
		case 54: case 55: case 56: case 57: case 58: case 59: case 60: case 61: case 62:  
		case 63: case 64: case 65: case 66: case 67: case 68: case 69: case 70: case 71: 
		case 72: case 73: case 74: case 75: case 76: case 77: case 78: case 79: case 80: 
			*/

/*****************************************************************
 * I am the square value filler, I determine which of the 9 squares 
 * this loc is accessing then add the rest of its componenets
 ******************************************************************/
void DepGrid::fillSquare(int loc){
	switch(loc){
			// top left
		case 0:  case 1:  case 2:      
		case 9:  case 10: case 11:  
		case 18: case 19: case 20: 
			addElement(loc, 0); addElement(loc, 1); addElement(loc, 2);
			addElement(loc, 9); addElement(loc, 10); addElement(loc, 11);
			addElement(loc, 18); addElement(loc, 19); addElement(loc, 20);
		break;
			// mid left
		case 27: case 28: case 29: 
		case 36: case 37: case 38:  
		case 45: case 46: case 47: 
			addElement(loc, 27); addElement(loc, 28); addElement(loc, 29);
			addElement(loc, 36); addElement(loc, 37); addElement(loc, 38);
			addElement(loc, 45); addElement(loc, 46); addElement(loc, 47);
		break;
			// low left
		case 54: case 55: case 56:  
		case 63: case 64: case 65: 
		case 72: case 73: case 74: 
			addElement(loc, 54); addElement(loc, 55); addElement(loc, 56);
			addElement(loc, 63); addElement(loc, 64); addElement(loc, 65);
			addElement(loc, 72); addElement(loc, 73); addElement(loc, 74);

		break;
			// mid top
		case 3:  case 4:  case 5:    
		case 12: case 13: case 14: 
		case 21: case 22: case 23:
			addElement(loc, 3); addElement(loc, 4); addElement(loc, 5);
			addElement(loc, 12); addElement(loc, 13); addElement(loc, 14);
			addElement(loc, 21); addElement(loc, 22); addElement(loc, 23);

		break;
			// mid mid
		case 30: case 31: case 32: 
		case 39: case 40: case 41:  
		case 48: case 49: case 50: 
			addElement(loc, 30); addElement(loc, 31); addElement(loc, 32);
			addElement(loc, 39); addElement(loc, 40); addElement(loc, 41);
			addElement(loc, 48); addElement(loc, 49); addElement(loc, 50);
			
		break;
			// mid low
		case 57: case 58: case 59:
		case 66: case 67: case 68:  
		case 75: case 76: case 77: 
			addElement(loc, 57); addElement(loc, 58); addElement(loc, 59);
			addElement(loc, 66); addElement(loc, 67); addElement(loc, 68);
			addElement(loc, 75); addElement(loc, 76); addElement(loc, 77);
			
		break;
			// right top
		case 6:  case 7:  case 8:    
		case 15: case 16: case 17:  
		case 24: case 25: case 26: 
			addElement(loc, 6); addElement(loc, 7); addElement(loc, 8);
			addElement(loc, 15); addElement(loc, 16); addElement(loc, 17);
			addElement(loc, 24); addElement(loc, 25); addElement(loc, 26);

		break;
			// right mid
		case 33: case 34: case 35: 
		case 42: case 43: case 44: 
		case 51: case 52: case 53: 
			addElement(loc, 33); addElement(loc, 34); addElement(loc, 35);
			addElement(loc, 42); addElement(loc, 43); addElement(loc, 44);
			addElement(loc, 51); addElement(loc, 52); addElement(loc, 53);
			
		break;
			// right low
		case 60: case 61: case 62:  
		case 69: case 70: case 71: 
		case 78: case 79: case 80: 
			addElement(loc, 60); addElement(loc, 61); addElement(loc, 62);
			addElement(loc, 69); addElement(loc, 70); addElement(loc, 71);
			addElement(loc, 78); addElement(loc, 79); addElement(loc, 80);
			
		break;
	}
}


/*****************************************************************
 * I am the column filler, I determine which of the 9 columns
 * this loc is accessing then add the rest of its componenets
 ******************************************************************/
void DepGrid::fillCol(int loc){
	int itor;
	
	for(itor = 0; itor < 9 ;itor++){
		addElement(loc, loc%9+itor*9);
	}
	return;
}

/*****************************************************************
 * I am the row value filler, I determine which of the 9 rows 
 * this loc is accessing then add the rest of its componenets
 ******************************************************************/
void DepGrid::fillRow(int loc){
	int itor;
	
	for(itor = 0; itor < 9 ;itor++){
		addElement(loc, (loc/9)*9+itor);
	}
	return;
}

