/*
SpeedHack2006 Entry
by Mehdi Cherti 2006
Part of SpeedHack entry (2006) project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
*/

#include <allegro.h>
#include "sound.h"
Sound ::  Sound () {
	dat=NULL;midis=0;samples=0;
}

Sound :: ~Sound (){
	if(midis) {free(midis);midis=0;}
	if(samples) {free(samples);samples=0;}
}

int* search_data (DATAFILE *dat , int type){
	DATAFILE *d=dat;
	int *ret=0,m=0,i=0;
	while (d->dat){
		if(d->type == type){
			m++;
			ret = (int*)realloc(ret,sizeof(int)*(m+1));
			ret[m-1] = i;
			ret[m]=-1;
		}
		d++;i++;
	}
	return ret;

}
void Sound :: find () {
	int m=0,i=0;
	if(!dat) return;
	if(midis) free(midis);
	if(samples) free(samples);
	midis = search_data (dat , DAT_MIDI);
	samples = search_data (dat , DAT_SAMPLE);
}

void Sound :: Play_midi (int n,int l){
	if(!midis||!dat) return;
	play_midi ((MIDI*)(dat[midis[n]].dat),l);
}

void Sound :: Play_sample (int n,int l){
	if(!samples||!dat) return;
	play_sample ((SAMPLE*)dat[samples[n]].dat,255,128,1000,l);
}
