/*
SpeedHack2006 Entry
by Mehdi Cherti 2006
Part of SpeedHack entry (2006) project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
*/
#include "game.h"
#include <stdlib.h>
#include <string.h>

#include <stdio.h>


int ToAnim (int a){
	switch(a){
		case 0 : return 1;
		case 1 : return 3;
		case 2 : return 0;
		case 3 : return 2;
	}
	return 0;
}

Perso :: Perso () {
	trans = 0;
	toogle.en = 0;
	shoot.en = 0;
	HP = 0;
	HPMAX = 0;
	p1x = 0;
	p2x = 0;
	p1y = 0;
	p2y = 0;
	sens = 0;
	gravite = 0;
	jump = 0;
	M=0;
	score=0;
	mx = 0; my = 0;sx = 0; sy = 0;
	id   = 0;
	car = NULL;
	_psx = 0;
	max_jump = 2;
	_psy = 0;
	_dir = Droite;
	_charset=NULL;
	_ImType = IM_NORMAL;
	AnimMax = AnimMaxDefault;
	_charset_max_x = 3;
	_charset_max_y = 4;
	memset (&i , 0,sizeof(PersoImages));
}

void Perso :: set_map (int x,int y){
	if(x != -1) mx = x;
	if(y != -1) my = y;
}

void Perso :: set_screen (int x,int y){
	if(x != -1) sx = x;
	if(y != -1) sy = y;
}

void Perso :: move (int d,int f){
	int i;
	bool n=0;
	
	if(!M) return;
	if(d != -1) _dir=d;
	n=1;
	switch(_dir){
		case Droite : if(sx >= _psx) n=0; if(mx+f>=M->w()) n=1;break;
		case Gauche : if(sx >= _psx) n=0; if(mx-f<0) n=1;break;	 
		case Haut   : if(sy >= _psy) n=0; if(my-f<0) n=1;break;
		case Bas    : if(sy >= _psy) n=0; if(my+f>=M->h()) n=1;break;			    
	}
	n=1;
	if(!n){
	switch (_dir){
		case Droite : mx +=f ;break;
		case Gauche : mx -=f ;break;
		case Haut   : my -=f ;break;
		case Bas    : my +=f ;break;	   
	}
	 M->x(mx);
	 M->y(my);
	}
	else{

		switch(_dir){
			case Droite : sx += f;break;
			case Gauche : sx -= f;break;
			case Haut   : sy -= f;	break;
			case Bas    : sy += f;	break;			       
		}
	}
}
void Perso :: show (BITMAP *bmp , DATAFILE *dat) {
	int a=ImType();
	if(a == IM_NORMAL){
		
		int I=i.im [(sens*AnimMax)+i.anim];
		if(I >=0) draw_sprite (bmp , (BITMAP*)dat[I].dat,sx,sy);
		else draw_sprite_h_flip(bmp,(BITMAP*)dat[-I].dat,sx,sy);
	}
	else if(a == IM_CHARSET){
		int xp,yp;
		int a1=0;
		for(yp = 0; yp < car->h ; yp += _charset_max_y){
			for(xp = 0 ; xp < car->w ; xp += _charset_max_x){
				if(_charset_perso == a1){
					int x,y,ddx , ddy;
					ddx = xp;
					ddy = yp;
					for(y = ddy ; y < ddy + _charset_max_y ; y++){
						for(x = ddx ; x < ddx + _charset_max_x ; x++){

							if((x-ddx == i.anim) && ((y-ddy) == ToAnim(dir()))){
								carreau_draw_sprite (car , bmp , x , y , sx , sy);
							}
						}
					}
				}
				a1++;
			}
		}
	}
	
}

void Perso::charset_init (BITMAP *bmp , int wc , int hc,int p){
	_ImType = IM_CHARSET;
	_charset =  create_bitmap( bmp->w , bmp->h);
	blit (bmp , _charset , 0,0,0,0,bmp->w , bmp->h);
	car = create_carreau (_charset , wc , hc); 
	carreau_set_destroy_bmp (car , 1);
	_charset_perso = p;
}
void Perso :: set_map (Map *m){
	M = m;
	
}
Perso :: ~Perso (){
	if(car) {destroy_carreau (car);car=0;_charset = 0;}
}

const char *get_name (DATAFILE *a , int b){
	return get_datafile_property (a+b,DAT_NAME);
}
void Perso :: hbs (){
	if(dir() == 0){
		p1x = (scx () + M->wc ()) / M->wc ();
		p1y = (scy ()) / M->hc ();
	//	p2x = (scx () + M->wc()) / M->hc ();
	//	p2y = (scy() + M->hc ()) /M->hc ();
		
		p2x = p1x;
		p2y = p1y;
	}
	if(dir () == 1){
		p1x = scx() / M->wc ();
		p1y = scy () / M->hc ();
		/*
		p2x = (scx ()) / M->wc ();
		p2y =  (scy()+M->hc())/M->hc ();
		*/
		p2x = p1x;
		p2y = p1y;
	}
	if(dir () == 2){
		p1x = scx() / M->wc ();
		p1y = scy () / M->hc ();
		p2x = (scx ()+M->wc()) / M->wc ();
		p2y  = scy() / M->hc ();
		
	}
	if(dir() == 3){
		p1x = scx() / M->wc ();
		p1y = (scy ()+M->hc()) / M->hc ();
		p2x = (scx () + M->wc ()) / M->wc ();
		p2y = (scy() + M->hc ()) / M->hc ();
	}	
}

int hbs_object(int lay,int x,int y){
	int tile = map.get(lay,x,y);
	const char *name = get_name(tiles,tile);
	if(name[strlen(name)-1] == 'M') return 1;
	return 0;
}

int is_toogle (int obs){
	const char *n = get_name (tiles,obs);
	if(n[strlen(n)-2] == 'T') return 1;
	return 0;
}
void Perso :: do_things (int x , int y){
	int i;
	int obj = map.get (0,x,y);
	if(is_toogle (obj) && dir()==2){
		if(!toogle.en){
		toogle.x = x;
		toogle.y = y;
		toogle.en = 1;
		toogle.xshow = toogle.x * map.wc ();
		toogle.yshow = toogle.y * map.hc ();
			{
				int e;
				PMASK *p2 = create_allegro_pmask ((BITMAP*)tiles[obj].dat);
				if(p2){
				for(e = 0; e < max_items ; e++){
					TOOGLE *item = get_item (e);
					if(item->en){
					PMASK *p1 = create_allegro_pmask ((BITMAP*)tiles[item->img].dat);
					if(p1){
					if(check_pmask_collision (p1 , p2 , item->xshow , item->yshow , toogle.xshow , toogle.yshow - M->hc () )){
						if (item->dir == 0) item->dir = 1;
						else if (item->dir == 1) item->dir = 0;
						item->precdir = item->dir;
					}
					destroy_pmask (p1);
				}
				}
				}
				}

				destroy_pmask (p2);

			}

		for(i = 0 ; i < 2 ; i++){
			p(i)->hbs ();
			int dx = p(i)->scx () / map.wc ();
			int dy = p(i)->scy () /map.hc ();
			/* check collision */
			
			if( (p(i)->p1x == x && p(i)->p1y+1 == y) || (p(i)->p2x == x && p(i)->p2y+1==y) || (dx == x  && dy+1==y)){
				p(i)->start_jump (2);
				
			}
		}
		}
	}
}
void Perso :: toogle_update (){
	toogle.yshow -= 8;
	if(toogle.yshow <= ((toogle.y-1)*(map.hc()))){
		toogle.en = 0;
	}
	
}
void Perso :: toogle_show (BITMAP *buffer , DATAFILE *dat , OBS *obs , int x , int y){
	draw_sprite ( buffer  , 
		      (BITMAP*)dat[obs->image].dat,
		      x , y);

}
void Perso :: move2 (int d,int max){
	int o1 , o2 , o3;
	dir (d);
	
		
	if(d == 0){ scx (scx() + max);sens = 0;}
	else if (d== 1) {scx (scx() -max); sens = 1;}
	else if (d == 2) scy (scy() - max);
	else if (d == 3) scy (scy() + max);
	if(scx () >= map.ws ()-map.wc() && d == 0) scx (0);
	else if(scx () <= 0 && d == 1) scx (map.ws ()-map.wc());

	hbs ();
	

	if(hbs_object (0 , p1x , p1y) || hbs_object (0 ,p2x,p2y) || hbs_object (0 , scx()/M->wc() , (scy()/M->hc()))){
		if(d == 0) scx (scx() - max);
		else if (d== 1) scx (scx() +max);
		else if (d == 2) {
			if(scy () <= 0){ scy (scy () + max);jump = 0;}
			scy (scy()+ max);
			jump = 0;
			gravite = 1;
		}
		else if (d == 3) {
			gravite = 0;
			scy (scy() - max);
			scy ((((scy()+max) / M->hc()))*M->hc());

//			scy (scy() - max);
		}

	
	}

	do_things (p1x , p1y);
	do_things (p2x , p2y);
	do_things (scx()/map.wc() , scy()/map.hc());
	
}

void Perso :: start_jump (int max_c){
	if(gravite) return;
	jump = 1;
	max_car = max_c * M->wc () ;
	prec_y = 0;
}
void Perso :: start_gravite (int max_c){
	gravite = 1;
	max_car = max_c * M->wc ();
	prec_y  = 0;
}
int voice_sample=0;
void Perso :: do_gravite (){
	 move2 ( Bas , 8);

  	 PMASK *p1 = create_allegro_pmask ((BITMAP*)perso_data[p(0)->i.im[0]].dat);
	 PMASK *p2 = create_allegro_pmask ((BITMAP*)perso_data[p(1)->i.im[0]].dat);
	 
 	 if(p1 && p2 && check_pmask_collision (p1 , p2 , p(0)->scx(),p(0)->scy() , p(1)->scx(),p(1)->scy() )){
		p(id)->start_jump (2);
		if((voice_sample != 0 && voice_get_position(voice_sample) == -1) || voice_sample==0){
			voice_sample  = play_sfx (SFX02);	
		}
 	 }
	 
	 if(p1) destroy_pmask (p1);
	 if(p2) destroy_pmask (p2);
}
void Perso :: update (){

	if(jump ){
		move2 (Haut , 8);
		prec_y += 8;
		if(prec_y >= max_car) {
			jump = 0;
			gravite = 1;
		}
	}
	if(gravite || !jump){
		do_gravite ();
	}
}


/* init perso function */
void init_perso (){
	int i;
	for(i = 0 ; i < 2 ; i++){
		Perso *pp = p(i);
		pp->id = i;
		pp->set_map (&map);
		pp->HPMAX = 10;
		pp->HP = pp->HPMAX;
		pp->BANANAS = default_bananas;
		if(i == 0){
		pp->i.im [0] = P00;
		pp->i.im [1] = P01;

		pp->i.im [2] = -P00;
		pp->i.im [3] = -P01;

		pp->i.im [4] = P00;
		pp->i.im [5] = P01;
		pp->i.im [6] = P00;
		pp->i.im [7] = P01;
		pp->scx (0);
		pp->dir (Droite);


		}
		if(i== 1){
		
		pp->i.im [0] = P10;
		pp->i.im [1] = P11;

		pp->i.im [2] = -P10;
		pp->i.im [3] = -P11;

		pp->i.im [4] = P10;
		pp->i.im [5] = P11;
		pp->i.im [6] = P10;
		pp->i.im [7] = P11;
		pp->scx (12*map.wc());
		pp->dir (1);
		pp->sens = 1 ;

		}


		pp->HP = pp->HPMAX;
		pp->max_jump = 2;	
		pp->i.anim = 0;
		pp->scy (map.hs () - map.hc ()  * 2);
		pp->zid_time = 30;
	}
	
}
