/*
SpeedHack2006 Entry
by Mehdi Cherti 2006
Part of SpeedHack entry (2006) project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
*/

#include "game.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

extern Map map;
/************ Map::load *************/
void Map :: load (const char *file){
	PACKFILE *f;
	char buf [] = MapHeader;
	f = pack_fopen( file  , "rp");
	if(!f) return;
	pack_fread (buf,strlen(buf),f);
	if(strcmp(buf,MapHeader)) {pack_fclose(f);return;}
	pack_fread (&_w   , sizeof(int),f);
	pack_fread (&_h   , sizeof(int),f);
	pack_fread (&_wc  , sizeof(int),f);
	pack_fread (&_hc  , sizeof(int),f);
	pack_fread (&_lay , sizeof(int),f);
	pack_fread (&_ws  , sizeof(int),f);
	pack_fread (&_hs  , sizeof(int),f);
	resize (_w , _h);
	pack_fread (obs , sizeof(OBS) * (_w * _h * _lay),f);

	pack_fclose (f);
}
/************ Map::show **************/
void Map :: show (BITMAP *buffer,DATAFILE *dat,int lay){
	if(lay != -1){
		int i;
		int t=(_w*_h*lay) ;
		int xp,yp;
		int x=0,y=0;
		int a=0,b=0;
		int s=0,ss=0;
		int tg=0;
		int ppp;
		for(yp = _y ; yp < _y+(_hs/_hc)+ss ; yp ++){
			for(xp = _x ; xp < _x+(_ws/_wc)+s ; xp++){
				for(ppp = 0 ;  ppp < 2 ; ppp++){
					if(p(ppp)->toogle.en && p(ppp)->toogle.x == xp && p(ppp)->toogle.y == yp && lay == 0){
						p(ppp)->toogle_show (buffer,dat,obs+t+xp+yp*_w,p(ppp)->toogle.xshow,p(ppp)->toogle.yshow);
						tg = 1;
					}
				}	
				if(!tg) draw_obs (buffer,dat,obs+t+xp+yp*_w , x+a , y+b);
				else tg=0;
				x+=_wc;
				if(x >= _ws) x=0;
			}
			y+=_hc;
			if(yp >= _h-1) break;
		}
	}
	else {
	}
}

/************ Map::show2 **************/
void Map :: show2 (void (*f)(Map *m,BITMAP *,DATAFILE *,OBS *s,int,int),
BITMAP *buffer,DATAFILE *dat,int lay){
	if(lay != -1){
		int i;
		int t=(_w*_h*lay) ;
		int xp,yp;
		int x=0,y=0;
		for(yp = _y ; yp < _y+(_hs/_hc) ; yp ++){
			for(xp = _x ; xp < _x+(_ws/_wc) ; xp++){
				(*f)(this,buffer,dat,obs+t+xp+yp*_w,x,y);
				x+=_wc;
				if(x >= _ws) x=0;
			}
			y+=_hc;
			if(yp >= _h-1) break;
		}
	}
	else {
	}
}


void Map :: tkadida () {
	if(_x > _w) _x=_w;
	if(_x < 0) _x=0;
	if(_y > _h) _y=_h;
	if(_y < 0) _y=0;
}


/************* Map::save *************/
void Map :: save (const char *file){
	PACKFILE *f;
	char *HEADER = MapHeader;
	f =  pack_fopen (file , "wp");
	if(!f) return;
	pack_fwrite (MapHeader , strlen(MapHeader),f);
	pack_fwrite (&_w   , sizeof(int),f);
	pack_fwrite (&_h   , sizeof(int),f);
	pack_fwrite (&_wc  , sizeof(int),f);
	pack_fwrite (&_hc  , sizeof(int),f);
	pack_fwrite (&_lay , sizeof(int),f);
	pack_fwrite (&_ws  , sizeof(int),f);
	pack_fwrite (&_hs  , sizeof(int),f);

	pack_fwrite (obs , sizeof(OBS) * (_w * _h *_lay) , f);
	pack_fclose (f);
}

/************* Map:~Map ****************/
Map :: ~Map () {
	if(obs) {free(obs);obs=0;}
}

/************* Map::Map ****************/
Map :: Map () {
	_x=0;
	_y=0;
	xdd=0;
	ydd=0;
	obs = 0;
	_w = 0; _h = 0;
	_wc = 0; _hc = 0;
	_ws = SCREEN_W;
	_hs = SCREEN_H;
}
/************* Map::get ****************/
int Map :: get (int layer,int x,int y){
	if(y != -1) return obs [(x + y*_w)+(layer*_w*_h)].image;
	else return obs [x+layer*_w*_h].image;
}
/************** Map::get_mode **************/
int Map :: get_mode (int layer,int x,int y){
	if(y != -1) return obs [x + y*_w+layer*_w*_h].mode;
	else return obs [x+layer*_w*_h].mode;
}

/*************** Map::get_hbst ************/
int Map :: get_hbst (int layer,int x,int y){
	if(y != -1) return obs [x + y*_w+layer*_w*_h].hbst;
	else return obs [x+layer*_w*_h].hbst;
}

/*************** Map::resize *************/
void Map :: resize (int w,int h){
	if(w != -1 && h != -1){
		_w = w;
		_h = h;
		obs = (OBS*)realloc (obs , sizeof(OBS)*((w*h*_lay)+1));

	}
	else obs = (OBS*)realloc (obs , sizeof(OBS)*((_w*_h*_lay)+1));
}

/*************** Map::set ****************/
void Map :: set (int lay,int s,int x,int y){
	if(y != -1) obs[(x+y*_w)+lay*_w*_h].image=s;
	else obs[x+lay*_w*_h].image=s;
}
/*************** Map::set_mode *************/
void Map :: set_mode (int lay,int s,int x,int y){
	if(y != -1) obs[x+y*_w+lay*_w*_h].mode=s;
	else obs[x+lay*_w*_h].mode=s;
}
/*************** Map::set_hbst ***************/
void Map :: set_hbst (int lay,int s,int x,int y){
	if(y != -1) obs[x+y*_w+lay*_w*_h].hbst=s;
	else obs[x+lay*_w*_h].hbst=s;
}

void Map :: fill (int lay,int c){
	int i;
	for(i = _w*_h*lay ; i < (_w*_h)*(lay+1) ; i++){
		obs [i].image = c;
	}
}

void Map::myshow (BITMAP *bmp,DATAFILE *dat,int layer){
}



/* init map function */
void init_map (){
	map.layer (2);
	map.set_wc (48);
	map.set_hc (48);
	map.set_ws (624);
	map.set_hs (480);
	/* */
	map.resize (14,10);
	map.fill (0,0);
	map.fill (1,0);
	/* */
}

void save_map (){
	char file[100];
	sprintf (file,"map/level%i.map",level);
	map.save (file);
}
void load_map (){
	char file[100];
	sprintf (file , "map/level%i.map",level);
	map.load (file);
}
void load_map_file (char *s){
	char file[100];
	sprintf (file , "map/%s.map",s);
	map.load (file);

}
