/*
SpeedHack2006 Entry
by Mehdi Cherti 2006
Part of SpeedHack entry (2006) project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
*/
#include "game.h"
#include <stdio.h>

int gfx_w=640 ,                 /* resolution width   */
    gfx_h=480 ,                 /* resolution height  */
    gfx_flag=GFX_AUTODETECT,                 /* 0 for windowed, 1 for fullscreen */
    gfx_depth=16;               /* depth              */

Map map;
int max_tiles = 0;
int fullscreen = 1;
DATAFILE *perso_data = 0;
DATAFILE *tiles=0;
DATAFILE *sound_data = 0;
DATAFILE *other_data = 0;
/* BITMAPS */
BITMAP *buffer=0;
Timer mytime;
Sound snd;
Perso perso[2];
/* counters */
volatile int counter_game = 0;

int level = 1;


/* mods */
JGMOD *battle_mod=0,*menu_mod;
/********/


int set_mode (){
	int a;
	a =  (set_gfx_mode (fullscreen ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED , gfx_w , gfx_h,0,0) );
	if(a < 0){
		return set_gfx_mode (GFX_AUTODETECT ,  gfx_w , gfx_h,0,0) ;
	}
	return a;

}
void init_mods (){
	battle_mod = load_mod ("media/battle.mod");
	menu_mod = load_mod ("media/menu.mod");
}


/* handle function */
void handle () {
	mytime.inc_all ();
	counter_game ++;
}
END_OF_FUNCTION (handle);

/* get the perso */
Perso *p (int num){
	return &perso[num];
}
/* max_data */
int max_data (DATAFILE *dat){
	DATAFILE *d = dat;
	int i=0;
	while (d->type != DAT_END){
		d++;
		i++;
	}
	return i;
}


/* show allegro_error string and quit */
void err (){
	set_gfx_mode (GFX_TEXT,0,0,0,0); /* setting to text mode */
	allegro_message ("%s" , allegro_error); /* showing the message */
	printf ("%s\n",allegro_error);
	exit (0);
}



/* Initialization */
void game_init () {
	if(allegro_init () < 0) err (); /* initting allegro */
	push_config_state ();
	set_config_file ("config.cfg");

	/****/
	/****/
	if(install_keyboard () < 0) err(); /* installing keyboard */
	install_timer ();
	install_joystick (JOY_TYPE_AUTODETECT); /* it's not obligatory */
	reserve_voices (32,-1);

	install_sound (DIGI_AUTODETECT,MIDI_NONE,0);

	install_mouse ();
	set_color_depth (gfx_depth); /* gfx_depth setting*/
	if(set_mode () < 0) err ();
	atexit (bye);
	init_map ();

	perso_data = load_datafile ("media/perso.dat");
	if(!perso_data) err ();

	tiles = load_datafile ("media/tiles.dat");
	if(!tiles) err ();
	sound_data = load_datafile ("media/sound.dat");
	if(!sound_data) err ();
	other_data = load_datafile ("media/other.dat");
	if(!other_data) err ();

	buffer = create_bitmap (map.ws (), map.hs ());
	if(!buffer) err();
	LOCK_FUNCTION (handle);
	LOCK_VARIABLE (counter_game);
	install_int (handle , 1);

	/* snd */
	snd.set_datafile(sound_data);
	snd.find ();
	
	max_tiles = max_data (tiles);
	install_mod (24);


	mytime.add ("COUNTER_PERSO");
	mytime.add ("COUNTER_PERSO2");
	mytime.add ("COUNTER_TOOGLE1");
	mytime.add ("COUNTER_TOOGLE2");
	mytime.add ("COUNTER_ITEMS");
	mytime.add ("COUNTER_ITEMS2");
	mytime.add ("COUNTER_SHOOT1");
	mytime.add ("COUNTER_SHOOT2");
	mytime.add ("COUNTER_MENU");
	


	init_mods ();



}

/* exit */
void bye (){
	set_config_vars ();
	if(buffer) {destroy_bitmap(buffer);buffer=0;}
	if(perso_data) {unload_datafile(perso_data);perso_data=0;}
	if(tiles) {unload_datafile(tiles);tiles=0;}
	if(sound_data) {unload_datafile(sound_data);sound_data=0;}
	if(other_data) {unload_datafile(other_data);other_data=0;}
	if(battle_mod) {destroy_mod (battle_mod);battle_mod=0;}
	if(menu_mod) {destroy_mod(menu_mod);menu_mod=0;}
}
