/*
SpeedHack2006 Entry
by Mehdi Cherti 2006
Part of SpeedHack entry (2006) project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
*/

#include "allegro.h"
#include "timer.h"
#include <stdio.h>
#include <string.h>

Timer :: Timer () {
	t=0;
	maxt=0;
}

Timer :: ~Timer () {
	if(t){
		free (t);
		t=0;
	}
}

void Timer :: add (const char *name){
	t = (TIMER*)realloc(t,(sizeof(TIMER)) * (maxt+1));
	t [maxt].name = name;
	t [maxt].t    = 0;
	LOCK_VARIABLE (t [maxt].t);
	maxt++;		
}


volatile int Timer :: get (const char *name){
	int i;
	if(!name) return -1;
	for (i = 0 ; i < maxt ; i++){
		if(t[i].name && (strcmp(t[i].name,name)==0)) return t[i].t;
	}
	return 0;
}

volatile int* Timer :: get_ptr (const char *name){
	int i;
	if(!name) return NULL;
	for (i = 0 ; i < maxt ; i++){
		if(t[i].name && (strcmp(t[i].name,name)==0)) return &t[i].t;
	}
	return 0;
}

volatile int Timer :: get (int n){
	return t[n].t;
}

volatile int* Timer :: get_ptr (int n){
	return &t[n].t;
}

void Timer :: inc_all(int n){
	int i;
	for(i = 0 ; i < maxt ; i++){
		t [i].t+=n;
	}
}
