/*
SpeedHack2006 Entry
by Mehdi Cherti 2006
Part of SpeedHack entry (2006) project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.
*/

#include "game.h"
#include <stdio.h>
#include <string.h>

char strstrd[256];
int counter_game_max;
int perso_joy[2]={0};
int default_bananas;
int keys[2][MaxKeys]={0};
const char* joys[2][MaxKeys]={0};
int voice_jump=0;

const char *get_key_name (int key){
	if(key == RIGHT) return "right";
        if(key == LEFT ) return "left";
	if(key == JUMP) return "jump";
	if(key == SHOOT) return "shoot";
	if(key == UP) return "up";
	if(key == DOWN) return "down";
}
int
play_sfx (int n)
{
  return play_sample ((SAMPLE*)sound_data[n].dat, 255, 128, 1000, 0);
}


void set_key (int perso , int key , int num){
	keys [perso][key] = num;
}

void set_joy(int perso , int key , const char *data){
	joys[perso][key] = data;
}

int get_joy (int j ,  const char *str){
if(!str) return 0;
if(strcmp(str,"")==0) return 0;
if(j>num_joysticks-1) return 0;	
	if(strcmp(str,"RIGHT")==0) return joy[j].stick[0].axis[0].d2;
	if(strcmp(str,"LEFT")==0) return joy[j].stick[0].axis[0].d1;
	if(strcmp(str,"UP")==0) return joy[j].stick[0].axis[1].d1;
	if(strcmp(str,"DOWN")==0) return joy[j].stick[0].axis[1].d2;
	if(str[0] == 'B'){
		return joy[j].button[atoi(str+1)].b;
	}
	
}
int if_bt (int j , int bt){
	return joy[j].button[bt].b;
}
int get_num_bt (int j){
	return joy[j].num_buttons;
}
void menu_set_keys (int perso, BITMAP *save , int joyd){
	int i,keybt;
	int c_start=0;
rere:

Choix c(160,190,MaxKeys+1+((joyd)?1:0),25,c_start, (BITMAP*)other_data[CHOIX].dat);
c.y = 190;

	if(perso_joy[perso] >= num_joysticks) perso_joy[perso] = num_joysticks-1;
	while(c.active){
		int d,d2;
		poll_keyboard ();
		poll_joystick ();	
		blit (save , buffer , 0,0,0,0,SCREEN_W,SCREEN_H);


		d = is_key (0,RIGHT)||is_key(1,RIGHT);
		d2 = is_key (0,LEFT)||is_key(1,LEFT);

		if(d||d2){
			if(c.cxx == 0){
				if(d) 	perso_joy[perso] ++;
				if(d2) perso_joy[perso]--;
				if(perso_joy[perso] >= num_joysticks) perso_joy[perso] = num_joysticks-1;
				if(perso_joy[perso] < 0) perso_joy[perso]=0;
			}
			while (is_key(0,RIGHT)||is_key(1,RIGHT)||is_key(0,LEFT)||is_key(1,LEFT)) {poll_keyboard();poll_joystick();}
			
			
		}


	if(joyd)	textprintf_ex (buffer , (FONT*)font ,  185 ,200 , makecol(0,0,0),-1 , "Joystick number : %i",perso_joy[perso]);


		for(i = 0 ; i < MaxKeys ; i ++){
		const char *s;
		if(joyd == 0) s = scancode_to_name (keys[perso][i]);
		else s =  joys[perso][i]?joys[perso][i]:"None";
		textprintf_ex (buffer , (FONT*)font ,  185 ,200+(i+(joyd?1:0))*25 , makecol(0,0,0),-1 , "%s : %s", get_key_name (i), s);
		}
		textprintf_ex (buffer , (FONT*)font ,  185 ,200+(MaxKeys+(joyd?1:0))*25 , makecol(255,0,0),-1 , "Back");
	
		c.update ();
		c.show (buffer);
		blit (buffer , screen ,0,0,0,0,SCREEN_W,SCREEN_H);

	}
	c_start = c.cxx;
	while (is_key (0  , SHOOT) || is_key (1,SHOOT)) {poll_keyboard();poll_joystick();}
	
	if(c.cxx == MaxKeys+(joyd?1:0)) return;
	blit (save , buffer , 0,0,0,0,SCREEN_W,SCREEN_H);
	if(c.cxx==0 && joyd) goto rere;
	textprintf_ex (buffer ,(FONT*)font,  185 ,200  , makecol(0,0,0) , -1 , "Press any key");
	blit (buffer , screen ,0,0,0,0,SCREEN_W,SCREEN_H);

	


	if(!joyd){
	clear_keybuf ();
       	keybt = keys[perso][c.cxx];
	while (1){
		poll_keyboard ();
		if(keypressed ()){
			keybt = readkey () >> 8;
			break;
		}
		
	}
	while(key[keybt]) poll_keyboard ();	
	keys[perso][c.cxx] = keybt;
	}
	if(joyd){
		const char *joyb = NULL;
		int bt=-1;
		int i;
		while (1){
			poll_keyboard ();
			poll_joystick ();

			if(get_joy (perso_joy[perso] , "RIGHT")) {joyb = "RIGHT";break;}
			if(get_joy (perso_joy[perso] , "LEFT")) {joyb = "LEFT";break;}
			if(get_joy (perso_joy[perso] , "UP")) {joyb = "UP";break;}
			if(get_joy (perso_joy[perso] , "DOWN")) {joyb = "DOWN";break;}
			for(i = 0 ; i < get_num_bt(perso_joy[perso]); i++){
				if(if_bt (perso_joy[perso] ,i)){
					bt = i;
					goto next;
				}
			}

			if(key[KEY_ESC]) break;
		}
next:
		if(joyb) {
			set_joy ( perso , c.cxx-1 , joyb);
			while(get_joy (perso_joy[perso] , joyb)) poll_joystick ();

		}
		else if (bt != -1){
			sprintf (strstrd , "B%i",bt);
			set_joy (perso , c.cxx-1 , strstrd);
			while(get_joy (perso_joy[perso] , strstrd)) poll_joystick ();
		}
	}
	goto rere;


	

}
void set_keys (){
	perso_joy[0] = 0;
	perso_joy [1] = 1;
	set_key (0 , RIGHT , KEY_RIGHT);
	set_key (0 , LEFT , KEY_LEFT);
	set_key (0 , JUMP , KEY_UP);
	set_key (0 , SHOOT , KEY_SPACE);
	set_key (0 , UP , KEY_UP);
	set_key (0 , DOWN , KEY_DOWN);



	set_joy (0 , RIGHT , "RIGHT");
	set_joy (0 , LEFT , "LEFT");
	set_joy (0 , JUMP , "UP");
	set_joy (0 , SHOOT , "B0");
	set_joy (0 , UP , "UP");
	set_joy (0 , DOWN , "DOWN");



	set_key (1 , RIGHT , KEY_6_PAD);
	set_key (1 , LEFT , KEY_4_PAD);
	set_key (1 , JUMP , KEY_0_PAD);
	set_key (1 , SHOOT , KEY_ENTER_PAD);
	set_key (1 , UP , KEY_8_PAD);
	set_key (1 , DOWN , KEY_2_PAD);
	
	set_joy (1 , RIGHT , NULL);
	set_joy (1 , LEFT , NULL);
	set_joy (1 , JUMP, NULL);
	set_joy (1 , SHOOT ,  NULL);




}


#define ITEM_JUMP 4
#define ITEM_BANANA 6
#define ITEM_SPEED 5
#define ITEM_MONSTER 8
#define ITEM_HP 7
TOOGLE items[100]={0};
int max_items=0;
void draw_box(BITMAP *bmp,int x,int y,int w,int h , int col){
	BITMAP *bit = create_bitmap(w,h);
	set_trans_blender(0,0,0,128);

	clear_to_color (bit,col);
	draw_trans_sprite(bmp,bit,x,y);
	if(bit) {destroy_bitmap(bit);bit=NULL;}
}

/* Show all */
void show_all (BITMAP *buffer){
int i;
	map.show (buffer,  tiles , 1);
	map.show (buffer,  tiles , 0);
	p(0)->show (buffer , perso_data);
	p(1)->show (buffer , perso_data);
	for(i = 0 ; i < max_items ; i++){
		if(items[i].en){
			draw_sprite (buffer , (BITMAP*)tiles[items[i].img].dat , items[i].xshow , items[i].yshow);
		}
	}
	for(i = 0 ; i < 2 ; i++){
		if(p(i)->shoot.en){
			
			rotate_sprite (buffer , (BITMAP*)other_data[p(i)->shoot.img].dat , p(i)->shoot.xshow , p(i)->shoot.yshow , itofix (p(i)->shoot.x));
		}
	}
	for(i= 0 ; i < 2 ; i++){
		int PERCENT = (p(i)->HP*100)/p(i)->HPMAX;
		int d = (i==0)?10:(map.ws()-110);
		draw_box (buffer , d,0,100,30,makecol(255,255,255));	
		stretch_sprite (buffer , (BITMAP*)other_data [BANANA].dat , d , 0 ,24,24);
		textprintf_ex (buffer , font , d+20 , 15 , makecol(0,0,0), -1,"x%i",p(i)->BANANAS);
		textprintf_ex (buffer , font , d+50 , 15 , PERCENT>20?makecol(0,0,0):makecol(255,0,0), -1,"%2i%%",PERCENT);

	}
	{
		
		int min , sec , d = (counter_game_max - counter_game)/1000;
		int col=makecol(0,0,0);
		
		if(d <= 20) {col = makecol(255,0,0);set_mod_speed(150);}
		if(d < 0 ) d=0;
		min = d /60;
		sec =  d % 60;
		draw_box (buffer , 250 ,0 , 120,20 , makecol(255,255,255));
		textprintf_ex (buffer , font , 270 , 5 ,col, -1,"Time %i:%i",min,sec);
	}



}

int is_key (int perso , int keyy){
	return (key[keys[perso][keyy]]) ||(get_joy (perso_joy[perso],(const char*)joys[perso][keyy]));
}

int item_rand_max = 100;
int items_img[]= {
	ITEM_JUMP,12,
	ITEM_BANANA,12,
	ITEM_SPEED,11,
	ITEM_HP , 5 ,
	ITEM_MONSTER,60,
	-1,-1
};
int rand_tgl_img (){
	int max,i=0,d;
	int ind = 0;
	d = rand() % item_rand_max;
	
	while (items_img[i] != -1){
		if(d >= ind && d <= items_img[i+1]+ind-1){
			return items_img[i];
		}
		ind += items_img[i+1];
		i+=2;
	}
}

void HBS (int dir , int x , int y , int *p1xx , int *p1yy , int *p2xx , int *p2yy){
	int p1x , p1y , p2x , p2y;
	if(dir == 0){
		p1x = (x + map.wc ()) / map.wc ();
		p1y = (y / map.hc ());
	//	p2x = (scx () + M->wc()) / M->hc ();
	//	p2y = (scy() + M->hc ()) /M->hc ();
		
		p2x = p1x;
		p2y = p1y;
	}
	if(dir  == 1){
		p1x = x / map.wc ();
		p1y = y / map.hc ();
		/*
		p2x = (scx ()) / M->wc ();
		p2y =  (scy()+M->hc())/M->hc ();
		*/
		p2x = p1x;
		p2y = p1y;
	}
	if(dir == 2){
		p1x = x / map.wc ();
		p1y = y / map.hc ();
		p2x = (x+map.wc()) / map.wc();
		p2y  = y / map.hc();
		
	}
	if(dir == 3){
		p1x = x / map.wc ();
		p1y = (y+map.hc()) / map.hc ();
		p2x = (x + map.wc ()) / map.wc ();
		p2y = (y + map.hc ()) / map.hc ();
	}	
	*p1xx = p1x ; *p2xx = p2x;
	*p1yy  = p1y; *p2yy = p2y;
}
TOOGLE* get_item (int num){
	return &items[num];
}

void take_item (int perso , int i){
	if(items[i].en){
	if(items[i].img == ITEM_JUMP){
		p(perso)->max_jump++;
		if(p(perso)->max_jump > 8) {
			p(perso)->max_jump = 8;

		}
		show_all (buffer);
		textout_ex (buffer , font , "JUMP+1 !!!" ,p(perso)->scx () , p(perso)->scy ()+map.hc() , makecol(255,255,255),-1);
		blit (buffer , screen ,  0,0,0,0,SCREEN_W,SCREEN_H);
		play_sfx (SFX01);
		rest (300);

	}
	if(items[i].img == ITEM_BANANA){
		p(perso)->BANANAS++;
		show_all (buffer);
		textout_ex (buffer , font , "BANANA+1 !!!" ,p(perso)->scx () , p(perso)->scy ()+map.hc() , makecol(255,255,255),-1);
		blit (buffer , screen ,  0,0,0,0,SCREEN_W,SCREEN_H);
		play_sfx (SFX01);
		rest (300);

	}
	if(items[i].img == ITEM_SPEED){
		p(perso)->zid_time -= 4;
		if(p(perso)->zid_time < 10) p(perso)->zid_time = 10;
		show_all (buffer);
		textout_ex (buffer , font , "SPEED+1 !!!" ,p(perso)->scx () , p(perso)->scy ()+map.hc() , makecol(255,255,255),-1);
		blit (buffer , screen ,  0,0,0,0,SCREEN_W,SCREEN_H);
		play_sfx (SFX01);
		rest (300);

	}
	if(items[i].img == ITEM_HP){
		p(perso)->HP ++;
		if(p(perso)->HP > p(perso)->HPMAX){
			p(perso)->HP = p(perso)->HPMAX;
		}
		show_all (buffer);
		textout_ex (buffer , font , "HP+1 !!!" ,p(perso)->scx () , p(perso)->scy ()+map.hc() , makecol(255,255,255),-1);
		blit (buffer , screen ,  0,0,0,0,SCREEN_W,SCREEN_H);
		play_sfx (SFX01);
		rest (300);

	}






	}
}


void move_items (){
	int i;
	for(i = 0 ; i < max_items ; i++){
		int p1x , p1y , p2x , p2y;
		int vit = 8;
		int e;
		if(items[i].img == ITEM_MONSTER) vit = 4;
		PMASK *p1 = create_allegro_pmask ((BITMAP*)tiles[items[i].img].dat);
		if(p1 && items[i].en){
		for(e = 0 ; e < 2 ; e++){
			int I=p(e)->i.im [0];
			PMASK *p2 = create_allegro_pmask ( (BITMAP*)perso_data[I].dat);
			if(p2){
				if(check_pmask_collision (p1,p2 , items[i].xshow , items[i].yshow , p(e)->scx() , p(e)->scy())){
					
					if(items[i].img == ITEM_MONSTER){
						p(e)->HP -= 1;
						p(e)->start_jump (1);
						play_sfx (SFX06);
						items[i].dir = p(e)->sens;
					}
					else{ 
					       	take_item (e , i);
						items[i].en = 0;
					}
					

					 

				}
			}
			destroy_pmask (p2);
	
		}
		destroy_pmask (p1);
		}
		
		if(items[i].dir == 0){
			items[i].xshow += vit;
			if(items[i].xshow >= map.ws ()-map.hc()){
				items[i].xshow = 0;
				if(items[i].yshow >= map.hs() - map.hc()*2) items[i].en = 0;
			}
		}	

		if(items[i].dir == 1){
			items[i].xshow -= vit;
			if(items[i].xshow <= 0 ){
				items[i].xshow = map.ws () - map.wc ();
				if(items[i].yshow >= map.hs() - map.hc()*2) items[i].en = 0;
			}
		}
		if(items[i].dir == 3){
			items[i].yshow += vit;
		}


		HBS (items[i].dir , items[i].xshow , items[i].yshow , &p1x ,  &p1y , &p2x , &p2y);
	       if(hbs_object (0 , p1x , p1y) || hbs_object (0 ,p2x,p2y) || hbs_object (0 , items[i].xshow/map.wc() , items[i].yshow/map.hc ())){	

		       if(items[i].dir == 0) items[i].xshow -= vit;
		       else if (items[i].dir == 1) items[i].xshow += vit;
			else if (items[i].dir == 2) items[i].yshow += vit;
			else if (items[i].dir == 3){
			       	items[i].yshow -= vit;
				items[i].yshow = ((items[i].yshow+vit)/map.hc())*map.hc();
				items[i].dir = 0;
			}

			
	       }
	       
if(items[i].dir != 3){       
        	HBS (3 , items[i].xshow , items[i].yshow , &p1x ,  &p1y , &p2x , &p2y);
	       if(!hbs_object (0 , p1x , p1y) && !hbs_object (0 ,p2x,p2y)&& ! hbs_object (0 , items[i].xshow/map.wc() , items[i].yshow/map.hc ())){	
		items[i].precdir = items[i].dir;

			items[i].dir = 3;
	       }
}

	}
}


int
explosion (BITMAP *sprite,int x, int y, int max)
{
  int e,i;
  EXPLOSION *ex = 0;
  BITMAP *save;
  save = create_bitmap(map.ws () , map.hs ());
  if(!save) return -1;
  blit(buffer , save,0,0,0,0,map.ws () , map.hs ());

  
  ex = create_explosion (sprite);
  ex->mask = makecol(255,0,255);
  init_explosion (ex,  max);
  ex->enable = 1;
  for(i= 0; i < max ; i++){
	  do_explosion (ex);
	  blit(save , buffer , 0,0,0,0,map.ws (),map.hs ());
	  draw_explosion (buffer , ex , x , y);
	  blit (buffer , screen , 0,0,0,0,SCREEN_W,SCREEN_H);
	  rest (100);
  }
  destroy_explosion (ex);
  destroy_bitmap (save);save=0;
  return 0;
}
int reload_game = 0;
void end_game (int persod){
	int i;
	int perso = persod;
	if(perso != -1) p(!perso)->score++;
	for(i = 0 ; i < max_items ; i++){
		items[i].en = 0;
	}
	max_items = 0;

	map.show (buffer,  tiles , 1);
	map.show (buffer,  tiles , 0);
	play_sfx (SFX04);
	draw_box (buffer , 200 ,200 , 300 , 200 , makecol (255,255,255)); 
	if(perso != -1){
	textprintf_ex (buffer , font , 210 , 210 , makecol(0,0,0), -1,"WINNER : %s",perso == 0 ? "Player 2" : "Player 1");
	textprintf_ex (buffer , font , 210 , 300 , makecol(0,0,0), -1,"LOSER  : %s",perso == 1 ? "Player 2" : "Player 1");
	}
	else {
	textprintf_ex (buffer , font , 210 , 210 , makecol(0,0,0), -1,"Draw GAME!");
	}
	if(perso != -1){
		draw_sprite (buffer , (BITMAP*)perso_data[p(!perso)->i.im[0]].dat ,  370 ,210);
		draw_sprite (buffer , (BITMAP*)perso_data[p(perso)->i.im[0]].dat ,  370 ,300);
	}
	textprintf_ex (buffer , font , 210 , 370 , makecol(0,0,100), -1,"Score : Player one %i : %i Player two",p(0)->score,p(1)->score);

	blit (buffer , screen , 0,0,0,0,SCREEN_W,SCREEN_H);
	stop_mod ();
	clear_keybuf ();
	while (1){
		poll_keyboard ();
		if(key[KEY_ENTER]) break;
	}
	reload_game = 1;
	
}
int get_counter_items_max (){
	return rand() % 7000;
}



//*** levels ****/
LEVEL levels []= {
	{0 , 0 , "Forest"},
	{0 , 1 , "The Red room"},
	{0 , 2 , "Forest 2"},
	{0 , 3 , "Street"},
	{0 , 4 , "The red room 2"},
	{0 , 5 , "Forest 3"},
	{-1,-1}
};

/* MENU */
void menu (){

int angle=0;
int dir_a = 0;
volatile int *counter_menu = mytime.get_ptr ("COUNTER_MENU");
BITMAP *save = create_bitmap(SCREEN_W,SCREEN_H);
if(!save) return;
//map.fill (0,0);
load_map_file ("title");
re:
Choix c (160 , 200 , 3  , 45 ,  0 ,  (BITMAP*)other_data[CHOIX].dat);
map.show (buffer , tiles,1);
map.show (buffer , tiles,0);

draw_box (buffer , 150 , 190 , 300 , 200,makecol(255,255,255));

blit (buffer , save ,0,0,0,0,SCREEN_W,SCREEN_H);
while (c.active){
	poll_keyboard ();
	poll_joystick ();
	if(key[KEY_F11]) {fullscreen = !fullscreen  ; set_mode ();}

	blit (save , buffer ,0,0,0,0,SCREEN_W,SCREEN_H);


	if(angle >= 10 && dir_a==0) dir_a = !dir_a;
	if(angle <= -10 && dir_a==1) dir_a = !dir_a;

	if(*counter_menu >= 40){
		if(dir_a == 0) 	angle = (angle+1);
		else angle = (angle-1);
		*counter_menu = 0;
	}

	
	rotate_sprite (buffer , (BITMAP*)other_data[TITLE].dat ,  0 ,30,itofix(angle));

	draw_box (buffer , 150 , 190 , 300 , 200,makecol(255,255,255));
	textout_ex (buffer , (FONT*)other_data[BIGFONT].dat , "Play" , 185,200 ,  makecol(0,0,100),-1);
	textout_ex (buffer , (FONT*)other_data[BIGFONT].dat , "Options" , 185,200+40 ,  makecol(0,0,100),-1);
	textout_ex (buffer , (FONT*)other_data[BIGFONT].dat , "Quit" , 185,200+40*2 ,  makecol(0,0,100),-1);
	c.update ();
	c.show (buffer);
	blit (buffer , screen , 0,0,0,0,SCREEN_W,SCREEN_H);

}
while (is_key (0  , SHOOT) || is_key (1,SHOOT)) {poll_keyboard();poll_joystick();}
if(c.cxx == 2) {destroy_bitmap(save);exit(0);}

/* PLAY */
if (c.cxx == 0){
	int o=0,e;
	
	while (levels[o].mod != -1){
		o++;
	}

	Choix c2 (160,190,o+1,20,0, (BITMAP*)other_data[CHOIX].dat);
	while (c2.active){
		poll_keyboard ();
		poll_joystick ();
		c2.update ();
		blit (save,buffer,0,0,0,0,SCREEN_W,SCREEN_H);
	textout_ex (buffer , (FONT*)font , "Select the stage" , 200 ,170 , makecol(0,0,100),-1);

		for(e = 0 ; e < o ;e++){
			textout_ex (buffer , (FONT*)font , levels[e].name , 185 ,200+e*20 , makecol(0,0,0),-1);
		}
		textout_ex (buffer , (FONT*)font , "Back" , 185 ,200+o*20 , makecol(255,0,0),-1);
		c2.show (buffer);
		blit (buffer , screen ,0,0,0,0,SCREEN_W,SCREEN_H);
	}
	while (is_key (0  , SHOOT) || is_key (1,SHOOT)) {poll_keyboard();poll_joystick();}
	if(c2.cxx == o) goto re;
	else {
		level = c2.cxx+1;
		highcolor_fade_out (40);
		return;
	}

}
/*********************** Options *******************/
if(c.cxx = 1){
int d,d2;
re_options:
	Choix c3 (160,190,7,25,0, (BITMAP*)other_data[CHOIX].dat);
	while (c3.active){
		poll_keyboard ();
		poll_joystick ();
		d = is_key (0,RIGHT)||is_key(1,RIGHT);
		d2 = is_key (0,LEFT)||is_key(1,LEFT);
		if(d||d2){
			if(c3.cxx == 0) {
				if(d) 	counter_game_max = counter_game_max + 1000*60;
				if(d2) counter_game_max = counter_game_max - 1000*60;
				if(counter_game_max < 1000*60*2) counter_game_max= 1000*60*2;

			}
			if(c3.cxx == 1){
				if(d) 	default_bananas ++;
				if(d2) default_bananas--;
				if(default_bananas < 0) default_bananas=0;

			}
			while (is_key(0,RIGHT)||is_key(1,RIGHT)||is_key(0,LEFT)||is_key(1,LEFT)) {poll_keyboard();poll_joystick();}
			
		}
		blit (save,buffer,0,0,0,0,SCREEN_W,SCREEN_H);
		textout_ex (buffer , (FONT*)font , "Options , press Left and right to increase or decrease time game or bananas" , 0 ,180 , makecol(255,255,255),-1);

		textout_ex (buffer , (FONT*)font , "Game time" , 185 ,200 , makecol(0,0,0),-1);
		textout_ex (buffer , (FONT*)font , "number of Bananas" , 185 ,200+25 , makecol(0,0,0),-1);
		textout_ex (buffer , (FONT*)font , "Player one keys" , 185 ,200+25*2 , makecol(0,0,0),-1);
		textout_ex (buffer , (FONT*)font , "Player two keys" , 185 ,200+25*3 , makecol(0,0,0),-1);
		textout_ex (buffer , (FONT*)font , "Player one Joystick" , 185 ,200+25*4 , makecol(0,0,0),-1);
		textout_ex (buffer , (FONT*)font , "Player two Joystick" , 185 ,200+25*5 , makecol(0,0,0),-1);

		textout_ex (buffer , (FONT*)font , "Back" , 185 ,200+25*6 , makecol(255,0,0),-1);
		
		textprintf_ex (buffer , (FONT*)font ,  280 ,200 , makecol(255,0,0),-1 , "%i minutes",counter_game_max/(1000*60));
		textprintf_ex (buffer , (FONT*)font ,  340 ,200+25 , makecol(255,0,0),-1 , "%i",default_bananas);




		c3.update ();
		c3.show (buffer);
		blit (buffer , screen ,0,0,0,0,SCREEN_W,SCREEN_H);
		

	}
	
	while (is_key (0  , SHOOT) || is_key (1,SHOOT)) {poll_keyboard();poll_joystick();}
	if(c3.cxx == 2 || c3.cxx == 3){
		menu_set_keys (c3.cxx - 2 , save , 0);
		while (is_key (0  , SHOOT) || is_key (1,SHOOT)) {poll_keyboard();poll_joystick();}

	}	
	if(c3.cxx == 4 || c3.cxx == 5){
		menu_set_keys (c3.cxx - 4 , save , 1);
		while (is_key (0  , SHOOT) || is_key (1,SHOOT)) {poll_keyboard();poll_joystick();}

	}	

	if(c3.cxx == 6) goto re;
	goto re_options;

}

destroy_bitmap (save);

/* QUIT */
}

/* game_start */
void game_start () {
	volatile int *a[2];
	volatile int *time_toogle[2] ;
	volatile int *counter_items;
	volatile int *counter_items2;
	volatile int *counter_shoot[2];

	int i;
	int counter_items_max = 10000;
	int dd[2] = {0};
	int clayer=0;
	int editor=0;
	int edX=0 , edY=0,edC=0;
	char s[256];

	set_keys ();
	default_bananas = 10;
	a[0] = mytime.get_ptr ("COUNTER_PERSO");
	a[1] = mytime.get_ptr ("COUNTER_PERSO2");
	time_toogle[0] = mytime.get_ptr ("COUNTER_TOOGLE1");
	time_toogle[1] = mytime.get_ptr ("COUNTER_TOOGLE2");
	counter_items = mytime.get_ptr ("COUNTER_ITEMS");
	counter_items2 = mytime.get_ptr ("COUNTER_ITEMS2");
	counter_shoot[0] = mytime.get_ptr ("COUNTER_SHOOT1");
	counter_shoot[1] = mytime.get_ptr ("COUNTER_SHOOT2");
	counter_game_max = 2*1000*60; /* 2minutes;*/
	read_config_vars ();
remenu:
	stop_mod ();
	set_mod_speed (100);
	if(menu_mod) play_mod (menu_mod , TRUE);
	menu ();
	

re:
	set_mod_speed (100);
	counter_game  = 0;
	init_perso ();

	load_map ();
	max_items = 0;
//	p(1)->HP  = 1;	
stop_mod ();
show_all (buffer);
textout_ex (buffer , (FONT*)other_data[FONT1].dat , "R E A D Y!" , 250 ,300,makecol(0,0,0),-1);
blit (buffer , screen,0,0,0,0,SCREEN_W,SCREEN_H);
rest (1000);
show_all (buffer);
textout_ex (buffer , (FONT*)other_data[FONT1].dat , "G O !!!!" , 250 ,300,makecol(255,0,0),-1);
blit (buffer , screen,0,0,0,0,SCREEN_W,SCREEN_H);
rest (300);


	
if(battle_mod) play_mod (battle_mod , TRUE);
	while (1){
		if(key[KEY_ESC]){ 
			highcolor_fade_out (50);
			goto remenu;
		}
		if(key[KEY_F11]) {fullscreen = !fullscreen  ; set_mode ();}


		clear_bitmap (buffer);
		poll_keyboard ();
		poll_joystick ();

		
		if(counter_game >= counter_game_max && !reload_game){
			int loser =-1;
		        if(p(0)->HP > p(1)->HP) loser = 1;
			if(p(1)->HP > p(0)->HP) loser = 0;
			show_all (buffer);
			stop_mod ();
			draw_box (buffer , 250 ,210 , 150 , 30 , makecol(255,255,255));
			textout_ex (buffer , font , "Time is Over !" , 260 , 220 , makecol(0,0,0),-1);
			blit (buffer , screen , 0,0,0,0,SCREEN_W,SCREEN_H);
			rest (2000);
			end_game (loser);
		}

		
		if(reload_game){
			reload_game = 0;
			goto re;
		}	
		if(*counter_items >= counter_items_max  ){
			if(max_items >= 20) max_items = 0;
			*counter_items = 0;

			counter_items_max = get_counter_items_max ();
			if( (rand() % 2) == 0){
				items[max_items].x = 0;
				items[max_items].y = 0;
				items[max_items].dir = 0;
			}
			else {
				items[max_items].x = 12;
				items[max_items].y = 0;
				items[max_items].dir = 1;
			}
			items [max_items].en = 1;
			items [max_items].xshow = items[max_items].x * map.wc ();
			items [max_items].yshow = items[max_items].y * map.hc ();
			items [max_items].img = rand_tgl_img ();
			max_items ++;
		}
		if(*counter_items2 >= 40){
			*counter_items2 = 0;
			move_items ();
		}
		
		for(i = 0 ; i < 2 ; i++){
			if(p(i)->HP <= 0){
				p(i)->HP = 0;
				show_all (buffer);
				map.show (buffer,  tiles , 1);
				map.show (buffer,  tiles , 0);
				p(!i)->show (buffer , perso_data);
				play_sfx (SFX05);
				explosion ((BITMAP*)perso_data[p(i)->i.im[0]].dat , p(i)->scx(), p(i)->scy(),10);
				
				end_game (i);
			}
			if(p(i)->shoot.en && *counter_shoot[i] >= 20){
				int vit = 12;
				*counter_shoot[i] = 0;
				p(i)->shoot.x = (p(i)->shoot.x + 10) % 360;
				if(p(i)->shoot.dir == 0){
					p(i)->shoot.xshow += vit;
				}
				if(p(i)->shoot.dir == 1){
					p(i)->shoot.xshow -= vit;
				}
				{
					PMASK *p1 = create_allegro_pmask ((BITMAP*)other_data[p(i)->shoot.img].dat);
					PMASK *p2 = create_allegro_pmask ((BITMAP*)perso_data[p(!i)->i.im[0]].dat);
					if(p1 && p2){
					if(check_pmask_collision (p1 , p2 , p(i)->shoot.xshow , p(i)->shoot.yshow , p(!i)->scx() , p(!i)->scy ())){
						play_sfx (SFX06);
						p(!i)->HP -= 1;
						p(i)->shoot.en = 0;
					}
					}
					if(p1) destroy_pmask (p1);
					if(p2) destroy_pmask (p2);

				}


				if((p(i)->shoot.xshow >= map.ws () && p(i)->shoot.dir==0) ||( p(i)->shoot.xshow <= 0 && p(i)->shoot.dir==1)){

					p(i)->shoot.en = 0;
					

				}

			}
			if(p(i)->toogle.en){
				if(*time_toogle[i] >= 40){
					p(i)->toogle_update ();
					*time_toogle[i] = 0;
				}
			}
			if(*a[i] >= p(i)->zid_time){
				if (is_key (i , RIGHT)){
					p(i)->move2 (Droite , 8);
					dd[i] = 1;
					p(i)->i.anim = !p(i)->i.anim;
				}
				 if (is_key (i , LEFT)){
					p(i)->move2 (Gauche , 8);
					p(i)->i.anim = !p(i)->i.anim;
					dd[i] = 1;
				}
				 if (is_key (i , JUMP)){
					if(!p(i)->jump){
						p(i)->start_jump (p(i)->max_jump);
						if((voice_jump != 0 && voice_get_position(voice_jump) == -1) || voice_jump==0){
							voice_jump = play_sfx (SFX02);
						}
					}
					
				}

				if(is_key (i , SHOOT)){
					dd[i] = 1;
					if(!p(i)->shoot.en && p(i)->BANANAS>0){
						p(i)->shoot.en = 1;
						p(i)->shoot.xshow = p(i)->scx () + (p(i)->sens==0?map.wc():(0));
						p(i)->shoot.yshow = p(i)->scy ();
						p(i)->shoot.dir = p(i)->sens;
						p(i)->shoot.img  = BANANA;
						p(i)->shoot.x = 0;
						{
							int dir = p(i)->dir();
							int im = p(i)->i.im[0];
							int st = (i==0)?PSHOOT:P2SHOOT;
							p(i)->BANANAS -= 1;
							if(p(i)->BANANAS <= 0) p(i)->BANANAS=0;

							p(i)->dir (0);
							p(i)->i.anim = 0;
							p(i)->i.im[0] = (p(i)->sens==0)?st:-st;
							show_all (buffer);
							blit (buffer , screen , 0,0,0,0,SCREEN_W,SCREEN_H);
					//		rest (200);
							p(i)->dir (dir);
							p(i)->i.im[0] = im;
						}
						play_sfx (SFX03);
					}
				}
				 p(i)->update ();
				 if(p(i)->jump){
					 dd[i]=1;
				 }

				
			}
		}

		for(i = 0 ; i <2 ; i++){
			if(dd[i] == 1){
				dd[i] = 0;
				*a[i] = 0;
			}

		}
		
		show_all (buffer);
		blit (buffer , screen , 0 ,0 ,0 ,0 ,SCREEN_W,SCREEN_H);

	}
}
void read_config_vars () {
	int e,i;
	char s[256];

	default_bananas = get_config_int ("system","bananas",10);
	counter_game_max = get_config_int ("system","time",-1 );
	if(counter_game_max == -1) counter_game_max = 2*1000*60;
	else counter_game_max *= 1000*60;

	for(e = 0 ; e < 2 ; e++){
	for(i = 0 ; i < MaxKeys ; i++){
		sprintf (s , "player%i_key_%s",e+1,get_key_name(i));
		keys[e][i] = get_config_int ("system" , s , keys[e][i] );
	}
	}
for(e = 0 ; e < 2 ; e++){
	sprintf (s , "player%i_joy_device" , e+1);
	perso_joy[e] = get_config_int ("system" , s , perso_joy[e]);
	for(i = 0 ; i < MaxKeys ; i++){
		sprintf (s , "player%i_joy_%s",e+1,get_key_name(i));
		joys[e][i] = get_config_string ("system" , s , joys[e][i]);
	}

	}

//	printf("%s\n",joys[0][0]);
//exit (0);

	
	
}

void set_config_vars (){
	int i,e;
	char s[256],ss[256];
	set_config_int ("system" , "bananas",default_bananas);
        set_config_int ("system" , "time" , counter_game_max / (1000*60));
	for(e = 0 ; e < 2 ; e++){
	for(i = 0 ; i < MaxKeys ; i++){
		sprintf (s , "player%i_key_%s",e+1,get_key_name(i));
		set_config_int("system" , s , keys[e][i]);
	}
	}
	for(e = 0 ; e < 2 ; e++){
	sprintf (s , "player%i_joy_device" , e+1);
	set_config_int ("system" , s , perso_joy[e]);
	for(i = 0 ; i < MaxKeys ; i++){
		char *string=0;
		sprintf (s , "player%i_joy_%s",e+1,get_key_name(i));
		set_config_string ("system" , s , string=strdup(joys[e][i]?joys[e][i]:""));
		if(string) free (string);
	}
	}

}
