#include "allegro.h"
#include "carreau.h"
/* carreau_init */
void carreau_init (CARR *c){
	if(c->bmp){
		c->w = (int)(c->bmp->w / c->wc);
		c->h = (int)(c->bmp->h / c->hc);
		c->maxim = c->w * c->h;
		c->destroy_bmp = 0;
	}
}
/* create_carreau */
CARR *create_carreau(BITMAP *bmp,int wc,int hc){
	CARR *c=0;
	c  = (CARR*)malloc(sizeof(CARR));
	c->wc = wc;
	c->hc = hc;
	c->bmp = bmp;
	carreau_init (c);
	return c;
}
/* carreau_set_destroy_bmp */
void carreau_set_destroy_bmp (CARR *c,char b){
	c->destroy_bmp = b;
}
/* carreau_set_bmp */
void carreau_set_bmp (CARR *c,BITMAP *bmp){
	if(!c) return;
	c->bmp = bmp;
	carreau_init (c);
}

/* destroy_carreau */
void destroy_carreau (CARR *c){
	if(c){
		if(c->destroy_bmp) destroy_bitmap(c->bmp);
		c->bmp=0;
		free (c);
	}
}
/* carreau_select */
void carreau_select (CARR *c , int im_index){
	int xp,yp,i=0;
	if(!c) return;
	c->selX  = -1;
	c->selY = -1;
	for(yp = 0 ; yp < c->h ; yp++){
		for(xp = 0 ; xp  < c->w ; xp ++){
			if(i == im_index){
				c->selX = xp;
				c->selY = yp;
				return;
			}
			i++;	
		}
	}
}

/* carreau_get */
void carreau_get (CARR *c , int im_index ,  int *x,int *y){
	if(!c) return;
	carreau_select (c , im_index);
	if(x) *x = c->selX;
	if(y) *y = c->selY;


}


/* carreau_get_image */
BITMAP *carreau_get_image (CARR *c,int x,int y){
	BITMAP *new=0;
	if(!c) return NULL;
	new=create_bitmap(c->wc,c->hc);
	if(!new ) return NULL;
	blit (c->bmp , new , x*c->wc , y*c->hc, 0, 0,c->wc , c->hc);
	return new;
}

/* carreau_get_image_index */
BITMAP *carreau_get_image_index (CARR *c , int im_index){
	if(!c) return;
	carreau_select (c,im_index);
	if(c->selX != -1){
		return carreau_get_image (c,c->selX,c->selY);
		
	}
	return NULL;
}
/* carreau_blit */
void carreau_blit (CARR *c , BITMAP *b , int x,int y,int dx,int dy){
	blit (c->bmp , b , x*c->wc,y*c->hc,dx,dy,c->wc,c->hc);
}
/* carreau_draw_sprite */
void carreau_draw_sprite (CARR *c , BITMAP *b , int x,int y,int dx,int dy){
	BITMAP *sprite;
	sprite = carreau_get_image(c,x,y);
	if(!sprite) return;
	draw_sprite(b,sprite,dx,dy);
	destroy_bitmap(sprite);
}
/* carreau_index_blit */
void carreau_index_blit (CARR *c , BITMAP *b,int index,int dx,int dy){
	int x,y;
	carreau_get(c,index,&x,&y);
	if(x==-1) return;
	blit (c->bmp , b , x*c->wc,y*c->hc,dx,dy,c->wc,c->hc);
}
/* carreau_index_draw_sprite ----*/
void carreau_index_draw_sprite (CARR *c , BITMAP *b,int index,int dx,int dy){
	BITMAP *sprite;
	sprite = carreau_get_image_index(c,index);
	if(!sprite) return;
	draw_sprite(b,sprite,dx,dy);
	destroy_bitmap(sprite);
}
