#ifndef GAME_H
#define GAME_H
#include "allegro.h" /* Allegro Game Programming Library */
extern "C"{
#include "ex.h"
}
typedef struct TOOGLE{
	int en;
	int x , y;
	int img;
	int xshow , yshow;
	int dir;
	int precdir;
}TOOGLE;

#include "ga.h"
#include "perso_data.h"
#include "sound_data.h"
#include "pmask.h"
#include "other.h"
#include "jgmod.h"
/* Init */
void game_start (); /* game start */
void bye ();
void game_init ();
/*******/
TOOGLE* get_item (int num);
void init_map ();
void init_perso ();
void load_map ();
void save_map ();
int hbs_object (int lay , int x , int y);
int play_sfx (int s);
/* vars */
extern Map map;
Perso *p (int num);
extern DATAFILE *perso_data , *tiles , *sound_data,*other_data;
extern BITMAP *buffer;
extern int level;
extern Timer mytime;
extern int max_tiles;
extern int max_items;
#define RIGHT 0
#define LEFT  1
#define JUMP  2
#define SHOOT 3
#define UP 4
#define DOWN 5
#define MaxKeys 6

const char *get_name (DATAFILE *a , int b);
extern JGMOD *battle_mod,*menu_mod;
extern Sound snd;
extern volatile int counter_game;

#define blitS(a,b) blit(a,b,0,0,0,0,SCREEN_W,SCREEN_H)
int is_key (int,int);

class Choix {
	public :
	int x,y,max,ech,start;
	int cx,cy;
	int cxx;
	int c_delay;
	BITMAP *image;
	Choix (int,int,int,int,int,BITMAP*);
	~Choix ();
	int update ();
	void show (BITMAP *bmp);
	int active;
	int pressed;
};

typedef struct {
	int mod;
	int file_number;
	const char *name;
}LEVEL;
void load_map_file (char *);
void highcolor_fade_in (BITMAP*,int);
void highcolor_fade_out (int);
extern int default_bananas;
void set_config_vars ();
void read_config_vars ();
extern int gfx_w , gfx_h , gfx_flag , gfx_depth;
extern int fullscreen;
int set_mode ();
#endif
