/*This is a library of useful functions.
It consists of anything I might want to use
somewhere else. This file is exempt from any
license the software it is used with has and
can be distributed and used as you please.*/

#include "useful.h"

int randnum(int num) {
  return rand()/(int)(((unsigned)RAND_MAX + 1) / (num+1));
}

void draw_image(BITMAP *src, BITMAP *dest, int x, int y) {
  masked_blit(src, dest, 0, 0, x, y, src->w, src->h);
}

void flip_to_screen(BITMAP *bmp) {
  blit(bmp, screen, 0, 0, 0, 0, bmp->w, bmp->h);
}

void log(char data[1024]) {
  time_t curtime = time(0);
  ofstream file("error.log", ios::app);
  file << ctime(&curtime) << "    " << data << endl;
  file.close();
  allegro_message("%s\n", data);
}

void screenshot(void) {
  BITMAP *bmp;
  PALETTE pal;

  get_palette(pal);
  bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
  save_bitmap("runeworld.bmp", bmp, pal);
  destroy_bitmap(bmp);
}

void mask_image(BITMAP *bmp, int maskcol) {
  int x, y;

  for (y = 0; y < bmp->h; y++) {
    for (x = 0; x < bmp->w; x++) {
      if (getpixel(bmp, x, y) == maskcol) putpixel(bmp, x, y, bitmap_mask_color(bmp));
    }
  }
}
