/*This is the main source file
for my SpeedHack 06 entry:
Space Ships
Copyright James Stanley 2006
ssp.shorturl.com*/

#include "main.h"

BITMAP *canvas;
BITMAP *menu;
BITMAP *banana;
BITMAP *gamebg;
BITMAP *help;
BITMAP *mapimg[10];
BITMAP *player;
BITMAP *enemyimg;
BITMAP *bulletimg;
BITMAP *congratu;
BITMAP *level;
BITMAP *death;
BITMAP *highscore;
BITMAP *newhigh;

int map[3][62][15];
/*Map definition:
0 - Nothing
1 - Rock
2 - Left edged square
3 - Upper edged square
4 - Lower edged square
5 - Right edged square
6 - Bottom right edged square
7 - Bottom left edged square
8 - Top right edged square
9 - Top left edged square*/

/*Enemy and banana file definition:
Number of items
X Y
X Y
X Y
etc.*/

volatile int counter = 0;
int start = 0;//The first level. May sometime introduce a cheat to alter this
int points = 0;
int highest = 0;

vector<bullet*> bullets;
vector<enemy*> enemies;
vector<banane*> bananes;

int main() {
	int action;
	int i,x,y,curlevel;
	char *file = "";

	//Initialisation
	srand((unsigned)time(NULL));

	allegro_init();

	set_window_title("Space Ships by James Stanley");

	set_color_depth(24);

	if (set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0) != 0) {
		allegro_message("Video error. %s", allegro_error);
		exit(0);
	}

	install_keyboard();
	install_timer();

	//Graphics
	canvas = create_bitmap(992, 240);
	menu = load_bitmap("media/menu.tga", NULL);
	banana = load_bitmap("media/banana.tga", NULL);
	gamebg = load_bitmap("media/gamebg.tga", NULL);
	help = load_bitmap("media/help.tga", NULL);
	player = load_bitmap("media/player.tga", NULL);
	enemyimg = load_bitmap("media/enemy.tga", NULL);
	bulletimg = load_bitmap("media/bullet.tga", NULL);
	congratu = load_bitmap("media/congrats.tga", NULL);
	level = load_bitmap("media/level.tga", NULL);
	death = load_bitmap("media/death.tga", NULL);
	highscore = load_bitmap("media/highscore.tga", NULL);
	newhigh = load_bitmap("media/newhigh.tga", NULL);

	//Masking
	mask_image(banana, makecol(255,0,255));
	mask_image(player, makecol(255,0,255));
	mask_image(bulletimg, makecol(255,0,255));
	mask_image(enemyimg, makecol(255,0,255));

	//Map images
	mapimg[0] = create_bitmap(16, 16);
	rectfill(mapimg[0], 0, 0, 15, 15, makecol(255,0,255));
	mapimg[1] = load_bitmap("media/wall.tga", NULL);
	mapimg[2] = load_bitmap("media/walll.tga", NULL);
	mapimg[3] = load_bitmap("media/wallt.tga", NULL);
	mapimg[4] = load_bitmap("media/wallb.tga", NULL);
	mapimg[5] = load_bitmap("media/wallr.tga", NULL);
	mapimg[6] = load_bitmap("media/wallbr.tga", NULL);
	mapimg[7] = load_bitmap("media/wallbl.tga", NULL);
	mapimg[8] = load_bitmap("media/walltr.tga", NULL);
	mapimg[9] = load_bitmap("media/walltl.tga", NULL);
	for(i = 0; i < 10; i++) {
	 mask_image(mapimg[i],makecol(255,0,255));
	}

	//Load maps
	for(i = 0; i < 3; i++) {
	switch(i) {//I can't lookup the syntax of sprintf. No internet access.
	 case 0:
	  file = "media/map1.txt";
	  break;
	 case 1:
	  file = "media/map2.txt";
	  break;
	 case 2:
	  file = "media/map3.txt";
	  break;
	}
	ifstream maps(file, ios::in);
	 for(y = 0; y < 15; y++) {
	  for(x = 0; x < 62; x++) {
		maps >> map[i][x][y];
	  }
	 }
	}
	
	//Timers
	LOCK_FUNCTION(timer);
	LOCK_VARIABLE(counter);
	install_int(timer, 50);

	//Main loops
	while(1) {
		points = 50;
		action = show_menu();
		switch(action) {
			case 0:
			 show_help();
			 break;
			case 1:
			 load_high();
			 show_high();
			 curlevel = play_game(start);
			 while(curlevel) {
				curlevel = play_game(curlevel);
			 }
			 break;
			case 2:
			 exit(0);
			 break;
		}
	}
}
END_OF_MAIN()

int show_menu(void) {
	while(1) {
		flip_to_screen(menu);
		if(key[KEY_F1]) return(0);
		if(key[KEY_F2]) return(1);
		if(key[KEY_ESC]) return(2);
	}
	return(2);//Quit if we manage to exit an infinite loop.
}

void show_help(void) {
	flip_to_screen(help);
	rest(1000);
	exit(0);
}

int play_game(int level) {
 int quit = 0;
 int x,y,n,m;
 int white = makecol(255,255,255);
 unsigned int i,j;
 BITMAP *themap;

 char *file = "";

 int show = 20;

 themap = create_bitmap(992,240);

 //Player stuff
 int px=10,py=112,pxs,ptx,pty;//Player X,Y, Player Tile X,Y
 int curplayer = 0; //0 for first, 1 for second
 int oldx, oldy, oldox;//So that we can't drive through rock, so that we don't scroll away
 int offset = 0;//For the side scrolling magic. Mwa ha ha.
 int count = 0;//Can I shoot now?
 int bananacnt = 0, bananatot;//banana count, banana total
 int timetook = 200;//The time. If larger than 0, the player gets it's value in points.

 //Get the map
 draw_image(gamebg, themap, 0, 0);
 for(y = 0; y < 15; y++) {
  for(x = 0; x < 62; x++) {
	draw_image(mapimg[map[level][x][y]], themap, (x*16), (y*16));
  }
 }

 //Load the enemy ships
 enemies.clear();
 switch(level) {
  case 0:
	file = "media/enemy1.txt";
	break;
  case 1:
	file = "media/enemy2.txt";
	break;
  case 2:
	file = "media/enemy3.txt";
	break;
 }
 ifstream enemis(file, ios::in);
 enemis >> n;
 for(m = 0; m < n; m++) {
  enemis >> x;
  enemis >> y;
  enemies.push_back(new enemy(x,y));
 }
 enemis.close();

 //Load the bananas
 bananes.clear();
 switch(level) {
  case 0:
	file = "media/banana1.txt";
	break;
  case 1:
	file = "media/banana2.txt";
	break;
  case 2:
	file = "media/banana3.txt";
	break;
 }
 ifstream bananis(file, ios::in);
 bananis >> bananatot;
 for(m = 0; m < bananatot; m++) {
  bananis >> x;
  bananis >> y;
  bananes.push_back(new banane(x,y));
 }
 bananis.close();

 //Last minute initialisation
 ptx = (px+8) / 16;
 pty = (py+8) / 16;
 pxs = 2;
 bullets.clear();

 while(!quit) {
  if(counter > 0) {//A basic form of timing ;)
	//Control enemy ships
	for(i = 0; i < enemies.size(); i++) {
		oldx = enemies[i]->x;
		oldy = enemies[i]->y;
		switch(randnum(3)) {
		 case 0:
			enemies[i]->xs -= 4;
			break;
		 case 1:
			enemies[i]->xs += 3;//They tended to go towards the right
			break;
		 case 2:
			enemies[i]->y -= 4;
			break;
		 case 3:
			enemies[i]->y += 4;
			break;
		}
		enemies[i]->x += enemies[i]->xs;
		enemies[i]->count++;
		if((enemies[i]->count >= 2) && (enemies[i]->xs < 0)){
			shoot((enemies[i]->x)+8, (enemies[i]->y)+8, enemies[i]->xs-6);
			enemies[i]->count = 0;
		}
		if(enemies[i]->x < 0) enemies[i]->x = 0;
		if(enemies[i]->x > 976) enemies[i]->x = 976;
		if(enemies[i]->y < 0) enemies[i]->y = 0;
		if(enemies[i]->y > 224) enemies[i]->y = 224;
		for(j = 0; j < bullets.size(); j++) {
			if(bullets[j]->xs > 0) {//then it can't be theirs, because they can only shoot leftwards.
				if((((enemies[i]->x)+8) >= bullets[j]->x) && (((enemies[i]->x)+8) <= (bullets[j]->x)+16)) {
				 if((((enemies[i]->y)+8) >= bullets[j]->y) &&(((enemies[i]->y)+8) <= (bullets[j]->y)+16)) {
					enemies[i]->life -= 1;
					delete bullets[j];
					bullets.erase(bullets.begin() + j);
				 }
				}
			}
		}

		enemies[i]->tx = ((enemies[i]->x) + 8) / 16;
		enemies[i]->ty = ((enemies[i]->y) + 8) / 16;
		if((map[level][enemies[i]->tx][enemies[i]->ty]) == 1) {//We've collided with a rock
			enemies[i]->x = oldx;
			enemies[i]->y = oldy;
			enemies[i]->xs = 0;
		}
		if(enemies[i]->life < 0) {
			delete enemies[i];
			enemies.erase(enemies.begin() + i);
			points += 100;//Presumably the players killed it.
		}
	}

	//Get input
	switch(curplayer) {
		case 0:
		 if(key[KEY_UP]) py -= 3;
		 if(key[KEY_DOWN]) py +=  3;
		 if(key[KEY_LEFT]) pxs -=  3;
		 if(key[KEY_RIGHT]) pxs +=  3;
		 break;
		case 1:
		 if(key[KEY_W]) py -= 3;
		 if(key[KEY_S]) py +=  3;
		 if(key[KEY_A]) pxs -= 3;
		 if(key[KEY_D]) pxs +=  3;
		 break;
	}
	if(key[KEY_SPACE] && count >= 5) { shoot((px+8), (py+8), pxs+6); count = 0; }
	if(key[KEY_F3]) quit = 1;

	//Control the player
	oldx = px;
	oldy = py;
	if(points < 0) { die(); return(0); }
	count++;
	timetook--;
	oldox = offset;
	if(pxs < 0) pxs = 0;
	if(pxs > 16) pxs = 16;
	px += pxs;
	offset -= pxs;
	ptx = (px+8) / 16;
	pty = (py+8) / 16;
	if(map[level][ptx][pty] == 1) {
		pxs = 0;
		px = oldx;
		py = oldy;
		offset = oldox;
		ptx = px / 16;
		pty = py / 16;
	}

	if(px > 976) {
		level_complete((level+1), bananacnt, (bananatot-bananacnt), points, timetook);
		if(timetook > 0) points += (timetook/10);
		if(level < 2) {
			return(level+1);
		}
		else {
			congrats();
			quit = 1;
		}
	}
	if(py < 0) py = 0;
	if(py > 224) py = 224;

	if(offset > 0) offset = 0;
	if(offset < -672) offset = -672;

	//Update bullets
	for(i = 0; i < bullets.size(); i++) {
		bullets[i]->x += bullets[i]->xs;
		bullets[i]->tx = ((bullets[i]->x) + 4) / 16;
		bullets[i]->ty = ((bullets[i]->y) + 2) / 16;
		bullets[i]->ttl--;
		if(bullets[i]->x < 0 || bullets[i]->x > 992 || bullets[i]->y < 0 || bullets[i]->y > 240) {
			delete bullets[i];
			bullets.erase(bullets.begin() + i);
			goto skip; //Hack 'n' Kludge...
		}
		if(bullets[i]->xs < 0) {//then it can't be ours, because we can only shoot rightwards.
			if(((px+8) >= bullets[i]->x) && ((px+8) <= (bullets[i]->x)+16)) {
				if(((py+8) >= bullets[i]->y) &&((py+8) <= (bullets[i]->y)+16)) {
					points -= 7;
					delete bullets[i];
					bullets.erase(bullets.begin() + i);
					goto skip; //Hack 'n' Kludge...
				}
			}
		}
		if(map[level][bullets[i]->tx][bullets[i]->ty] == 1) {
			delete bullets[i];
			bullets.erase(bullets.begin() + i);
			goto skip; //Hack 'n' Kludge...
		}
		if(bullets[i]->ttl <= 0) {
			delete bullets[i];
			bullets.erase(bullets.begin() + i);
			goto skip; //Hack 'n' Kludge...
		}
		skip://For the Hack 'n' Kludging
		hack_n_kludge();
	}

	//Update bananas
	for(i = 0; i < bananes.size(); i++) {
		bananes[i]->angle += 10;
		if(((px+8) >= bananes[i]->x) && ((px+8) <= (bananes[i]->x)+16)) {
			if(((py+8) >= bananes[i]->y) &&((py+8) <= (bananes[i]->y)+16)) {
				curplayer = !curplayer;
				show = 20;
				bananacnt++;
				points += 10;
				delete bananes[i];
				bananes.erase(bananes.begin() + i);
			}
		}
	}

	//Do the drawing
	draw_image(themap, canvas, 0, 0);
	for(i = 0; i < bullets.size(); i++) {
		draw_image(bulletimg, canvas, bullets[i]->x, bullets[i]->y);
	}
	for(i = 0; i < bananes.size(); i++) {
		rotate_sprite(canvas, banana, bananes[i]->x, bananes[i]->y, itofix(bananes[i]->angle));
	}
	for(i = 0; i < enemies.size(); i++) {
		draw_image(enemyimg, canvas, enemies[i]->x, enemies[i]->y);
	}
	draw_image(player, canvas, px, py);
	textprintf_ex(canvas, font, (-offset)+5, 5, white, -1, " Points: %d", points);
	textprintf_ex(canvas, font, (-offset)+5, 15,white, -1, "Bananas: %d", bananacnt);
	textprintf_ex(canvas, font, (-offset)+5, 25,white, -1, "      x: %d", px);
	textprintf_ex(canvas, font, (-offset)+5, 35,white, -1, "      y: %d", py);
	if(show > 0) {
		textprintf_centre_ex(canvas, font, (-offset)+160, 120, white, -1, "Driving position: %d", curplayer+1);
	}

	show--;

	draw_image(canvas, screen, offset, 0);

	counter = 0;
  }
 }
 return(0);
}

void shoot(int _x, int _y, int _xs) {
	bullets.push_back(new bullet(_x, _y, _xs, 50));
}

void level_complete(int whichlevel, int bananas, int bananaleft, int points, int thetime) {
	draw_image(level, canvas, 0, 0);
	textprintf_centre_ex(canvas, font, 160, 64, makecol(0,0,0), -1, "%d", whichlevel);
	textprintf_centre_ex(canvas, font, 160, 96, makecol(0,0,0), -1, "%d", bananas);
	textprintf_centre_ex(canvas, font, 160, 140, makecol(0,0,0), -1, "%d", bananaleft);
	if(thetime > 0) {
	  textprintf_centre_ex(canvas, font, 160, 196, makecol(0,0,0), -1, "%d, and %d for your haste", points, (thetime/10));
	}
	else {
	  textprintf_centre_ex(canvas, font, 160, 196, makecol(0,0,0), -1, "%d", points);
	}
	flip_to_screen(canvas);
	rest(3000);
	if(whichlevel == 3) points += 100;//For completing the game
	if(thetime > 0) {
		check_high(points+thetime);
	}
	else {
		check_high(points);
	}
}


void die(void) {
	flip_to_screen(death);
	rest(3000);
}

void congrats(void) {
	flip_to_screen(congratu);
	rest(6000);
}

void load_high(void) {
	ifstream file("media/high.txt", ios::in);
	file >> highest;
	file.close();
}

void set_high(int score) {
	ofstream file("media/high.txt", ios::out);
	file << score;
	highest = score;
	file.close();
}

void show_high(void) {
	draw_image(highscore, canvas, 0, 0);
	textprintf_centre_ex(canvas, font, 160, 120, makecol(0,0,0), -1, "%d", highest);
	flip_to_screen(canvas);
	rest(3000);
}

void new_high(void) {
	flip_to_screen(newhigh);
	rest(3000);
}

void check_high(int score) {
	if(score > highest) {
		set_high(score);
		new_high();
		show_high();
	}
}

void timer(void) {
	counter++;
}
END_OF_FUNCTION(timer)
