/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------\
|                                    menu.cpp                                  |
|       Ce module contient les routines du menu de TA3D                        |
|                                                                              |
\-----------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "3do.h"					// Pour la lecture des fichiers 3D
#include "cob.h"					// Pour la lecture et l'éxecution des scripts
//#include "fbi.h"					// Pour la gestion des unités
#include "EngineClass.h"			// Inclus le moteur
#include "tnt.h"					// Inclus le chargeur de cartes
#include "menu.h"
#include "gui.h"
#include "taconfig.h"

#define size	20.0f

GLuint glfond;
FONT *allegro_font;
FONT *fnt;

void main_menu(void)
{
	set_mouse_range(0,0,639,479);

	allegro_font=load_font("title_font.tga",NULL,NULL);

	GLuint tex_formatA,tex_format;
	if(g_useTextureCompression) {
		tex_formatA=GL_COMPRESSED_RGBA_ARB;
		tex_format=GL_COMPRESSED_RGB_ARB;
		}
	else {
		tex_formatA=GL_RGBA8;
		tex_format=GL_RGB8;
		}

	fnt=allegro_gl_convert_allegro_font_ex(allegro_font,AGL_FONT_TYPE_TEXTURED,-1.0f,GL_RGBA8);

	set_color_depth(32);
	allegro_gl_use_alpha_channel(false);
	BITMAP *bmp=load_bitmap("menu.tga",NULL);
	glfond=allegro_gl_make_texture(bmp);
	glBindTexture(GL_TEXTURE_2D, glfond);
	allegro_gl_set_texture_format(tex_format);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	destroy_bitmap(bmp);

	bool done=false;

	allegro_gl_set_allegro_mode();

	ReInitTexSys();

	glScalef(SCREEN_W/640.0f,SCREEN_H/480.0f,1.0f);

	int i;

	float dt=0.0f;
	int time=Atimer;
	float Conv=1.0f/SECS_TO_TIMER(1);

	float h=text_height(allegro_font);

	BITMAP *tst[3];
	GLuint mnu[3];
	GLuint flame=LoadMaskedTex("fire.tga","firea.tga");
	mnu[0]=LoadTex("exit.tga");
	mnu[1]=LoadTex("options.tga");
	mnu[2]=LoadTex("play.tga");
	tst[0]=load_bitmap("exit.tga",NULL);
	tst[1]=load_bitmap("options.tga",NULL);
	tst[2]=load_bitmap("play.tga",NULL);

	int px[3]={	320,	160,	480 };
	int py[3]={	400,	300,	300 };

	VECTOR part[100];
	for(i=0;i<100;i++) {
		part[i].x=-size;	part[i].y=-size;
		part[i].z=0.0f;
		}

	int n=0;

	cursor_type=CURSOR_DEFAULT;

	do
	{
		do
		{
			dt=(Atimer-time)*Conv;
			rest(1);
		}while(dt<0.01f);
		time=Atimer;

		if(key[KEY_ESC])	done=true;

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Efface l'écran

		PutTex(glfond,0.0f,0.0f,640.0f,480.0);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		allegro_gl_printf(fnt,320.0f-text_length(allegro_font,TA3D_ENGINE_VERSION)*0.5f,200.0f,0.0f,0xFFFFFF,TA3D_ENGINE_VERSION);

		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

		int index=-1;
		for(i=0;i<3;i++)
			for(int e=0;e<10;e+=2)
				if(px[i]-120-e<mouse_x && px[i]+120+e>mouse_x && py[i]-40-e<mouse_y && py[i]+40+e>mouse_y) {
					int rx=(mouse_x-(px[i]-120-e))*240/(240+2*e);
					int ry=(mouse_y-(py[i]-40-e))*80/(80+2*e);
					if(getpixel(tst[i],rx,ry)) {
						index=i;
						i=3;
						e=10;
						}
					}

		for(i=0;i<3;i++) {
			if(i==index)
				glBlendFunc(GL_ONE,GL_ONE);
			else
				glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
			for(int e=0;e<10;e+=2)
				PutTex(mnu[i],px[i]-120-e,py[i]-40-e,px[i]+120+e,py[i]+40+e);
			}
		glColor4f(1.0f,1.0f,1.0f,1.0f);

		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		switch(index)
		{
		case -1:
			part[n%100].x=-size;
			part[n%100].y=-size;
			break;
		case 0:
		case 1:
		case 2:
			part[n%100].x=px[index]+120.0f*cos(n*0.15f)+((rand()%2001)-1000)*0.01f;
			part[n%100].y=py[index]+40.0f*cos(n*0.255f)+((rand()%2001)-1000)*0.01f;
			break;
		};

		for(i=0;i<100;i++) {
			int d=100-((n-i)%100);
			glColor4f(d*0.01f,d*0.01f,d*0.01f,d*0.01f);
			glPushMatrix();
			glTranslatef(part[i].x,part[i].y,0.0f);
			glRotatef((i&1) ? n : -n,0.0f,0.0f,1.0f);
			glTranslatef(-part[i].x,-part[i].y,0.0f);
			PutTex(flame,part[i].x-size,part[i].y-size,part[i].x+size,part[i].y+size);
			glPopMatrix();
			}
		n++;
		glColor4f(1.0f,1.0f,1.0f,1.0f);

		glDisable(GL_BLEND);

		draw_cursor();

		if(mouse_b) {
			set_mouse_range(0,0,SCREEN_W-1,SCREEN_H-1);
			switch(index)
			{
			case 0:
				done=true;
				break;
			case 1:
				config_menu();
				break;
			case 2:
				{
				char *map_name=select_map();

				if(map_name) {
					allegro_gl_unset_allegro_mode();

					set_mouse_range(0,0,SCREEN_W-1,SCREEN_H-1);
					play(map_name);

					allegro_gl_set_allegro_mode();
					ReInitTexSys();
					glScalef(SCREEN_W/640.0f,SCREEN_H/480.0f,1.0f);
					}
				}
				break;
			};
			set_mouse_range(0,0,639,479);
			cursor_type=CURSOR_DEFAULT;		// Curseur par standard
			}

		allegro_gl_flip();
	}while(!done);

	destroy_bitmap(tst[0]);
	destroy_bitmap(tst[1]);
	destroy_bitmap(tst[2]);

	allegro_gl_unset_allegro_mode();

	glDeleteTextures(1,&flame);
	glDeleteTextures(1,&glfond);
	glDeleteTextures(1,&mnu[0]);
	glDeleteTextures(1,&mnu[1]);
	glDeleteTextures(1,&mnu[2]);

	allegro_gl_destroy_font(fnt);

	destroy_font(allegro_font);
}

char *select_map(void)				// Cette fonction affiche un menu permettant à l'utilisateur de choisir une carte dans une liste et de la prévisualiser à l'écran
{
	set_mouse_range(0,0,639,479);

	bool done=false;

	allegro_gl_set_allegro_mode();

	ReInitTexSys();

	glScalef(SCREEN_W/640.0f,SCREEN_H/480.0f,1.0f);

	int i;

	float dt=0.0f;
	int time=Atimer;
	float Conv=1.0f/SECS_TO_TIMER(1);

	float h=text_height(allegro_font);

	int n=0;
	char **map_list=file_list("/maps",".tnt",&n);		// Obtient la liste des cartes

	char *choice=NULL;

	for(i=0;i<n;i++) {						// Nettoie la liste des cartes (enlève les préfixes "/maps/" et l'extension)
		char *tmp;
		*(strstr(map_list[i],"."))=0;
		tmp=strdup(strstr(map_list[i]+1,"/")+1);
		delete map_list[i];
		map_list[i]=tmp;
		}

	for(i=n-1;i>0;i--)
		for(int e=0;e<i-1;e++)
			if(strcasecmp(map_list[e],map_list[e+1])>0) {
				char *tmp=map_list[e+1];
				map_list[e+1]=map_list[e];
				map_list[e]=tmp;
				}

	int dec=0;			// Pour la gestion de la liste déroulante
	int amz=mouse_z;
	int o_sel=-1;
	int sel_index=-1;
	int index=-1;
	int m_timer=Atimer;

	bool dmini=false;		// Pour la minimap
	GLuint mini;
	int dx=0;
	int dy=0;

	bool ok_status=false;		// Pour les boutons
	bool cancel_status=false;
	bool o_ok_status=false;
	bool o_cancel_status=false;

	do
	{
		do
		{
			dt=(Atimer-time)*Conv;
			rest(1);
		}while(dt<0.02f);
		time=Atimer;

		o_sel=sel_index;

		o_ok_status=ok_status;
		o_cancel_status=cancel_status;
		ok_status=false;
		cancel_status=false;
		if(mouse_b==1 && mouse_y>=440 && mouse_y<=460) {
			ok_status=(mouse_x>=360 && mouse_x<=440);
			cancel_status=(mouse_x>=520 && mouse_x<=600);
			}

		if(mouse_b==0 && !ok_status && o_ok_status) {		// Click sur ok
			if(sel_index!=-1) {
				done=true;
				char tmp[200];
				tmp[0]=0;
				strcat(tmp,"/maps/");
				strcat(tmp,map_list[sel_index]);
				strcat(tmp,".tnt");
				choice=strdup(tmp);		// Copie le nom de la carte sélectionnée
				}
			}
		if(mouse_b==0 && !cancel_status && o_cancel_status)			// Click sur retour
			done=true;

		if(key[KEY_ESC]) {
			while(key[KEY_ESC])
				rest(1);
			done=true;
			}
		if(key[KEY_ENTER]) {
			if(sel_index!=-1) {
				done=true;
				char tmp[200];
				tmp[0]=0;
				strcat(tmp,"/maps/");
				strcat(tmp,map_list[sel_index]);
				strcat(tmp,".tnt");
				choice=strdup(tmp);		// Copie le nom de la carte sélectionnée
				}
			}
		if((Atimer-m_timer)*Conv>=0.1f) {
			if(key[KEY_DOWN])	{	sel_index++;	m_timer=Atimer;	}
			if(key[KEY_UP])		{	sel_index--;	m_timer=Atimer;	}
			if(o_sel!=sel_index && sel_index==-1)	sel_index=0;
			if(sel_index<-1)	sel_index=-1;
			if(sel_index>=n)	sel_index=n-1;
			}

		dec+=amz-mouse_z;
		if((Atimer-m_timer)*Conv>=0.2f) {
			if(mouse_x>=15.0f && mouse_x<320.0f && mouse_y>=30.0f && mouse_y<30.0f+h) {
				m_timer=Atimer;
				dec--;
				}
			if(mouse_x>=15.0f && mouse_x<320.0f && mouse_y>=470.0f-h && mouse_y<470.0f) {
				m_timer=Atimer;
				dec++;
				}
			}
		if(dec<0) dec=0;
		if(dec>n+1-440.0f/h) dec=(int)(n+1-440.0f/h);
		amz=mouse_z;

		if(mouse_x>=15.0f && mouse_x<320.0f && mouse_y>=30.0f && mouse_y<470.0f) {
			index=(int)((mouse_y-30.0f)/h+dec);
			if(index>=n) index=-1;		// On ne sort pas de l'intervalle fixé
			if(mouse_b==1)
				sel_index=index;
			}
		else
			index=-1;

		if(sel_index!=o_sel && sel_index>=0) {
			if(dmini)
				glDeleteTextures(1,&mini);
			char tmp[200];
			tmp[0]=0;
			strcat(tmp,"/maps/");
			strcat(tmp,map_list[sel_index]);
			strcat(tmp,".tnt");
			byte *data=load_file(tmp);
			if(data) {
				mini=load_tnt_minimap(data,&dx,&dy);
				free(data);
				dmini=true;
				}
			else
				dmini=false;
			}

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Efface l'écran

		glColor4f(1.0f,1.0f,1.0f,1.0f);
		PutTex(glfond,0.0f,0.0f,640.0f,480.0);

		glDisable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glColor4f(0.0f,0.0f,0.0f,0.5f);
		glBegin(GL_QUADS);
			glVertex2f(10.0f,25.0f);
			glVertex2f(630.0f,25.0f);
			glVertex2f(630.0f,470.0f);
			glVertex2f(10.0f,470.0f);
		glEnd();
		glColor4f(1.0f,1.0f,1.0f,0.5f);
		glBegin(GL_LINE_LOOP);
			glVertex2f(10.0f,25.0f);
			glVertex2f(630.0f,25.0f);
			glVertex2f(630.0f,470.0f);
			glVertex2f(10.0f,470.0f);
		glEnd();
		glBegin(GL_LINE_LOOP);
			glVertex2f(347.0f,50.0f);
			glVertex2f(603.0f,50.0f);
			glVertex2f(603.0f,306.0f);
			glVertex2f(347.0f,306.0f);
		glEnd();
		glBegin(GL_LINES);
			glVertex2f(320.0f,26.0f);
			glVertex2f(320.0f,469.0f);
		glEnd();
		glEnable(GL_TEXTURE_2D);

		glColor4f(1.0f,1.0f,1.0f,1.0f);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		allegro_gl_printf(fnt,320.0f-text_length(allegro_font,"Cartes")*0.5f,0.0f,0.0f,0xFFFFFF,"Cartes");

		for(i=0;i<n;i++)
			if(30.0f+h*(i-dec)<470.0f-h && h*(i-dec)>=0) {
				if(i==index || i==sel_index) {
					glDisable(GL_TEXTURE_2D);
					glEnable(GL_BLEND);
					glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
					glBegin(GL_QUADS);
						if(i==sel_index)
							glColor4f(0.0f,0.0f,0.5f,0.5f);
						else
							glColor4f(0.25f,0.25f,0.5f,0.5f);
						glVertex2f(15.0f,30.0f+h*(i-dec));
						glVertex2f(319.0f,30.0f+h*(i-dec));
						if(i==sel_index)
							glColor4f(0.0f,0.0f,1.0f,0.5f);
						else
							glColor4f(0.5f,0.5f,1.0f,0.5f);
						glVertex2f(319.0f,30.0f+h*(i-dec+0.5f));
						glVertex2f(15.0f,30.0f+h*(i-dec+0.5f));

						glVertex2f(15.0f,30.0f+h*(i-dec+0.5f));
						glVertex2f(319.0f,30.0f+h*(i-dec+0.5f));
						if(i==sel_index)
							glColor4f(0.0f,0.0f,0.5f,0.5f);
						else
							glColor4f(0.25f,0.25f,0.5f,0.5f);
						glVertex2f(319.0f,30.0f+h*(i-dec+1));
						glVertex2f(15.0f,30.0f+h*(i-dec+1));
					glEnd();
					glColor4f(1.0f,1.0f,1.0f,0.5f);
					glEnable(GL_TEXTURE_2D);
					glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
					}
				allegro_gl_printf(fnt,20.0f,30.0f+h*(i-dec),0.0f,0xFFFFFF,map_list[i]);
				}

		glColor4f(1.0f,1.0f,1.0f,1.0f);

		glDisable(GL_BLEND);

		if(dmini) {
			glVertex2f(347.0f,50.0f);
			glVertex2f(603.0f,50.0f);
			glVertex2f(603.0f,306.0f);
			glVertex2f(347.0f,306.0f);
			glBindTexture(GL_TEXTURE_2D,mini);
			float ldx=dx*256.0f/252.0f*0.5f;
			float ldy=dy*256.0f/252.0f*0.5f;
			glBegin(GL_QUADS);

				glTexCoord2f(0.0f,0.0f);
				glVertex2f(475.0f-ldx,178.0f-ldy);

				glTexCoord2f(dx/252.0f,0.0f);
				glVertex2f(475.0f+ldx,178.0f-ldy);
					
				glTexCoord2f(dx/252.0f,dy/252.0f);
				glVertex2f(475.0f+ldx,178.0f+ldy);
			
				glTexCoord2f(0.0f,dy/252.0f);
				glVertex2f(475.0f-ldx,178.0f+ldy);

			glEnd();
			}

		glbutton("ok",360.0f,440.0f,440.0f,460.0f,ok_status);
		glbutton("retour",520.0f,440.0f,600.0f,460.0f,cancel_status);

		draw_cursor();

		allegro_gl_flip();
	}while(!done);

	if(dmini)
		glDeleteTextures(1,&mini);

	for(i=0;i<n;i++)
		free(map_list[i]);
	free(map_list);

	allegro_gl_unset_allegro_mode();

	return choice;
}

void config_menu(void)
{
	set_mouse_range(0,0,639,479);

	TA3D_CONFIG	config_manager;
	config_manager.set_config_file("ta3d.cfg");
	config_manager.add_option("showfps",true,false,NULL);
	config_manager.add_option("fps_limit",false,true,NULL);
	config_manager.add_option("wireframe",true,false,NULL);
	config_manager.add_option("particle",true,false,NULL);
	config_manager.add_option("trees",true,false,NULL);
	config_manager.add_option("shadow",true,false,NULL);
	config_manager.add_option("shadow_quality",false,false,NULL);
	config_manager.add_option("shadow_r",false,true,NULL);
	config_manager.add_option("priority_level",false,false,NULL);
	config_manager.add_option("timefactor",false,true,NULL);
	config_manager.add_option("screen_width",false,false,NULL);
	config_manager.add_option("screen_height",false,false,NULL);
	config_manager.add_option("fullscreen",true,false,NULL);
	config_manager.read_config_file();

	bool done=false;

	allegro_gl_set_allegro_mode();

	ReInitTexSys();

	glScalef(SCREEN_W/640.0f,SCREEN_H/480.0f,1.0f);

	int i;

	float dt=0.0f;
	int time=Atimer;
	float Conv=1.0f/SECS_TO_TIMER(1);

	float h=text_height(allegro_font);
	int	amb=mouse_b;

	bool save=false;

	bool ok_status=false;		// Pour les boutons
	bool cancel_status=false;
	bool o_ok_status=false;
	bool o_cancel_status=false;

	do
	{
		do
		{
			dt=(Atimer-time)*Conv;
			rest(1);
		}while(dt<0.02f);
		time=Atimer;

		if(key[KEY_ESC]) {
			while(key[KEY_ESC])
				rest(1);
			done=true;
			}

		o_ok_status=ok_status;
		o_cancel_status=cancel_status;
		ok_status=false;
		cancel_status=false;
		if(mouse_b==1 && mouse_y>=440 && mouse_y<=460) {
			ok_status=(mouse_x>=440 && mouse_x<=520);
			cancel_status=(mouse_x>=120 && mouse_x<=200);
			}

		if(mouse_b==0 && !ok_status && o_ok_status) {		// Click sur ok
			done=true;
			save=true;
			}
		if(mouse_b==0 && !cancel_status && o_cancel_status)			// Click sur retour
			done=true;

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Efface l'écran

		glColor4f(1.0f,1.0f,1.0f,1.0f);
		PutTex(glfond,0.0f,0.0f,640.0f,480.0);

		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glEnable(GL_BLEND);
		allegro_gl_printf(fnt,320.0f-0.5f*text_length(fnt,"OPTIONS"),8.0f,0.0f,0xFFFFFF,"OPTIONS");
		for(int i=0;i<config_manager.nb_options;i++) {		// affiche les options
			allegro_gl_printf(fnt,32.0f,32.0f+i*h,0.0f,0xFFFFFF,config_manager.options[i].name);
			char buf[100];
			if(config_manager.options[i].boolean)
				uszprintf(buf,100,"%s",config_manager.get_option(i) ? "on" : "off");
			else if(config_manager.options[i].floatting)
				uszprintf(buf,100,"%f",config_manager.get_option(i));
			else
				uszprintf(buf,100,"%d",(int)config_manager.get_option(i));
			allegro_gl_printf(fnt,600.0f-text_length(fnt,buf),32.0f+i*h,0.0f,0xFFFFFF,buf);
			}

		glDisable(GL_BLEND);
		glbutton("ok",440.0f,440.0f,520.0f,460.0f,ok_status);
		glbutton("annuler",120.0f,440.0f,200.0f,460.0f,cancel_status);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		if(mouse_x>=32 && mouse_x<=600 && mouse_y>=32 && mouse_y<32+h*config_manager.nb_options) {
			int idx=(int)((mouse_y-32)/h);
			glDisable(GL_TEXTURE_2D);
			glBegin(GL_QUADS);
				glColor4f(0.5f,0.5f,1.0f,0.0f);
				glVertex2f(32.0f,32.0f+idx*h);
				glVertex2f(600.0f,32.0f+idx*h);
				glColor4f(0.5f,0.5f,1.0f,0.5f);
				glVertex2f(600.0f,32.0f+(idx+0.5f)*h);
				glVertex2f(32.0f,32.0f+(idx+0.5f)*h);

				glVertex2f(32.0f,32.0f+(idx+0.5f)*h);
				glVertex2f(600.0f,32.0f+(idx+0.5f)*h);
				glColor4f(0.5f,0.5f,1.0f,0.0f);
				glVertex2f(600.0f,32.0f+(idx+1)*h);
				glVertex2f(32.0f,32.0f+(idx+1)*h);
			glEnd();
			glEnable(GL_TEXTURE_2D);
			glColor4f(1.0f,1.0f,1.0f,1.0f);
			if(mouse_b==1 && amb==0) {
				if(config_manager.options[idx].boolean)
					config_manager.set_option(config_manager.options[idx].name,config_manager.get_option(idx)==1.0f ? 0.0f : 1.0f);
				else {
					char titre[100],msg[100];
					uszprintf(titre,100,"valeur de %s",config_manager.options[idx].name);
					uszprintf(msg,100,"entrez une valeur pour %s",config_manager.options[idx].name);
					char *ans=msg_box(fnt,titre,msg,true);
					config_manager.set_option(config_manager.options[idx].name,atof(ans));
					free(ans);
					switch(idx)
					{
					case 1:			// fps_limit
						if(config_manager.get_option(idx)==0.0f)
							config_manager.set_option(config_manager.options[idx].name,-1.0f);
						break;
					case 6:			// shadow_quality
						if(config_manager.get_option(idx)<=0.0f)
							config_manager.set_option(config_manager.options[idx].name,1.0f);
						else if(config_manager.get_option(idx)>12.0f)
							config_manager.set_option(config_manager.options[idx].name,12.0f);
						break;
					case 7:			// shadow_r
						if(config_manager.get_option(idx)<0.0f)
							config_manager.set_option(config_manager.options[idx].name,0.0f);
						else if(config_manager.get_option(idx)>100.0f)
							config_manager.set_option(config_manager.options[idx].name,100.0f);
						break;
					case 8:			// priority_level
						if(config_manager.get_option(idx)<0.0f)
							config_manager.set_option(config_manager.options[idx].name,0.0f);
						else if(config_manager.get_option(idx)>2.0f)
							config_manager.set_option(config_manager.options[idx].name,2.0f);
						break;
					case 9:			// timefactor
						if(config_manager.get_option(idx)<=0.0f)
							config_manager.set_option(config_manager.options[idx].name,1.0f);
						else if(config_manager.get_option(idx)>10.0f)
							config_manager.set_option(config_manager.options[idx].name,10.0f);
						break;
					case 10:		// screen_width
						if(config_manager.get_option(idx)<=0.0f)
							config_manager.set_option(config_manager.options[idx].name,1.0f);
						break;
					case 11:		// screen_height
						if(config_manager.get_option(idx)<=0.0f)
							config_manager.set_option(config_manager.options[idx].name,1.0f);
						break;
					};
					}
				}
			}
		amb=mouse_b;

		glDisable(GL_BLEND);
		glEnable(GL_TEXTURE_2D);

		draw_cursor();

		allegro_gl_flip();
	}while(!done);

	if(save)
		config_manager.write_config_file();

	allegro_gl_unset_allegro_mode();
}
