/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------\
|                                     ia.cpp                                   |
|       Ce module est responsable de l'intelligence artificielle               |
|                                                                              |
\-----------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "3do.h"					// Pour la lecture des fichiers 3D
#include "cob.h"					// Pour la lecture et l'éxecution des scripts
#include "tdf.h"					// Pour la gestion des éléments du jeu
#include "EngineClass.h"			// Inclus le moteur
//#include "ia.h"

void BRAIN::save(FILE *file)		// Enregistre le réseau de neurones
{
	fwrite("BRAIN",5,1,file);			// Identifiant du format du fichier
	fwrite(&n,sizeof(int),1,file);		// Nombre d'entrées
	fwrite(&p,sizeof(int),1,file);		// Nombre de sorties
	fwrite(&q,sizeof(int),1,file);		// Taille de la couche intermédiaire

	for(int i=n;i<nb_neuron;i++)		// Enregistre les poids
		if(i<n+q)
			fwrite(neuron[i].weight,sizeof(float)*n,1,file);
		else
			fwrite(neuron[i].weight,sizeof(float)*q,1,file);
}

int BRAIN::load(FILE *file)		// Charge le réseau de neurones
{
	char tmp[6];

	fread(tmp,5,1,file);				// Identifiant du format du fichier
	tmp[5]=0;
	if(strcmp(tmp,"BRAIN")!=0)	{		// Vérifie si le fichier est bien du type attendu
		return 1;
		}

	destroy();		// Au cas où

	fread(&n,sizeof(int),1,file);		// Nombre d'entrées
	fread(&p,sizeof(int),1,file);		// Nombre de sorties
	fread(&q,sizeof(int),1,file);		// Taille de la couche intermédiaire
	nb_neuron=p+q+n;

	neuron=(NEURON*) malloc(sizeof(NEURON)*nb_neuron);
	n_out=(float*) malloc(sizeof(float)*p);

	for(int i=0;i<p;i++)
		n_out[i]=0.0f;

	for(int i=0;i<n;i++)
		neuron[i].weight=NULL;

	for(int i=n;i<nb_neuron;i++)		// Lit les poids
		if(i<n+q) {
			neuron[i].weight=(float*) malloc(sizeof(float)*n);
			fread(neuron[i].weight,sizeof(float)*n,1,file);
			}
		else {
			neuron[i].weight=(float*) malloc(sizeof(float)*q);
			fread(neuron[i].weight,sizeof(float)*q,1,file);
			}

	return 0;
}

BRAIN *copy_brain(BRAIN *brain,BRAIN *dst)			// Copie un réseau de neurones
{
	BRAIN *copy=dst;
	if(copy==NULL)
		copy=(BRAIN*) malloc(sizeof(BRAIN));
	copy->init();
	copy->nb_neuron=brain->nb_neuron;
	copy->n=brain->n;
	copy->p=brain->p;
	copy->q=brain->q;
	copy->neuron=(NEURON*) malloc(sizeof(NEURON)*copy->nb_neuron);
	copy->n_out=(float*) malloc(sizeof(float)*copy->p);
	for(int i=0;i<brain->nb_neuron;i++) {
		if(i<brain->p)
			copy->n_out[i]=0.0f;
		if(brain->neuron[i].weight==NULL)
			copy->neuron[i].weight=NULL;
		else {
			if(i>=copy->n && i<copy->nb_neuron-copy->p) {
				copy->neuron[i].weight=(float*) malloc(sizeof(float)*brain->q);
				for(int e=0;e<brain->q;e++)
					copy->neuron[i].weight[e]=brain->neuron[i].weight[e];
				}
			else if(i>=copy->n) {
				copy->neuron[i].weight=(float*) malloc(sizeof(float)*brain->n);
				for(int e=0;e<brain->n;e++)
					copy->neuron[i].weight[e]=brain->neuron[i].weight[e];
				}
			else
				copy->neuron[i].weight=NULL;
			}
		}
	return copy;
}

inline byte int2brain_value(int a)			// Evaluateur de quantité pour réseau de neurones
{
	if(a==0)	return BRAIN_VALUE_NULL;
	if(a<=5)	return BRAIN_VALUE_LOW;
	if(a<=15)	return BRAIN_VALUE_MEDIUM;
	if(a<=50)	return BRAIN_VALUE_HIGH;
	return BRAIN_VALUE_MAX;
}

void AI_PLAYER::think(MAP *map)				// La vrai fonction qui simule l'Intelligence Artificielle
{
	bool change=false;

	/*--------------Analyse du champ de vision des unités------------------------------------------*/

	if(unit_id<=units.last_index) {
		if(units.unit[unit_id].flags!=0 && units.unit[unit_id].owner_id==player_id) {
			int r=unit_manager.unit_type[units.unit[unit_id].type_id].SightDistance+(int)(units.unit[unit_id].h+0.5f)>>4;
			int px=(int)(units.unit[unit_id].Pos.x+0.5f*map->map_w+0.5f)>>4;
			int py=(int)(units.unit[unit_id].Pos.z+0.5f*map->map_h+0.5f)>>4;
			int r2=r*r;
			int enemy_mx=0, enemy_my=0;
			int metal_mx=0, metal_my=0;
			int energy_mx=0, energy_my=0;
			int enemy_nb=0;
			int metal_nb=0;
			int energy_nb=0;
			byte enemy_type=0;
			for(int y=0;y<=r;y++) {
				int x=(int)(sqrt(r2-y*y)+0.5f);
				int ry=py-y;
				if(ry>=0 && ry<map->bloc_h)
					for(int rx=px-x;rx<=px+x;rx++)
						if(rx>=0 && rx<map->bloc_w) {
							if(map->map_data[ry][rx].unit_idx>=0) {	// Unité??
								if(units.unit[map->map_data[ry][rx].unit_idx].owner_id!=player_id) {		// Ennemi ??
									enemy_mx+=rx;
									enemy_my+=ry;
									enemy_nb++;
									switch(unit_manager.unit_type[units.unit[map->map_data[ry][rx].unit_idx].type_id].TEDclass)
									{
									case CLASS_UNDEF:
									case CLASS_ENERGY:
									case CLASS_SPECIAL:
									case CLASS_FORT:
									case CLASS_METAL:
									case CLASS_COMMANDER:
									case CLASS_CNSTR:
										enemy_type|=UNIT_TYPE_UNKN;
										break;
									case CLASS_WATER:
									case CLASS_SHIP:
										enemy_type|=UNIT_TYPE_SHIP;
										break;
									case CLASS_VTOL:
										enemy_type|=UNIT_TYPE_VTOL;
										break;
									case CLASS_KBOT:
										enemy_type|=UNIT_TYPE_KBOT;
										break;
									case CLASS_PLANT:
										enemy_type|=UNIT_TYPE_PLANT;
										break;
									case CLASS_TANK:
										enemy_type|=UNIT_TYPE_TANK;
										break;
									};
									}
								}
							if(map->map_data[ry][rx].stuff>=0) {		// Un élément de décors??
								if(feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].energy>0) {		// Energie
									energy_mx+=px;
									energy_my+=py;
									energy_nb+=feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].energy;
									}
								if(feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].metal>0) {		// Metal
									metal_mx+=px;
									metal_my+=py;
									metal_nb+=feature_manager.feature[features.feature[map->map_data[ry][rx].stuff].type].metal;
									}
								}
							}
				}
			if(enemy_nb>0) {			// Ennemis repérés
				ZONE enemy_zone;
				enemy_zone.type=ZONE_ENEMY;
				enemy_zone.Pos=units.unit[unit_id].Pos;
				enemy_zone.size=r<<4;
				enemy_zone.brain_value=int2brain_value(enemy_nb);
				change=true;
				}
			else {
				ZONE enemy_zone;
				enemy_zone.type=ZONE_ENEMY;
				enemy_zone.Pos=units.unit[unit_id].Pos;
				enemy_zone.size=r<<4;
				change|=strategic_data.remove_data(enemy_zone);
				}
			if(energy_nb>0) {			// Energie repérée
				ZONE energy_zone;
				energy_zone.type=ZONE_ENERGY;
				energy_zone.Pos=units.unit[unit_id].Pos;
				energy_zone.brain_value=int2brain_value(energy_nb);
				energy_zone.size=r<<4;
				strategic_data.fusion_zone(energy_zone);
				change=true;
				}
			else {
				ZONE energy_zone;
				energy_zone.type=ZONE_ENERGY;
				energy_zone.Pos=units.unit[unit_id].Pos;
				energy_zone.size=r<<4;
				change|=strategic_data.remove_data(energy_zone);
				}
			if(metal_nb>0) {			// Metal repéré
				ZONE metal_zone;
				metal_zone.type=ZONE_METAL;
				metal_zone.Pos=units.unit[unit_id].Pos;
				metal_zone.brain_value=int2brain_value(metal_nb);
				metal_zone.size=r<<4;
				strategic_data.fusion_zone(metal_zone);
				change=true;
				}
			else {
				ZONE metal_zone;
				metal_zone.type=ZONE_METAL;
				metal_zone.Pos=units.unit[unit_id].Pos;
				metal_zone.size=r<<4;
				change|=strategic_data.remove_data(metal_zone);
				}
			}
		}
	else
		unit_id=0;

	unit_id++;

	/*---------------------------------------------------------------------------------------------*/

	/*------------Conception d'une stratégie-------------------------------------------------------*/

	if(change || strategy.orders==NULL) {			// S'il faut changer de stratégie

			/* évalue la situation */
		byte min_nb_zone=int2brain_value(strategic_data.min_zone_number());
		byte metal_stock=int2brain_value((int)(players.metal[player_id]*100/players.metal_s[player_id]));
		byte energy_stock=int2brain_value((int)(players.energy[player_id]*100/players.energy_s[player_id]));
		byte enemy_nb=strategic_data.enemy_zone_number();
		byte energy_av=strategic_data.energy_zone_number();
		byte metal_av=strategic_data.metal_zone_number();
		}

	/*---------------------------------------------------------------------------------------------*/

	/*------------Applique la stratégie créée------------------------------------------------------*/

	if(strategy.orders!=NULL) {						// S'il y a une stratégie
		}

	/*---------------------------------------------------------------------------------------------*/
}
