#ifndef _WORLD_H
#define _WORLD_H



#include <allegro.h>



#include "object.h"
#include "tile.h"
#include "gsprite.h"
#include "view.h"



class Square {
public:
   unsigned short tile;
   bool obstruct;
   int collideTest;////////////////////////////////////////
private:
};

class World {
public:
   World(void);
   ~World(void);
   int load(char *fileName);
   int save(char *fileName);
   int unload(void);
   Square *getSquare(int x, int y) {
      if (x >= 0 && y >= 0 && x < w && y < h) {
         return &(squares[x][y]);
      }
      return NULL;
   }
   OVER_RGB *getLighting(int x, int y) {
      if (x >= 0 && y >= 0 && x < w + 1 && y < h + 1) {
         return &(lighting[x][y]);
      }
      return NULL;
   }
   bool obstructPoint(float x, float y);
//   bool obstructLine(float x1, float y1, float x2, float y2);
   bool obstructCircle(float x, float y, float r);
   inline bool obstructLine(float x1, float y1, float x2, float y2)
   {
      float gradient;
      float rangeX, rangeY;
      int step;
      float position;
      float start, end;
      bool stepX;
      float squareX, squareY;
      float intercept;

      rangeX = x2 - x1;
      rangeY = y2 - y1;

      if (fabs(rangeX) > fabs(rangeY)) {
         stepX = true;
         step = rangeX > 0 ? 1 : -1;
         gradient = rangeY / rangeX;
         start = x1;
         end = x2;
         intercept = y1 - (gradient * x1);
      }
      else {
         stepX = false;
         step = rangeY > 0 ? 1 : -1;
         gradient = rangeX / rangeY;
         start = y1;
         end = y2;
         intercept = x1 - (gradient * y1);
      }

      for (position = start; (step * position) < (step * end); position += step) {
         if (stepX == true) {
            unitToSquare(position, (position * gradient) + intercept, &squareX, &squareY);
         }
         else {
            unitToSquare((position * gradient) + intercept, position, &squareX, &squareY);
         }
         if (squareX != (int)squareX || squareY != (int)squareY) {
            if (getSquare((int)(squareX), (int)(squareY))->obstruct == true) {
               return true;
            }
         }
      }

      return false;
   }
   int create(void);
   int destroy(void);
   void draw(View *view);
   void update(void);
   void setSquareWUnits(float _squareWUnits) { squareWUnits = _squareWUnits; }
   float getSquareWUnits(void) { return squareWUnits; }
   void setSquareHUnits(float _squareHUnits) { squareHUnits = _squareHUnits; }
   float getSquareHUnits(void) { return squareHUnits; }
   void setSquareUnits(float _squareWUnits, float _squareHUnits) {
      setSquareWUnits(_squareWUnits);
      setSquareHUnits(_squareHUnits);
   }
   void squareToUnit(float squareX, float squareY, float *unitX, float *unitY) {
      *unitX = squareX * squareWUnits;
      *unitY = squareY * squareHUnits;
   }
   void unitToSquare(float unitX, float unitY, float *squareX, float *squareY) {
      *squareX = unitX / squareWUnits;
      *squareY = unitY / squareHUnits;
   }
   void setW(int _w) { w = _w; }
   int getW(void) { return w; }
   void setH(int _h) { h = _h; }
   int getH(void) { return h; }
   void setLightStrength(float _lightStrength) { lightStrength = _lightStrength; }
   float getLightStrength(void) { return lightStrength; }
   void setLightColour(RGB _lightColour) { lightColour = _lightColour; }
   RGB getLightColour(void) { return lightColour; }
   void setLightColour(int _lightColourR, int _lightColourG, int _lightColourB) { lightColour.r = _lightColourR; lightColour.g = _lightColourG; lightColour.b = _lightColourB; }
   void getLightColour(int *_lightColourR, int *_lightColourG, int *_lightColourB) { *_lightColourR = lightColour.r; *_lightColourG = lightColour.g; *_lightColourB = lightColour.b; }
   void setLightColourR(int _lightColourR) { lightColour.r = _lightColourR; }
   int getLightColourR(void) { return lightColour.r; }
   void setLightColourG(int _lightColourG) { lightColour.g = _lightColourG; }
   int getLightColourG(void) { return lightColour.g; }
   void setLightColourB(int _lightColourB) { lightColour.b = _lightColourB; }
   int getLightColourB(void) { return lightColour.b; }
   void setTileSet(TileSet * _tileSet) { tileSet = _tileSet; }
   TileSet *getTileSet(void) { return tileSet; }
   ObjectList *getObjects(void) { return objects; }
//   bool collision(Object *object, float posX, float posY, float velX, float velY, float time, float timeStep, float colPosX, float colPosY, float reflectX, float reflectY, Object *colObj, int colSquareX, int colSquareY) {
//   }
protected:
   int w, h;
   float squareWUnits, squareHUnits;
   float lightStrength;
   RGB lightColour;
   TileSet *tileSet;
   OVER_RGB **lighting;
   Square **squares;
   ObjectList *objects;
};

extern World *currentWorld;

#endif
