#include "view.h"



void View::viewToUnit(int vX, int vY, float *uX, float *uY)
{
   *uX = (vX + focusX - (w / 2)) / unitWPixels;
   *uY = (vY + focusY - (h / 2)) / unitHPixels;
}

void View::unitToView(float uX, float uY, int *vX, int *vY)
{
   *vX = (int)(uX * unitWPixels - focusX + (w / 2));
   *vY = (int)(uY * unitHPixels - focusY + (h / 2));
}

void View::viewToScreen(int vX, int vY, int *sX, int *sY)
{
   *sX = vX + x;
   *sY = vY + y;
}

void View::screenToView(int sX, int sY, int *vX, int *vY)
{
   *vX = sX - x;
   *vY = sY - y;
}

View::View(void)
{
   x = y = w = h = 0;
   focusX = focusY = 0;
   destBitmap = NULL;
   drawBitmap = NULL;
}

View::~View(void)
{
   destroy_bitmap(drawBitmap);
}

