#ifndef _VIDEO_H
#define _VIDEO_H



#include <allegro.h>



class Video {
public:
   Video(void) {
      w = 320;
      h = 200;
      depth = 8;
      card = GFX_SAFE;
      buffer = NULL;
   }
   Video(int _card, int _w, int _h, int _depth) {
      w = h = 0;
      depth = 0;
      card = 0;
      buffer = NULL;
      set(_card, _w, _h, _depth);
   }
   ~Video(void) {
      w = h = 0;
      depth = 0;
      card = 0;
      buffer = NULL;
      destroyBuffer();
   }
   int set(int _card, int _w, int _h, int _depth) {
      int retMode, retBuffer;
      int oldCard, oldW, oldH, oldDepth;
      bool recreateBuffer;

      oldCard = getCard();
      oldW = getW();
      oldH = getH();
      oldDepth = getDepth();

      if (getBuffer() != NULL) {
         recreateBuffer = true;
      }
      else {
         recreateBuffer = false;
      }

      setCard(_card);
      setW(_w);
      setH(_h);
      setDepth(_depth);

      set_color_depth(getDepth());
      retMode = set_gfx_mode(getCard(), getW(), getH(), 0, 0);

      destroyBuffer();
      retBuffer = createBuffer();

      if (retMode < 0 || retBuffer < 0) {
         setCard(oldCard);
         setW(oldW);
         setH(oldH);
         setDepth(oldDepth);

         set_color_depth(oldDepth);

         if (recreateBuffer) {
            createBuffer();
         }

         return -1;
      }

      return 0;
   }
   void update(void) {
      acquire_screen();
      vsync();
      blit(buffer, screen, 0, 0, 0, 0, w, h);
      release_screen();
   }
   void setW(int _w) { w = _w; }
   int getW(void) { return w; }
   void setH(int _h) { h = _h; }
   int getH(void) { return h; }
   void setDepth(int _depth) { depth = _depth; }
   int getDepth(void) { return depth; }
   void setCard(int _card) { card = _card; }
   int getCard(void) { return card; }
   BITMAP *getBuffer(void) { return buffer; }
   int createBuffer(void) {
      if ((buffer = create_bitmap(getW(), getH())) == NULL) {
         return -1;
      }

      return 0;
   }
   void destroyBuffer(void) {
      if (buffer != NULL) {
         destroy_bitmap(buffer);
      }
      buffer = NULL;
   }
protected:
   BITMAP *buffer;
   int w, h;
   int depth;
   int card;
};



#endif
