#include <stdio.h>
#include "tile.h"



#define TEMP_FILE "temp.$$$"

#define LINE_BUFFER_SIZE (256 + 1)

#define COMMENT_CHAR '#'

int processAnim(FILE *file, int start, int stop)
{
   return 0;
}

int processFrame(FILE *file, int start, int stop)
{
   return 0;
}

int processTileSet(FILE *file, int start, int stop)
{
   return 0;
}

typedef struct TYPE_LIST {
   char *name;
   int (*func)(FILE *file, int start, int stop);
   TYPE_LIST *typeProcess;
} TYPE_LIST;

TYPE_LIST typeProcessAnim[] = {
   {"Frame",   processFrame,   NULL},
   {NULL,      NULL,           NULL}
};

TYPE_LIST typeProcess[] = {
   {"TileSet", processTileSet, NULL},
   {"Anim",    processAnim,    typeProcessAnim},
   {NULL,      NULL,           NULL}
};



void Tile::draw(BITMAP *destination, int _x, int _y)
{
   draw_sprite(destination, bitmap, _x - x, _y - y);
}

int TileSet::create(void)
{
   if ((tiles = new Tile[tileCount]) == NULL) return -1;
   if ((anims = new ANIM[animCount]) == NULL) return -1;

   return 0;
}

int TileSet::destroy(void)
{
   delete [] tiles;
   delete [] anims;
   return 0;
}

int TileSet::load(char *file_name)
{
   FILE *file = NULL, *ppFile = NULL;

   // Open tile set file
   file = fopen(file_name, "rt");
   if (file == NULL) {
      return -1;
   }

   // Open file for preprocessed tile set
   ppFile = fopen(TEMP_FILE, "wt+");
   if (file == NULL) {
      return -1;
   }

   // Preprocess
   if (preprocess(file, ppFile) < 0) {
      return -1;
   }
   if (fclose(file) == EOF) {
      return -1;
   }

   // Process
   if (process(ppFile) < 0) {
      return -1;
   }

   // Clean up
   if (fclose(ppFile) == EOF) {
      return -1;
   }
   delete_file(TEMP_FILE);

   return 0;
}

int TileSet::unload(void)
{
   int current;
   int setSize;

   // Set
   setSize = tileCount;

   // Animations
   for (current = 0; current < setSize; current++) {
      destroy_bitmap(tiles[current].bitmap);
   }
   for (current = 0; current < animCount; current++) {
      delete [] anims[current].frames;
   }
   destroy();

   return 0;
}

int TileSet::preprocess(FILE *in, FILE *out)
{
   char buffer[LINE_BUFFER_SIZE];
   long inPos, outPos;
   int pos;

   // Store file positions
   inPos = ftell(in);
   outPos = ftell(out);

   // Set file positions to start of files
   rewind(in);
   rewind(out);

   // Copy preprocessed strings from in to out
   while (fgets(buffer, LINE_BUFFER_SIZE, in) != NULL) { // Read from in
      // Remove comments
      pos = 0;
      while (pos < LINE_BUFFER_SIZE - 1) {
         if (buffer[pos] == COMMENT_CHAR) {
            buffer[pos] = '\n';
            buffer[pos + 1] = '\0';
            break;
         }
         else {
            pos++;
         }
      }

      // Some non-comment data in line
      if (pos > 0) {
         // Write to out
         fputs(buffer, out);
      }
   }

   // Reset file positions
   fseek(in, inPos, SEEK_SET);
   fseek(out, outPos, SEEK_SET);

   return 0;
}

int TileSet::process(FILE *file)
{
   char buffer[LINE_BUFFER_SIZE];
   long filePos;
   int setSize;
   int curTile;
   int tileBX, tileBY, tileW, tileH, tileX, tileY;
   char setBitmap[80 + 1];
   BITMAP *bitmap = NULL;

   // Store file position
   filePos = ftell(file);

   // Set file position to start of file
   rewind(file);

   // Set
   // Bitmap
   if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
      return -1;
   }
   if (sscanf(buffer, "%s", setBitmap) < 1) {
      return -1;
   }
   bitmap = load_bitmap(setBitmap, NULL);

   // Size
   if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
      return -1;
   }
   if (sscanf(buffer, "%d", &setSize) < 1) {
      return -1;
   }
   tileCount = setSize;
   if (create() < 0) {
      return -1;
   }

   // Tiles
   for (curTile = 0; curTile < setSize; curTile++) {
      if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
         return -1;
      }
      if (sscanf(buffer, "%d, %d, %d, %d, %d, %d", &tileBX, &tileBY, &tileW, &tileH, &tileX, &tileY) < 6) {
         return -1;
      }
      tiles[curTile].w = tileW;
      tiles[curTile].h = tileH;
      tiles[curTile].x = tileX;
      tiles[curTile].y = tileY;
      tiles[curTile].bitmap = create_bitmap(tileW, tileH);
      blit(bitmap, tiles[curTile].bitmap, tileBX, tileBY, 0, 0, tileW, tileH);
   }

   destroy_bitmap(bitmap);

   // Reset file position
   fseek(file, filePos, SEEK_SET);

   return 0;
}
