#ifndef _OBJECT_H
#define _OBJECT_H



#include "main.h"
#include "view.h"
#include "doublist.h"
#include "math.h"
#include "collide.h"



#define INTERFACE_GET_SET(var, type, desc, func) \
   func void set##desc(type _##var) { var = _##var; } \
   func type get##desc(void) { return var; }



class Vector {
public:
   float x, y;
private:
};

class Controller {
public:
   void update(void) {}
   INTERFACE_GET_SET(x, float, X, );
   INTERFACE_GET_SET(y, float, Y, );
   INTERFACE_GET_SET(a, int, A, );
   INTERFACE_GET_SET(b, int, B, );
private:
   float x, y;
   int a, b;
};

class Object {
public:
   Object(void) {
      exist = true;
      dir = 0.0;
      x = y = 0.0;
      speed = 0.0;
      velocityX = velocityY = 0.0;
      lightStrength = 0.0;
      lightColour.r = lightColour.g = lightColour.b = 0;
      lightRadiusFull = 64.0;
      lightRadiusNone = 128.0;
      parent = NULL;
      health = 100.0;
   }
   virtual ~Object(void) {}
   virtual void destroy(void) { exist = false; }
   virtual void draw(View *view) = 0;
   virtual void update(void) = 0;

   virtual void setLightStrength(float _lightStrength) { lightStrength = _lightStrength; }
   virtual float getLightStrength(void) { return lightStrength; }
   virtual void setLightColour(RGB _lightColour) { lightColour = _lightColour; }
   virtual RGB getLightColour(void) { return lightColour; }
   virtual void setLightColour(int _lightColourR, int _lightColourG, int _lightColourB) { lightColour.r = _lightColourR; lightColour.g = _lightColourG; lightColour.b = _lightColourB; }
   virtual void getLightColour(int *_lightColourR, int *_lightColourG, int *_lightColourB) { *_lightColourR = lightColour.r; *_lightColourG = lightColour.g; *_lightColourB = lightColour.b; }
   virtual void setLightColourR(int _lightColourR) { lightColour.r = _lightColourR; }
   virtual int getLightColourR(void) { return lightColour.r; }
   virtual void setLightColourG(int _lightColourG) { lightColour.g = _lightColourG; }
   virtual int getLightColourG(void) { return lightColour.g; }
   virtual void setLightColourB(int _lightColourB) { lightColour.b = _lightColourB; }
   virtual int getLightColourB(void) { return lightColour.b; }
   virtual void setLightRadiusNone(float _lightRadiusNone) { lightRadiusNone = _lightRadiusNone; }
   virtual float getLightRadiusNone(void) { return lightRadiusNone; }
   virtual void setLightRadiusFull(float _lightRadiusFull) { lightRadiusFull = _lightRadiusFull; }
   virtual float getLightRadiusFull(void) { return lightRadiusFull; }

   virtual void setX(float _x) { x = _x; }
   virtual float getX(void) { return x; }
   virtual void setY(float _y) { y = _y; }
   virtual float getY(void) { return y; }
   virtual void setPosition(float _x, float _y) { setX(_x); setY(_y); }

   virtual void setVelocityX(float _velocityX) { velocityX = _velocityX; }
   virtual float getVelocityX(void) { return velocityX; }
   virtual void setVelocityY(float _velocityY) { velocityY = _velocityY; }
   virtual float getVelocityY(void) { return velocityY; }
   virtual void setVelocity(float _velocityX, float _velocityY) { setVelocityX(_velocityX); setVelocityY(_velocityY); }

   virtual void setSpeed(float _speed) { speed = _speed; }
   virtual float getSpeed(void) { return speed; }
   virtual void setDir(float _dir) { dir = _dir; }
   virtual float getDir(void) { return dir; }
   virtual void setExist(bool _exist) { exist = _exist; }
   virtual bool getExist(void) { return exist; }
   virtual void setController(Controller *_controller) { controller = _controller; }
   virtual Controller *getController(void) { return controller; }
   virtual void setCollisionRadius(float _collisionRadius) { collisionRadius = _collisionRadius; }
   virtual float getCollisionRadius(void) { return collisionRadius; }
   virtual void setDrawRadius(float _drawRadius) { drawRadius = _drawRadius; }
   virtual float getDrawRadius(void) { return drawRadius; }
   virtual bool testObjectCollision(Object *object) {
      float collision;

      collision = getCollisionRadius() + object->getCollisionRadius();
      if (getDistance(getX(), getY(), object->getX(), object->getY()) < collision) {
         return true;
      }

      return false;
   }
   virtual bool testObjectCollisionEx(Object *object) {
      float cx, cy, rx, ry, nx, ny, ct, xx, yy;

      collide_circle_to_circle_ex(getX(), getY(), getCollisionRadius(), object->getX(), object->getY(), object->getCollisionRadius(), getVelocityX() + object->getVelocityX(), getVelocityY() + object->getVelocityY(), 1.0, &xx, &yy, &cx, &cy, &ct, &rx, &ry, &nx, &ny);

      float collision;

      collision = getCollisionRadius() + object->getCollisionRadius();
      if (getDistance(getX(), getY(), object->getX(), object->getY()) < collision) {
         return true;
      }

      return false;
   }
   virtual void heal(float _heal) {}
   virtual void damage(float _damage) {}
   virtual void collide(Object *object) {}
   virtual void setParent(Object *_parent) { parent = _parent; }
   virtual Object *getParent(void) { return parent; }
   INTERFACE_GET_SET(health, float, Health, virtual);
protected:
   float lightStrength;
   float lightRadiusFull;
   float lightRadiusNone;
   RGB lightColour;
   float speed;
   float drawRadius;
   float collisionRadius;
   float x, y;
   float velocityX, velocityY;
   Controller *controller;
   bool exist;
   float dir;
   Object *parent;
   float health;
};

typedef DoubleList<Object> ObjectList;

class Particle {
public:
   Particle(void) { x = y = size = density = 0; }
   ~Particle(void) {}
   float x, y;
   Vector velocity;
   float size;
   float density;
   RGB colour;
};

class Explosion : public Object {
public:
   Explosion(int _count);
   ~Explosion(void);
   void draw(View *view);
   void update(void);
   int count;
   Particle *particles;
   float radius;
protected:
};

class Light : public Object {
public:
   Light(void) : Object() {
      lightStrength = 2.0;
      lightColour.r = 0;
      lightColour.g = 0;
      lightColour.b = 0;
      lightRadiusFull = 64.0;
      lightRadiusNone = 128.0;
   }
   ~Light(void) {}
   void draw(View *view);
   void update(void) {}
protected:
};

class AnimObject : public Object {
public:
   AnimObject(void);
   ~AnimObject(void);
   int anim;
   int animFrame;
   int animFrameWait;
   AnimSet *animSet;
   void animate(void);
protected:
};

class Missile : public AnimObject {
public:
   Missile(void) : AnimObject() {
      age = 0;
      animSet = &missile;
      lightStrength = 1.0;
      lightColour.r = 0;
      lightColour.g = 127;
      lightColour.b = 255;
      lightRadiusFull = 32.0;
      lightRadiusNone = 64.0;
      collisionRadius = 8.0;
      health = 100.0;
      explode = false;
   }
   ~Missile(void) {}
   void draw(View *view);
   void update(void);
   void collide(Object *object);
   int age;
   bool explode;
protected:
};

class Character : public AnimObject {
public:
   Character(void) : AnimObject() {
      fireWait = 0;
      animSet = &guy;
      lightStrength = 0.5;
      lightColour.r = 255;
      lightColour.g = 255;
      lightColour.b = 255;
      lightRadiusFull = 64.0;
      lightRadiusNone = 128.0;
      collisionRadius = 10.0;
      health = 100.0;
   }
   ~Character(void) {}
   void draw(View *view);
   void update(void);
   int fireWait;
protected:
};

class Enemy : public AnimObject {
public:
   Enemy(void) : AnimObject() {
      changeActionWait = 0;
      animSet = &enemy;
      lightStrength = 0.5;
      lightColour.r = 255;
      lightColour.g = 255;
      lightColour.b = 255;
      lightRadiusFull = 64.0;
      lightRadiusNone = 128.0;
      collisionRadius = 10.0;
      health = 100.0;
   }
   ~Enemy(void) {}
   void draw(View *view);
   void update(void);
   int changeActionWait;
   int action;
   void damage(float _damage);
protected:
};



#endif
