#include "object.h"



#include "anim.h"
#include "math.h"
#include "main.h"
#include "world.h"



AnimObject::AnimObject(void)
   : Object()
{
   animFrameWait = 0;
   animFrame = 0;
   anim = 0;
   animSet = NULL;
}

AnimObject::~AnimObject(void)
{
}

void AnimObject::animate(void)
{
   if (animFrameWait >= animSet->anims[anim].frames[animFrame].wait) {
      animFrameWait = 0;
      ++animFrame %= animSet->anims[anim].size;
   }
   else {
      animFrameWait++;
   }
}

void Light::draw(View *view) {
   int viewX, viewY;
   view->unitToView(x, y, &viewX, &viewY);
   float rate = 256.0 / (float)MAX(MAX(lightColour.r, lightColour.g), lightColour.b);
   RGB colour;
   colour.r = MID(0, (int)(lightColour.r * rate), 255);
   colour.g = MID(0, (int)(lightColour.g * rate), 255);
   colour.b = MID(0, (int)(lightColour.b * rate), 255);
   drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
   set_trans_blender(0, 0, 0, 127);
   circlefill(view->getDrawBitmap(), viewX, viewY, (int)(lightRadiusFull / 8), makecol_depth(video->getDepth(), colour.r, colour.g, colour.b));
   circle(view->getDrawBitmap(), viewX, viewY, (int)(lightRadiusNone / 8), makecol_depth(video->getDepth(), colour.r, colour.g, colour.b));
}

Explosion::Explosion(int _count)
   : Object()
{
   count = _count;
   particles = new Particle[count];
   radius = 0;
   lightStrength = 2.0;
   lightColour.r = 255;
   lightColour.g = 127;
   lightColour.b = 0;
   lightRadiusFull = 128.0;
   lightRadiusNone = 256.0;
   collisionRadius = 16;

   for (int i = 0; i < count; i++) {
      float direction = ((float)rand() / (float)RAND_MAX) * 360.0;
      float velocity = ((float)rand() / (float)RAND_MAX) * 0.5;
      particles[i].velocity.x = sin(direction) * velocity;
      particles[i].velocity.y = cos(direction) * velocity;
      particles[i].density = 255;
      particles[i].size = rand() % 8 + 1;
      particles[i].colour.r = 192 + rand() % 64;
      particles[i].colour.g = 64 + rand() % 64;
      particles[i].colour.b = 32 + rand() % 32;
   }
}

Explosion::~Explosion(void)
{
   delete [] particles;
}

void Explosion::draw(View *view)
{
   int viewX, viewY;
   float particleRadius;

   view->unitToView(x, y, &viewX, &viewY);

   drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
   set_add_blender(0, 0, 0, 255);
   if (radius <= 64) {
//      circlefill(view->getDrawBitmap(), viewX, viewY, (int)radius, makecol_depth(videoDepth, 256 - (int)(radius * 4), 256 - (int)(radius * 4), 256 - (int)(radius * 4)));
      circlefill(view->getDrawBitmap(), viewX, viewY, (int)radius, makecol_depth(video->getDepth(), 128 - (int)(radius * 2), 128 - (int)(radius * 2), 128 - (int)(radius * 2)));
   }
   for (int i = 0; i < count; i++) {
      int r = (int)(((float)particles[i].colour.r / (float)255) * (float)particles[i].density);
      int g = (int)(((float)particles[i].colour.g / (float)255) * (float)particles[i].density);
      int b = (int)(((float)particles[i].colour.b / (float)255) * (float)particles[i].density);
      int colour = makecol_depth(video->getDepth(), r, g, b);
//      circlefill(view->getDrawBitmap(), viewX + (int)particles[i].x, viewY + (int)particles[i].y, (int)particles[i].size, colour);
      particleRadius = particles[i].size * (1.0 - (getDistance(0, 0, particles[i].x, particles[i].y) / 64.0));
      circlefill(view->getDrawBitmap(), viewX + (int)particles[i].x, viewY + (int)particles[i].y, (int)particleRadius, colour);
   }
}

void Explosion::update(void)
{
   int allOff = TRUE;

   if (!currentWorld->obstructPoint(x + velocityX, y + velocityY)) {
      x += velocityX;
      y += velocityY;
   }

   for (int i = 0; i < count; i++) {
      if (!currentWorld->obstructPoint(x + particles[i].x + particles[i].velocity.x, y + particles[i].y + particles[i].velocity.y)) {
//      if (!currentWorld->obstructCircle(x +  + particles[i].x + particles[i].velocity.x, y + particles[i].y + particles[i].velocity.y, getCollisionRadius())) {
         particles[i].x += particles[i].velocity.x;
         particles[i].y += particles[i].velocity.y;
      }
      if (particles[i].density > 0) {
         allOff = FALSE;
      }
      particles[i].density -= 2;
      if (particles[i].density < 0) particles[i].density = 0;
   }
   if (allOff == TRUE && radius >= 64) {
      destroy();
   }

   radius += 1.0;

   lightStrength = 1.0 * ((64 - radius) / 64);
}

void Missile::draw(View *view)
{
   int viewX, viewY;
   BITMAP *sprite = NULL;
   int fX;
   int fY;
//   int objectX, objectY, parentX, parentY;

   view->unitToView(x, y, &viewX, &viewY);

   sprite = animSet->anims[anim].frames[animFrame].bitmap;
   fX = animSet->anims[anim].frames[animFrame].x;
   fY = animSet->anims[anim].frames[animFrame].y;
   pivot_sprite(view->getDrawBitmap(), sprite, viewX, viewY, fX, fY, ftofix(dir * (256.0 / 360.0)));
//   view->unitToView(getX(), getY(), &objectX, &objectY);
//   view->unitToView(parent->getX(), parent->getY(), &parentX, &parentY);
//   line(view->getDrawBitmap(), parentX, parentY, objectX, objectY, 0xff0000);
}

void Missile::update(void)
{
   Object *object = NULL;

   animate();

//   if (!currentWorld->obstructPoint(x + velocityX, y + velocityY)) {
   if (!currentWorld->obstructCircle(x + velocityX, y + velocityY, getCollisionRadius())) {
      x += velocityX;
      y += velocityY;
   }
   else {
      explode = true;
   }

   if (age >= 120) {
      explode = true;
   }
   age++;

   if (explode == true) {
      object = NULL;
      object = new Explosion(128);
      object->setX(x);
      object->setY(y);
      object->setVelocityX(velocityX);
      object->setVelocityY(velocityY);
      currentWorld->getObjects()->push(object);
      destroy();
      play_sample(explosion, 127, 127, 1000, 0);
   }

   if (getHealth() <= 0.0) {
      explode = TRUE;
   }
}

void Missile::collide(Object *object)
{
   if (object != getParent()) {
      if (explode == false) {
         object->damage(25);
         explode = true;
      }
   }
}

void Character::draw(View *view)
{
   int viewX, viewY;
   BITMAP *sprite = NULL;
   int fX;
   int fY;

   view->unitToView(x, y, &viewX, &viewY);

   sprite = animSet->anims[anim].frames[animFrame].bitmap;
   fX = animSet->anims[anim].frames[animFrame].x;
   fY = animSet->anims[anim].frames[animFrame].y;
   pivot_sprite(view->getDrawBitmap(), sprite, viewX, viewY, fX, fY, ftofix(dir * (256.0 / 360.0)));
}

void Character::update(void)
{
   Missile *missile = NULL;
   float strafeSpeed;

   controller->update();

   velocityX *= 0.75;
   velocityY *= 0.75;
//   velocityX = 0.0;
//   velocityY = 0.0;

/*   if (runFlag) {
      speed = -controller->getY() * 2;
      strafeSpeed = controller->getX() * 2;
   }
   else {
//      speed = -controller->getY();
//      strafeSpeed = controller->getX();
      speed = (float)-controller->getY() / 4.0;
      strafeSpeed = (float)controller->getX() / 4.0;
   }*/
   speed = -controller->getY() / 4.0;
   strafeSpeed = controller->getX() / 4.0;
   if (runFlag) {
      speed *= 2;
      strafeSpeed *= 2;
   }

   velocityX += (float)cos(DEG_TO_BIN(dir)) * speed;
   velocityY += (float)sin(DEG_TO_BIN(dir)) * speed;

   if (strafeFlag) {
      velocityX += (float)cos(DEG_TO_BIN(dir + 90)) * strafeSpeed;
      velocityY += (float)sin(DEG_TO_BIN(dir + 90)) * strafeSpeed;
   }
   else {
      dir += controller->getX() * 2;
   }

   if (velocityX != 0 || velocityY != 0) animate();

//   if (!currentWorld->obstructPoint(x + velocityX, y + velocityY)) {
//      x += velocityX;
//      y += velocityY;
//   }

   if (!currentWorld->obstructCircle(x + velocityX, y + velocityY, getCollisionRadius())) {
      x += velocityX;
      y += velocityY;
   }

   if (controller->getA() && fireWait <= 0) {
      fireWait = 20;
      missile = new Missile;
      missile->setX(x);
      missile->setY(y);
//      missile->setDir(dir);
      missile->setDir(dir + (((float)rand() / (float)RAND_MAX) * 10.0 - 5.0));
      missile->setSpeed(4.0);
      missile->setVelocityX((float)cos(DEG_TO_BIN(missile->getDir())) * missile->getSpeed() + velocityX);
      missile->setVelocityY((float)sin(DEG_TO_BIN(missile->getDir())) * missile->getSpeed() + velocityY);
      missile->setParent(this);
      currentWorld->getObjects()->push(missile);
      play_sample(weapon, 127, 127, 1000, 0);
   }

   fireWait--;
   if (fireWait < 0) fireWait = 0;
}

void Enemy::draw(View *view)
{
   int viewX, viewY;
   BITMAP *sprite = NULL;
   int fX;
   int fY;

   view->unitToView(x, y, &viewX, &viewY);

   sprite = animSet->anims[anim].frames[animFrame].bitmap;
   fX = animSet->anims[anim].frames[animFrame].x;
   fY = animSet->anims[anim].frames[animFrame].y;
   pivot_sprite(view->getDrawBitmap(), sprite, viewX, viewY, fX, fY, ftofix(dir * (256.0 / 360.0)));
//   textprintf(view->getDrawBitmap(), font, viewX, viewY, 0x0000ff, "%f", getHealth());
}

void Enemy::update(void)
{
   if (changeActionWait <= 0) {
      action = rand() % 7;
      if (action < 2) {
         speed = 0;
      }
      else {
         speed = 1;
         dir = rand() % 360;
      }
      changeActionWait = rand() % 50 + 50;
   }

   velocityX = (float)cos(DEG_TO_BIN(dir)) * speed;
   velocityY = (float)sin(DEG_TO_BIN(dir)) * speed;

   if (velocityX != 0 || velocityY != 0) animate();

//   if (!currentWorld->obstructPoint(x + velocityX, y + velocityY)) {
//      x += velocityX;
//      y += velocityY;
//   }

   if (!currentWorld->obstructCircle(x + velocityX, y + velocityY, getCollisionRadius())) {
      x += velocityX;
      y += velocityY;
   }

   changeActionWait--;
   if (changeActionWait < 0) changeActionWait = 0;

   if (getHealth() <= 0.0) {
      play_sample(die, 127, 127, 1000, 0);
      destroy();
   }
}

void Enemy::damage(float _damage)
{
   setHealth(getHealth() - 25);
   play_sample(hit, 127, 127, 1000, 0);
}

