#include "main.h"



#include <allegro.h>
#include <stdlib.h>
#include <time.h>



#include "view.h"
#include "input.h"
#include "doublist.h"
#include "object.h"
#include "anim.h"
#include "world.h"
#include "tile.h"
#include "video.h"
#include "gui.h"



Video *video;

AnimSet guy;
AnimSet enemy;
AnimSet missile;

TileSet tile;

bool lightingFlag = true;

bool lightObstructionFlag = true;

int gameMode = GAME_MODE_PLAY;

int editMode = EDIT_MODE_TILE;

int brushTile = 1;
int cursorTile = 0;
int cursorX = 0;
int cursorY = 0;

bool cursorColour = false;
int cursorColourCount = 0;

bool runFlag = false;
bool strafeFlag = false;

SAMPLE *hit = NULL;
SAMPLE *weapon = NULL;
SAMPLE *die = NULL;
SAMPLE *explosion = NULL;



volatile int speedCounter = 0;

void incrementSpeedCounter(void)
{
   speedCounter++;
}
END_OF_FUNCTION(incrementSpeedCounter);

volatile int milliseconds = 0;
volatile int seconds = 0;
volatile int minutes = 0;
volatile int hours = 0;

volatile int frame = 0;
volatile long long int frameTotal = 0;
volatile int fps = 0;

volatile int cycle = 0;
volatile long long int cycleTotal = 0;
volatile int cps = 0;

void fpsUpdate(void)
{
   fps = frame;
   frame = 0;
}
END_OF_FUNCTION(fpsUpdate);

void cpsUpdate(void)
{
   cps = cycle;
   cycle = 0;
}
END_OF_FUNCTION(cpsUpdate);

void timerUpdate(void)
{
   milliseconds++;
   if (milliseconds >= 1000) {
      fpsUpdate();
      cpsUpdate();
      seconds++;
      milliseconds = 0;
   }
   if (seconds >= 60) {
      minutes++;
      seconds = 0;
   }
   if (minutes >= 60) {
      hours++;
      minutes = 0;
   }
}
END_OF_FUNCTION(timerUpdate);

int startup(void)
{
   int videoDepth = 24;
   int videoWidth = 400;
   int videoHeight = 300;
   int videoCard = GFX_AUTODETECT;

   // Allegro
   if (allegro_init() < 0) {
      return -1;
   }

   // Timer
   if (install_timer() < 0) {
      return -1;
   }
   LOCK_VARIABLE(speedCounter);
   LOCK_VARIABLE(milliseconds);
   LOCK_VARIABLE(seconds);
   LOCK_VARIABLE(minutes);
   LOCK_VARIABLE(hours);
   LOCK_VARIABLE(frame);
   LOCK_VARIABLE(frameTotal);
   LOCK_VARIABLE(fps);
   LOCK_VARIABLE(cycle);
   LOCK_VARIABLE(cycleTotal);
   LOCK_VARIABLE(cps);
   LOCK_FUNCTION(cpsUpdate);
   LOCK_FUNCTION(fpsUpdate);
   LOCK_FUNCTION(timerUpdate);
   LOCK_FUNCTION(incrementSpeedCounter);
   install_int_ex(incrementSpeedCounter, BPS_TO_TIMER(100));
   install_int(timerUpdate, 1);

   // Input
   if (install_keyboard() < 0) {
      return -1;
   }
   if (install_mouse() < 0) {
      return -1;
   }

   // Video
   video = new Video(GFX_SAFE, 320, 200, 8);
   gui_fg_color = makecol_depth(8, 0, 0, 0);
   gui_bg_color = makecol_depth(8, 255, 255, 255);
   my_gfx_mode_select_ex(&videoCard, &videoWidth, &videoHeight, &videoDepth);
   if (video->set(videoCard, videoWidth, videoHeight, videoDepth) < 0) {
      return -1;
   }

   // Sound
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) < 0) {
      return -1;
   }

   // Random
   srand(time(NULL));

   return 0;
}

int shutdown(void)
{
   // Sound
   remove_sound();

   // Video
   delete video;

   // Input
   remove_keyboard();
   remove_mouse();

   // Timer
   remove_int(incrementSpeedCounter);
   remove_int(timerUpdate);
   remove_timer();

   // Allegro
   allegro_exit();

   return 0;
}

int play(void)
{
   World world;
   Character *player;
   View view;
   Controller controller;
   Object *object = NULL;
   int textColour, backgroundColour;
   int i;
   int viewX, viewY;
   float unitX, unitY;
   float squareX, squareY;

   if (world.load("level.txt") < 0) {
      return -1;
   }
   world.setTileSet(&tile);
   world.setLightStrength(1.0);
   world.setLightColour(0, 0, 0);
   world.setSquareUnits(32.0, 32.0);

   textColour = makecol_depth(video->getDepth(), 255, 255, 255);
   backgroundColour = makecol_depth(video->getDepth(), 0, 0, 0);

   player = new Character;
   player->setX(64.0);
   player->setY(64.0);
   player->setController(&controller);

   world.getObjects()->push(player);

   for (i = 0; i < 8; i++) {
      Light *light = new Light;
      light->setX(((float)rand() / (float)RAND_MAX) * world.getW() * world.getSquareWUnits());
      light->setY(((float)rand() / (float)RAND_MAX) * world.getH() * world.getSquareHUnits());
      while (world.obstructPoint(light->getX(), light->getY())) {
         light->setX(((float)rand() / (float)RAND_MAX) * world.getW() * world.getSquareWUnits());
         light->setY(((float)rand() / (float)RAND_MAX) * world.getH() * world.getSquareHUnits());
      }
      light->setLightColourR(rand() % 256);
      light->setLightColourG(rand() % 256);
      light->setLightColourB(rand() % 256);
      light->setLightRadiusNone(rand() % 256);
      light->setLightRadiusFull(rand() % (int)(light->getLightRadiusNone() + 0.5));
      world.getObjects()->push(light);
   }

   for (i = 0; i < 16; i++) {
      Enemy *enemy = new Enemy;
      enemy->setX(((float)rand() / (float)RAND_MAX) * world.getW() * world.getSquareWUnits());
      enemy->setY(((float)rand() / (float)RAND_MAX) * world.getH() * world.getSquareHUnits());
//      while (world.obstructPoint(enemy->getX(), enemy->getY())) {
      while (world.obstructCircle(enemy->getX(), enemy->getY(), enemy->getCollisionRadius())) {
         enemy->setX(((float)rand() / (float)RAND_MAX) * world.getW() * world.getSquareWUnits());
         enemy->setY(((float)rand() / (float)RAND_MAX) * world.getH() * world.getSquareHUnits());
      }
      world.getObjects()->push(enemy);
   }

   view.setUnitPixels(1.0, 1.0);
   view.setDisplay(video->getBuffer(), 0, 0, video->getH(), video->getH());

   speedCounter = 0;
   while (!key[KEY_ESC] && !(mouse_b & 4)) {
      while (speedCounter > 0) {
         view.screenToView(mouse_x, mouse_y, &viewX, &viewY);
         view.viewToUnit(viewX, viewY, &unitX, &unitY);
         world.unitToSquare(unitX, unitY, &squareX, &squareY);
         if (squareX >= 0 && squareX < world.getW() && squareY >= 0 && squareY < world.getH()) {
            cursorX = (int)squareX;
            cursorY = (int)squareY;
            cursorTile = world.getSquare(squareX, squareY)->tile;
         }
         else {
            cursorX = -1;
            cursorY = -1;
            cursorTile = -1;
         }
         if (gameMode == GAME_MODE_EDIT) {
            if (mouse_b & 1) {
               if (cursorX >= 0 && cursorY >= 0) {
                  if (editMode == EDIT_MODE_TILE) {
                     world.getSquare(cursorX, cursorY)->tile = brushTile;
                  }
                  else if (editMode == EDIT_MODE_OBSTRUCTION) {
                     world.getSquare(cursorX, cursorY)->obstruct = true;
                  }
               }
            }
            else if (mouse_b & 2) {
               if (cursorX >= 0 && cursorY >= 0) {
                  if (editMode == EDIT_MODE_TILE) {
                     brushTile = cursorTile;
                  }
                  else if (editMode == EDIT_MODE_OBSTRUCTION) {
                     world.getSquare(cursorX, cursorY)->obstruct = false;
                  }
               }
            }
         }

         // Input
         char filename[80] = "";
         int i;
         int change;
         int x, y;
         int a, b;

         x = 0;
         y = 0;
         a = 0;
         b = 0;
      
         poll_keyboard();

         strafeFlag = false;
         runFlag = false;
      
         if (key[KEY_ALT] || key[KEY_ALT]) {
            strafeFlag = true;
         }
      
         change = 1;
         if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
            runFlag = true;
            change *= 2;
         }
      
         if (key[KEY_UP]) {
            if (gameMode == GAME_MODE_PLAY) {
               y += -1;
            }
            else {
               view.setFocusY(view.getFocusY() + -change);
            }
         }
         if (key[KEY_DOWN]) {
            if (gameMode == GAME_MODE_PLAY) {
               y += 1;
            }
            else {
               view.setFocusY(view.getFocusY() + change);
            }
         }
         if (key[KEY_LEFT]) {
            if (gameMode == GAME_MODE_PLAY) {
               x += -1;
            }
            else {
               view.setFocusX(view.getFocusX() + -change);
            }
         }
         if (key[KEY_RIGHT]) {
            if (gameMode == GAME_MODE_PLAY) {
               x += 1;
            }
            else {
               view.setFocusX(view.getFocusX() + change);
            }
         }
         if (key[KEY_LCONTROL] || key[KEY_RCONTROL]) {
            a++;
         }
         if (key[KEY_ALT]) {
            b++;
         }
         if (key[KEY_M]) {
            lightingFlag = !lightingFlag;
            clear_keybuf();
         }
         if (key[KEY_O]) {
            lightObstructionFlag = !lightObstructionFlag;
            clear_keybuf();
         }
         if (key[KEY_E] && gameMode == GAME_MODE_EDIT) {
            editMode++;
            if (editMode > 1) {
               editMode = 0;
            }
            clear_keybuf();
         }
         if (key[KEY_G]) {
            gameMode++;
            if (gameMode > 1) {
               gameMode = 0;
            }
            clear_keybuf();
         }
         if (key[KEY_C]) {
            for (i = 0; i < 10000; i++) {
               sprintf(filename, "scrn%04d.pcx", i);
               if (!exists(filename)) {
                  break;
               }
            }
            if (i < 10000) {
               save_bitmap(filename, video->getBuffer(), NULL);
            }
            clear_keybuf();
         }
         if (key[KEY_S] && gameMode == GAME_MODE_EDIT) {
            world.save("level.txt");
            clear_keybuf();
         }
         if (key[KEY_L] && gameMode == GAME_MODE_EDIT) {
            world.load("level.txt");
            clear_keybuf();
         }
         if (key[KEY_MINUS] && gameMode == GAME_MODE_EDIT) {
            brushTile--;
            if (brushTile < 0) brushTile = 0;
            clear_keybuf();
         }
         if (key[KEY_EQUALS] && gameMode == GAME_MODE_EDIT) {
            brushTile++;
            if (brushTile > tile.tileCount - 1) brushTile = tile.tileCount - 1;
            clear_keybuf();
         }
         controller.setX(x);
         controller.setY(y);
         controller.setA(a);
         controller.setB(b);
         world.update();
         if (gameMode == GAME_MODE_PLAY) {
            view.setFocus(player->getX() * view.getUnitWPixels(), player->getY() * view.getUnitHPixels());
         }

         if (cursorColourCount >= 25) {
            cursorColour = !cursorColour;
            cursorColourCount = 0;
         }
         else {
            cursorColourCount++;
         }

         cycle++;
         speedCounter--;
      }
      text_mode(-1);
      clear_to_color(video->getBuffer(), backgroundColour);
      drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
      world.draw(&view);
      textprintf(video->getBuffer(), font,   0,   0, textColour, "FPS: %3d, CPS: %3d", fps, cps);
      textprintf(video->getBuffer(), font, 0, video->getH() - 8, textColour, "Game Mode: %s", gameMode == GAME_MODE_PLAY ? "Play" : "Edit");
      if (gameMode == GAME_MODE_EDIT) {
         draw_sprite(video->getBuffer(), tile.tiles[brushTile].bitmap, video->getW() - tile.tiles[brushTile].bitmap->w, 0);
         textprintf(video->getBuffer(), font, 0, video->getH() - 16, textColour, "Edit Mode: %s", editMode == EDIT_MODE_TILE ? "Tile" : "Obstruction");
         show_mouse(video->getBuffer());
      }
      video->update();
      show_mouse(NULL);
      frame++;
   }

   ObjectList::iterator current = world.getObjects()->begin();
   ObjectList::iterator end = world.getObjects()->end();
   while (current != end) {
      object = (*current);
      current.remove();
      delete object;
   }

   view.setDestBitmap(NULL);

   world.unload();

   return 0;
}

int main(void)
{
   int exitFlag;

   if (startup() < 0) {
      exit(EXIT_FAILURE);
   }

   if (missile.load("weapon.txt") < 0) {
      exit(EXIT_FAILURE);
   }
   if (guy.load("guy.txt") < 0) {
      exit(EXIT_FAILURE);
   }
   if (enemy.load("enemy.txt") < 0) {
      exit(EXIT_FAILURE);
   }

   if (tile.load("tile.txt") < 0) {
      exit(EXIT_FAILURE);
   }

   hit = load_sample("hit.wav");
   weapon = load_sample("weapon.wav");
   die = load_sample("die.wav");
   explosion = load_sample("explosion.wav");

   exitFlag = play();

   guy.unload();
   enemy.unload();
   missile.unload();

   tile.unload();

   destroy_sample(hit);
   destroy_sample(weapon);
   destroy_sample(die);
   destroy_sample(explosion);

   if (shutdown() < 0) {
      exit(EXIT_FAILURE);
   }

   return exitFlag;
}
END_OF_MAIN();
