#ifndef _INPUT_H
#define _INPUT_H



#include <stdio.h>



#define SINGLE_CLICK 1
#define DOUBLE_CLICK 2
#define DRAG         3



enum inputType {
   inputState,
   inputPress,
   inputLMB,
   inputRMB,
   inputMouseLeftState,
   inputMouseLeftSingle,
   inputMouseLeftDouble,
   inputMouseRightState,
   inputMouseRightSingle,
   inputMouseRightDouble,
};



typedef struct INPUT_EVENT {
  void (*func)(int k);
  int type;
  int key;
} INPUT_EVENT;



class Input {
public:
   Input::Input(void) {
      for (int i = 0; i < 128; i++) {
         keyPress[i] = false;
         keyWait[i] = 0;
         keyState[i] = false;
      }
      mouseX = 0;
      mouseY = 0;
      leftClick = 0;
      rightClick = 0;
      mouseChangeX = 0;
      mouseChangeY = 0;
      keyWaitTime = 4;
      allwaysKeyWait = false;
      doubleClickWaitTime = 6;
      dragWaitTime = 4;
   }
   ~Input(void) {}
   void Input::process(void) {
      int i;

//      currentInput = this;

      for (i = 0; (*events)[i].func != NULL; i++) {
         switch ((*events)[i].type) {
         case inputState:
            if (keyState[(*events)[i].key] == true) {
               (*events)[i].func((*events)[i].key);
            }
            break;
         case inputPress:
            if (keyPress[(*events)[i].key] == true) {
               (*events)[i].func((*events)[i].key);
            }
            break;
         }
      }
   }
   void poll(void);

   int leftClick;
   int rightClick;
   int leftState;
   int rightState;
   int mouseX;
   int mouseY;
   int mouseChangeX;
   int mouseChangeY;
   int mouseMickeysX;
   int mouseMickeysY;

   bool keyPress[128];
   bool keyState[128];
   int keyWait[128];
   int keyShifts;

   void setEvents(INPUT_EVENT **_events) { events = _events; }
   INPUT_EVENT **getEvents(void) { return events; }
protected:
   int keyWaitTime;
   bool allwaysKeyWait;
   int doubleClickWaitTime;
   int dragWaitTime;
   INPUT_EVENT **events;
};



extern Input *currentInput;



#endif
