#include "input.h"



#include <allegro.h>



Input *currentInput = NULL;



INPUT_EVENT inputEvents[] = {
   { NULL,               0,          0 }
};



void Input::poll(void)
{
   int i;

   // Mouse
   // Get mouse clicks
   leftClick = 0;
   rightClick = 0;

   // Update mouse vars
   poll_mouse();

   static int leftLastState = FALSE;
   static int leftDragTime = 0;
   static int leftFirstClick = FALSE;
   static int leftSecondClick = FALSE;
   static int leftClickWait = FALSE;

   static int rightLastState = FALSE;
   static int rightDragTime = 0;

   // Mouse button states
   leftState = (mouse_b & 1) ? TRUE : FALSE;
   rightState = (mouse_b & 2) ? TRUE : FALSE;

   // Left mouse drag
   if ((leftState == TRUE) && (leftLastState == TRUE)) {
      if (leftDragTime < dragWaitTime) leftDragTime++;
   }
   else {
      leftDragTime = 0;
   }
   if (leftDragTime >= dragWaitTime) {
      leftClick = DRAG;
   }

   // Right mouse drag
   if ((rightState == TRUE) && (rightLastState == TRUE)) {
      if (rightDragTime < dragWaitTime) rightDragTime++;
   }
   else {
      rightDragTime = 0;
   }
   if (rightDragTime >= dragWaitTime) {
      rightClick = DRAG;
   }

   // Left mouse click
   if ((leftState == TRUE) && (leftLastState == FALSE)) {
      if (leftFirstClick == FALSE) {
         leftFirstClick = TRUE;
         leftClickWait = doubleClickWaitTime;
      }
      else if (leftSecondClick == FALSE) {
         leftSecondClick = TRUE;
         leftClickWait = 0;
      }
   }
   leftLastState = leftState;

   rightLastState = rightState;

   if (leftClickWait == 0) {
      if (leftSecondClick == TRUE) {
         leftClick = DOUBLE_CLICK;
      }
      else if (leftFirstClick == TRUE) {
         leftClick = SINGLE_CLICK;
      }
      leftFirstClick = FALSE;
      leftSecondClick = FALSE;
   }

   if (leftClickWait > 0) leftClickWait--;

   // Get mouse mickeys
   get_mouse_mickeys(&mouseMickeysX, &mouseMickeysY);

   // Get mouse position change
   int tX = mouseX + mouseMickeysX;
   int tY = mouseY + mouseMickeysY;
   if (tX < 0) tX = 0;
   else if (tX >= SCREEN_W) tX = SCREEN_W - 1;
   if (tY < 0) tY = 0;
   else if (tY >= SCREEN_H) tY = SCREEN_H - 1;
   mouseChangeX = tX - mouseX;
   mouseChangeY = tY - mouseY;

   // Update mouse position
   mouseX += mouseChangeX;
   mouseY += mouseChangeY;

//   mouse_x = mouseX;
//   mouse_y = mouseY;
   position_mouse(mouseX, mouseY);

   // Keyboard
   // Update keyboard vars
   poll_keyboard();

   keyShifts = key_shifts;
   // Store key states
   for (i = 0; i < 128; i++) key[i] ? keyState[i] = true : keyState[i] = false;
   // Validate key presses
   for (i = 0; i < 128; i++) {
      if ((keyState[i] == true) && (keyWait[i] == 0)) {
         keyPress[i] = true;
         keyWait[i] = keyWaitTime;
      }
      else {
         keyPress[i] = false;
         if ((keyState[i] == false) && !allwaysKeyWait) {
             keyWait[i] = 0;
         }
      }
   }
   // Reduce key wait
   for (i = 0; i < 128; i++) {
      if (keyWait[i] > 0) keyWait[i]--;
   }
}
