#include "gsprite.h"

/* draw_gouraud_col_sprite:
 * based on draw_gouraud_sprite from allegro
 * modified for coloured and overbright lighting
 *  Draws a lit or tinted sprite, interpolating the four corner colors
 *  over the surface of the image.
 */
void draw_gouraud_col_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, OVER_RGB c1, OVER_RGB c2, OVER_RGB c3, OVER_RGB c4)
{
   fixed mc1_r, mc1_g, mc1_b,
         mc2_r, mc2_g, mc2_b,
         mh_r, mh_g, mh_b;
   fixed lc_r, lc_g, lc_b,
         rc_r, rc_g, rc_b,
         hc_r, hc_g, hc_b;
   int x1 = x;
   int y1 = y;
   int x2 = x + sprite->w;
   int y2 = y + sprite->h;
   int i, j;
   int pixel;
   int pixel_r, pixel_g, pixel_b;
   unsigned long addr;

   ASSERT(bmp->vtable->color_depth == sprite->vtable->color_depth);
   ASSERT_TRANS_OK(bmp);

   bmp_select(bmp);

/*   int pixel_size;
   int mask_colour;
   int (*bmp_write)(int, int);
   int (*make_col)(int, int, int);
   int (*get_r)(int);
   int (*get_g)(int);
   int (*get_b)(int);

//   #define bmp_write8(addr, c)         (*((unsigned char  *)(addr)) = (c))
//   #define bmp_write15(addr, c)        (*((unsigned short *)(addr)) = (c))
//   #define bmp_write16(addr, c)        (*((unsigned short *)(addr)) = (c))
//   #define bmp_write32(addr, c)        (*((unsigned long  *)(addr)) = (c))

   mask_colour = bitmap_mask_color(bmp);
   switch (bitmap_color_depth(bmp)) {
   case 8:
      pixel_size = 1;
      bmp_write = bmp_write8;
      make_col = makecol8;
      get_r = getr8;
      get_g = getg8;
      get_b = getb8;
      break;
   case 15:
      break;
   case 16:
      break;
   case 24:
      break;
   case 32:
      break;
   }*/

   /* set up vertical gradients for left and right sides */
   mc1_r = itofix(c4.r - c1.r) / sprite->h;
   mc1_g = itofix(c4.g - c1.g) / sprite->h;
   mc1_b = itofix(c4.b - c1.b) / sprite->h;
   mc2_r = itofix(c3.r - c2.r) / sprite->h;
   mc2_g = itofix(c3.g - c2.g) / sprite->h;
   mc2_b = itofix(c3.b - c2.b) / sprite->h;
   lc_r = itofix(c1.r);
   lc_g = itofix(c1.g);
   lc_b = itofix(c1.b);
   rc_r = itofix(c2.r);
   rc_g = itofix(c2.g);
   rc_b = itofix(c2.b);

   /* check clipping */
   if (bmp->clip) {
      if (y1 < bmp->ct) {
         lc_r += mc1_r * (bmp->ct - y1);
         lc_g += mc1_g * (bmp->ct - y1);
         lc_b += mc1_b * (bmp->ct - y1);
         rc_r += mc2_r * (bmp->ct - y1);
         rc_g += mc2_g * (bmp->ct - y1);
         rc_b += mc2_b * (bmp->ct - y1);
         y1 = bmp->ct;
      }
      y2 = MIN(y2, bmp->cb);
      x1 = MAX(x1, bmp->cl);
      x2 = MIN(x2, bmp->cr);
   }

   #ifdef GFX_MODEX

      /* modex version */
      if (is_planar_bitmap(bmp)) {
   for (j = y1; j < y2; j++) {
      /* set up horizontal gradient for line */
      mh_r = (rc_r - lc_r) / sprite->w;
      mh_g = (rc_g - lc_g) / sprite->w;
      mh_b = (rc_b - lc_b) / sprite->w;
      hc_r = lc_r;
      hc_g = lc_g;
      hc_b = lc_b;

      /* more clip checking */
      if ((bmp->clip) && (x < bmp->cl)) {
         hc_r += mh_r * (bmp->cl - x);
         hc_g += mh_g * (bmp->cl - x);
         hc_b += mh_b * (bmp->cl - x);
      }

         addr = ((unsigned long)bmp->line[j] << 2) + x1;
         for (i = x1; i < x2; i++) {
            if (sprite->line[j - y][i - x]) {
               pixel = ((char *)sprite->line[j - y])[i - x];
               outportw(0x3C4, (0x100 << (i & 3)) | 2);
               pixel_r = MID(0, (getr8(pixel) * fixtoi(hc_r) / 256), 255);
               pixel_g = MID(0, (getg8(pixel) * fixtoi(hc_g) / 256), 255);
               pixel_b = MID(0, (getb8(pixel) * fixtoi(hc_b) / 256), 255);
               pixel = makecol8(pixel_r, pixel_g, pixel_b);
               bmp_write8(addr >> 2, pixel);
            }
            hc_r += mh_r;
            hc_g += mh_g;
            hc_b += mh_b;
            addr++;
         }
      }
      lc_r += mc1_r;
      lc_g += mc1_g;
      lc_b += mc1_b;
      rc_r += mc2_r;
      rc_g += mc2_g;
      rc_b += mc2_b;
   }
      else {

   #else

      {

   #endif

         /* draw routines for all linear modes */
         switch (bitmap_color_depth(bmp)) {
   
   #ifdef ALLEGRO_COLOR8
   
         case 8:
   for (j = y1; j < y2; j++) {
      /* set up horizontal gradient for line */
      mh_r = (rc_r - lc_r) / sprite->w;
      mh_g = (rc_g - lc_g) / sprite->w;
      mh_b = (rc_b - lc_b) / sprite->w;
      hc_r = lc_r;
      hc_g = lc_g;
      hc_b = lc_b;

      /* more clip checking */
      if ((bmp->clip) && (x < bmp->cl)) {
         hc_r += mh_r * (bmp->cl - x);
         hc_g += mh_g * (bmp->cl - x);
         hc_b += mh_b * (bmp->cl - x);
      }

            addr = bmp_write_line(bmp, j) + x1;
            for (i = x1; i < x2; i++) {
               if (sprite->line[j - y][i - x]) {
                  pixel = ((char *)sprite->line[j - y])[i - x];
                  pixel_r = MID(0, (getr8(pixel) * fixtoi(hc_r) / 256), 255);
                  pixel_g = MID(0, (getg8(pixel) * fixtoi(hc_g) / 256), 255);
                  pixel_b = MID(0, (getb8(pixel) * fixtoi(hc_b) / 256), 255);
                  pixel = makecol8(pixel_r, pixel_g, pixel_b);
                  bmp_write8(addr, pixel);
               }
               hc_r += mh_r;
               hc_g += mh_g;
               hc_b += mh_b;
               addr++;
            }
      lc_r += mc1_r;
      lc_g += mc1_g;
      lc_b += mc1_b;
      rc_r += mc2_r;
      rc_g += mc2_g;
      rc_b += mc2_b;
   }
            break;
   
   #endif
   
   #ifdef ALLEGRO_COLOR16
   
         case 15:
         case 16:
   for (j = y1; j < y2; j++) {
      /* set up horizontal gradient for line */
      mh_r = (rc_r - lc_r) / sprite->w;
      mh_g = (rc_g - lc_g) / sprite->w;
      mh_b = (rc_b - lc_b) / sprite->w;
      hc_r = lc_r;
      hc_g = lc_g;
      hc_b = lc_b;

      /* more clip checking */
      if ((bmp->clip) && (x < bmp->cl)) {
         hc_r += mh_r * (bmp->cl - x);
         hc_g += mh_g * (bmp->cl - x);
         hc_b += mh_b * (bmp->cl - x);
      }

            addr = bmp_write_line(bmp, j) + x1 * sizeof(short);
            for (i = x1; i < x2; i++) {
               pixel = ((unsigned short *)sprite->line[j - y])[i - x];
               if (pixel != bmp->vtable->mask_color) {
                  if (bitmap_color_depth(bmp) == 16) {
                     pixel_r = MID(0, (getr16(pixel) * fixtoi(hc_r) / 256), 255);
                     pixel_g = MID(0, (getg16(pixel) * fixtoi(hc_g) / 256), 255);
                     pixel_b = MID(0, (getb16(pixel) * fixtoi(hc_b) / 256), 255);
                     pixel = makecol16(pixel_r, pixel_g, pixel_b);
                  }
                  else {
                     pixel_r = MID(0, (getr15(pixel) * fixtoi(hc_r) / 256), 255);
                     pixel_g = MID(0, (getg15(pixel) * fixtoi(hc_g) / 256), 255);
                     pixel_b = MID(0, (getb15(pixel) * fixtoi(hc_b) / 256), 255);
                     pixel = makecol15(pixel_r, pixel_g, pixel_b);
                  }
                  bmp_write16(addr, pixel);
               }
               hc_r += mh_r;
               hc_g += mh_g;
               hc_b += mh_b;
               addr += sizeof(short);
            }
      lc_r += mc1_r;
      lc_g += mc1_g;
      lc_b += mc1_b;
      rc_r += mc2_r;
      rc_g += mc2_g;
      rc_b += mc2_b;
   }
            break;
   
   #endif

   #ifdef ALLEGRO_COLOR24
   
         case 24:
   for (j = y1; j < y2; j++) {
      /* set up horizontal gradient for line */
      mh_r = (rc_r - lc_r) / sprite->w;
      mh_g = (rc_g - lc_g) / sprite->w;
      mh_b = (rc_b - lc_b) / sprite->w;
      hc_r = lc_r;
      hc_g = lc_g;
      hc_b = lc_b;

      /* more clip checking */
      if ((bmp->clip) && (x < bmp->cl)) {
         hc_r += mh_r * (bmp->cl - x);
         hc_g += mh_g * (bmp->cl - x);
         hc_b += mh_b * (bmp->cl - x);
      }

            addr = bmp_write_line(bmp, j) + x1 * 3;
            for (i = x1; i < x2; i++) {
               bmp_select(sprite);
               pixel = bmp_read24((unsigned long)(sprite->line[j - y] + (i - x) * 3));
               bmp_select(bmp);
               if (pixel != MASK_COLOR_24) {
                  pixel_r = MID(0, (getr24(pixel) * fixtoi(hc_r) / 256), 255);
                  pixel_g = MID(0, (getg24(pixel) * fixtoi(hc_g) / 256), 255);
                  pixel_b = MID(0, (getb24(pixel) * fixtoi(hc_b) / 256), 255);
                  pixel = makecol24(pixel_r, pixel_g, pixel_b);
                  bmp_write24(addr, pixel);
               }
               hc_r += mh_r;
               hc_g += mh_g;
               hc_b += mh_b;
               addr += 3;
            }
      lc_r += mc1_r;
      lc_g += mc1_g;
      lc_b += mc1_b;
      rc_r += mc2_r;
      rc_g += mc2_g;
      rc_b += mc2_b;
   }
            break;
   
   #endif
   
   #ifdef ALLEGRO_COLOR32
   
         case 32:
   for (j = y1; j < y2; j++) {
      /* set up horizontal gradient for line */
      mh_r = (rc_r - lc_r) / sprite->w;
      mh_g = (rc_g - lc_g) / sprite->w;
      mh_b = (rc_b - lc_b) / sprite->w;
      hc_r = lc_r;
      hc_g = lc_g;
      hc_b = lc_b;

      /* more clip checking */
      if ((bmp->clip) && (x < bmp->cl)) {
         hc_r += mh_r * (bmp->cl - x);
         hc_g += mh_g * (bmp->cl - x);
         hc_b += mh_b * (bmp->cl - x);
      }

            addr = bmp_write_line(bmp, j) + x1 * sizeof(long);
            for (i = x1; i < x2; i++) {
               pixel = ((unsigned long *)sprite->line[j - y])[i - x];
               if (pixel != MASK_COLOR_32) {
                  pixel_r = MID(0, (getr32(pixel) * fixtoi(hc_r) / 256), 255);
                  pixel_g = MID(0, (getg32(pixel) * fixtoi(hc_g) / 256), 255);
                  pixel_b = MID(0, (getb32(pixel) * fixtoi(hc_b) / 256), 255);
                  pixel = makecol32(pixel_r, pixel_g, pixel_b);
                  bmp_write32(addr, pixel);
               }
               hc_r += mh_r;
               hc_g += mh_g;
               hc_b += mh_b;
               addr += sizeof(long);
            }
      lc_r += mc1_r;
      lc_g += mc1_g;
      lc_b += mc1_b;
      rc_r += mc2_r;
      rc_g += mc2_g;
      rc_b += mc2_b;
   }
            break;
   
   #endif
   
         }
      }
   

   bmp_unwrite_line(bmp);
}

void draw_lit_col_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, OVER_RGB c)
{
   int x1 = x;
   int y1 = y;
   int x2 = x + sprite->w;
   int y2 = y + sprite->h;
   int i, j;
   int pixel;
   int pixel_r, pixel_g, pixel_b;
//   int mask;
   int (*getr)(int);
   int (*getg)(int);
   int (*getb)(int);

   ASSERT(bmp->vtable->color_depth == sprite->vtable->color_depth);
   ASSERT_TRANS_OK(bmp);
   
   switch (bitmap_color_depth(bmp)) {

   #ifdef ALLEGRO_COLOR16
   case 15:
   case 16:
      if (bitmap_color_depth(bmp) == 15) {
         getr = getr15;
         getg = getg15;
         getb = getb15;
      }
      for (j = y1; j < y2; j++) {
         for (i = x1; i < x2; i++) {
            pixel = getpixel(sprite, i - x, j - y);
            if (pixel != MASK_COLOR_24) {
               pixel_r = MID(0, (getr24(pixel) * c.r / 256), 255);
               pixel_g = MID(0, (getg24(pixel) * c.g / 256), 255);
               pixel_b = MID(0, (getb24(pixel) * c.b / 256), 255);
               pixel = makecol24(pixel_r, pixel_g, pixel_b);
               putpixel(bmp, i, j, pixel);
            }
         }
      }
   #endif
   
   #ifdef ALLEGRO_COLOR24
   case 24:
      for (j = y1; j < y2; j++) {
         for (i = x1; i < x2; i++) {
            pixel = getpixel(sprite, i - x, j - y);
            if (pixel != MASK_COLOR_24) {
               pixel_r = MID(0, (getr24(pixel) * c.r / 256), 255);
               pixel_g = MID(0, (getg24(pixel) * c.g / 256), 255);
               pixel_b = MID(0, (getb24(pixel) * c.b / 256), 255);
               pixel = makecol24(pixel_r, pixel_g, pixel_b);
               putpixel(bmp, i, j, pixel);
            }
         }
      }
   #endif

   }
}
