////////////////////////////////////////////////////////////////////////////////
// DoubleList Template - By Carl Olsson 2000
// doublist.h DoubleList template class
////////////////////////////////////////////////////////////////////////////////

#ifndef __DOUBLIST_H
#define __DOUBLIST_H

#include <stdio.h>

////////////////////////////////////////////////////////////////////////////////
// Class: DoubleList
////////////////////////////////////////////////////////////////////////////////
template <class T>
class DoubleList{
public:
   class Node {
   public:
      Node(void) : data(NULL), next(NULL), prev(NULL) {}
      Node(T *_data) : data(_data), next(NULL), prev(NULL) {}
      ~Node(void) {}
      T *data;
      Node *next;
      Node *prev;
   };
   friend class iterator;
   class iterator {
   private:
      DoubleList &list;
      Node *node;
   public:
      iterator(DoubleList &_list) : list(_list), node(_list.head.next) {}
      iterator(DoubleList &_list, bool) : list(_list), node(&_list.tail) {}
      iterator(const iterator& rv) : list(rv.list), node(rv.node) {}
      iterator& operator=(const iterator& rv) {
         list = rv.list;
         node = rv.node;
         return *this;
      }
      iterator& operator++() {
         if (node != &list.tail) {
            node = node->next;
         }
         else {
            // Error
         }
         return *this;
      }
      iterator& operator++(int) { return operator++(); }
      iterator& operator--() {
         if (node->prev != &list.head) {
            node = node->prev;
         }
         else {
            // Error
         }
         return *this;
      }
      iterator& operator--(int) { return operator--(); }
      iterator& operator+=(int amount) {
         int position;
         Node *temp = node;
         while (node != list.tail && position < amount) {
            node = none->next;
            position++;
         }
         if (position == amount) {
         }
         else {
            node = temp;
            // Error
         }
         return *this;
      }
      iterator& operator-=(int amount) {
         int position;
         Node *temp = node;
         while (node != list.head && position < amount) {
            node = none->prev;
            position++;
         }
         if (position == amount) {
         }
         else {
            node = temp;
            // Error
         }
         return *this;
      }
      iterator operator+(int amount) const {
         iterator ret(*this);
         ret += amount;
         return ret;
      }
      iterator operator-(int amount) const {
         iterator ret(*this);
         ret -= amount;
         return ret;
      }
      T *current() const {
         return node->data;
      }
      T *operator*() const { return current(); }
      T *operator->() const {
         return current();
      }
      // Remove the current element:
      T *remove() {
         T *data = node->data;
         node = list.pop(node);
         return data;
      }
      // Comparison tests for end:
      bool operator==(const iterator& rv) const {
         return node == rv.node;
      }
      bool operator!=(const iterator& rv) const {
         return node != rv.node;
      }
   };
   iterator begin() { return iterator(*this); }
   iterator end() { return iterator(*this, true);}
   Node head;
   Node tail;
   DoubleList(void) {
      head.next = &tail;
      tail.prev = &head;
   }
   ~DoubleList(void) {
      Node *currentNode = NULL;
      T *data = NULL;

      currentNode = head.next;
      while (currentNode != &tail) {
         data = currentNode->data;
         currentNode = currentNode->next;
         pop(data);
      }
   }
   Node *push(Node *pushed) {
      if (head.next == &tail) {
         pushed->prev = &head;
         pushed->next = &tail;
         head.next = pushed;
         tail.prev = pushed;
      }
      else {
         pushed->prev = tail.prev;
         pushed->next = &tail;
         tail.prev->next = pushed;
         tail.prev = pushed;
      }
      return pushed;
   }
   Node *pop(Node *popped) {
      Node *current = head.next;
      current = popped->next;
      popped->prev->next = popped->next;
      popped->next->prev = popped->prev;
      delete popped;
      return current;
   }
   Node *push(T *pushed) {
      Node *current = new Node(pushed);
      return push(current);
   }
   Node *pop(T *popped) {
      Node *current = head.next;
      while (current != &tail && current->data != popped) {
         current = current->next;
      }
      if (current != NULL) {
         return pop(current);
      }
      return NULL;
   }
   int count(void) {
      Node *current = head.next;
      int count = 0;
      while (current != &tail) {
         count++;
         current = current->next;
      }
      return count;
   }
};

#endif
