#include <stdio.h>
#include "anim.h"



#define TEMP_FILE "temp.$$$"

#define LINE_BUFFER_SIZE (256 + 1)

#define COMMENT_CHAR '#'



void AnimFrame::draw(BITMAP *destination, int _x, int _y)
{
   draw_sprite(destination, bitmap, _x - x, _y - y);
}

int Anim::create(void)
{
   if ((frames = new AnimFrame[size]) == NULL) return -1;
   return 0;
}

int Anim::destroy(void)
{
   delete [] frames;
   return 0;
}

int AnimSet::create(void)
{
   if ((anims = new Anim[size]) == NULL) return -1;
   return 0;
}

int AnimSet::destroy(void)
{
   delete [] anims;
   return 0;
}

int AnimSet::load(char *fileName)
{
   FILE *file = NULL, *ppFile = NULL;

   // Open animation set file
   file = fopen(fileName, "rt");
   if (file == NULL) {
      return -1;
   }

   // Open file for preprocessed animation set
   ppFile = fopen(TEMP_FILE, "wt+");
   if (file == NULL) {
      return -1;
   }

   // Preprocess
   if (preprocess(file, ppFile) < 0) {
      return -1;
   }
   if (fclose(file) == EOF) {
      return -1;
   }

   // Process
   if (process(ppFile) < 0) {
      return -1;
   }

   // Clean up
   if (fclose(ppFile) == EOF) {
      return -1;
   }
   delete_file(TEMP_FILE);

   return 0;
}

int AnimSet::unload(void)
{
   int curAnim, curFrame;
   int setSize;
   int animSize;

   // Set
   setSize = size;

   // Animations
   for (curAnim = 0; curAnim < setSize; curAnim++) {
      animSize = anims[curAnim].size;

      // Frames
      for (curFrame = 0; curFrame < animSize; curFrame++) {
         destroy_bitmap(anims[curAnim].frames[curFrame].bitmap);
      }
      anims[curAnim].destroy();
   }
   destroy();

   return 0;
}

int AnimSet::preprocess(FILE *in, FILE *out)
{
   char buffer[LINE_BUFFER_SIZE];
   long inPos, outPos;
   int pos;

   // Store file positions
   inPos = ftell(in);
   outPos = ftell(out);

   // Set file positions to start of files
   rewind(in);
   rewind(out);

   // Copy preprocessed strings from in to out
   while (fgets(buffer, LINE_BUFFER_SIZE, in) != NULL) { // Read from in
      // Remove comments
      pos = 0;
      while (pos < LINE_BUFFER_SIZE - 1) {
         if (buffer[pos] == COMMENT_CHAR) {
            buffer[pos] = '\n';
            buffer[pos + 1] = '\0';
            break;
         }
         else {
            pos++;
         }
      }

      // Some non-comment data in line
      if (pos > 0) {
         // Write to out
         fputs(buffer, out);
      }
   }

   // Reset file positions
   fseek(in, inPos, SEEK_SET);
   fseek(out, outPos, SEEK_SET);

   return 0;
}

int AnimSet::process(FILE *file)
{
   char buffer[LINE_BUFFER_SIZE];
   long filePos;
   int setSize, animSize;
   int curAnim, curFrame;
   int frameBX, frameBY, frameW, frameH, frameX, frameY, frameWait;
   char setBitmap[80 + 1];
   BITMAP *bitmap = NULL;

   // Store file position
   filePos = ftell(file);

   // Set file position to start of file
   rewind(file);

   // Set
   // Bitmap
   if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
      return -1;
   }
   if (sscanf(buffer, "%s", setBitmap) < 1) {
      return -1;
   }
   bitmap = load_bitmap(setBitmap, NULL);

   // Size
   if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
      return -1;
   }
   if (sscanf(buffer, "%d", &setSize) < 1) {
      return -1;
   }
   size = setSize;
   if (create() < 0) {
      return -1;
   }

   // Animations
   for (curAnim = 0; curAnim < setSize; curAnim++) {
      // Size
      if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
         return -1;
      }
      if (sscanf(buffer, "%d", &animSize) < 1) {
         return -1;
      }
      anims[curAnim].size = animSize;
      if (anims[curAnim].create() < 0) {
         return -1;
      }

      // Frames
      for (curFrame = 0; curFrame < animSize; curFrame++) {
         if (fgets(buffer, LINE_BUFFER_SIZE, file) == NULL) {
            return -1;
         }
         if (sscanf(buffer, "%d, %d, %d, %d, %d, %d, %d", &frameBX, &frameBY, &frameW, &frameH, &frameX, &frameY, &frameWait) < 7) {
            return -1;
         }
         anims[curAnim].frames[curFrame].w = frameW;
         anims[curAnim].frames[curFrame].h = frameH;
         anims[curAnim].frames[curFrame].x = frameX;
         anims[curAnim].frames[curFrame].y = frameY;
         anims[curAnim].frames[curFrame].wait = frameWait;
         anims[curAnim].frames[curFrame].bitmap = create_bitmap(frameW, frameH);
         blit(bitmap, anims[curAnim].frames[curFrame].bitmap, frameBX, frameBY, 0, 0, frameW, frameH);
      }
   }

   destroy_bitmap(bitmap);

   // Reset file position
   fseek(file, filePos, SEEK_SET);

   return 0;
}
