#include "world.h"



#include <stdio.h>
#include <math.h>
#include <iostream>
#include <fstream>



#include "math.h"
#include "main.h"
#include "object.h"
#include "gsprite.h"
#include "view.h"
#include "collide.h"



World *currentWorld = NULL;



World::World(void)
{
   w = 0;
   h = 0;
   squares = NULL;
   lighting = NULL;
   objects = NULL;
}

World::~World(void)
{
   destroy();
   w = 0;
   h = 0;
   squares = NULL;
   lighting = NULL;
   objects = NULL;
}

void World::update(void)
{
   Object *object = NULL;
   Object *object1 = NULL;
   Object *object2 = NULL;

   ///////////////////////////////
   for (int i = 0; i < getW(); i++) {
      for (int j = 0; j < getH(); j++) {
         getSquare(i, j)->collideTest = 0;
      }
   }
   //////////////////////////////

   currentWorld = this;
   ObjectList::iterator current = getObjects()->begin();
   ObjectList::iterator end = getObjects()->end();
   while (current != end) {
      object = (*current);
      if (object->getExist() == false) {
         current.remove();
         delete object;
      }
      else {
         object->update();
         current++;
      }
   }
   ObjectList::iterator begin = getObjects()->begin();
   end = getObjects()->end();
   while (begin != end) {
      object1 = (*begin);
      current = begin;
      current++;
      while (current != end) {
         object2 = (*current);
         // Test collision
         if (object1->testObjectCollision(object2) == true) {
            object1->collide(object2);
         }
         if (object2->testObjectCollision(object1) == true) {
            object2->collide(object1);
         }
         current++;
      }
      begin++;
   }
}

void World::draw(View *view)
{
   Tile *tile = NULL;
   Object *object = NULL;
   int x, y;
   float lightR, lightG, lightB;
   float distance;
   int i, j;
   int viewX, viewY;
   float unitX, unitY;
   float squareX, squareY;
   int startX, startY;
   int endX, endY;
//   float square2X, square2Y;
//   int squareW, squareH;

   // View start
   view->viewToUnit(0, 0, &unitX, &unitY);
   unitToSquare(unitX, unitY, &squareX, &squareY);
   startX = (int)squareX;
   startY = (int)squareY;
   if (startX < 0) {
      startX = 0;
   }
   if (startY < 0) {
      startY = 0;
   }
   if (startX > getW() - 1) {
      startX = getW() - 1;
   }
   if (startY > getH() - 1) {
      startY = getH() - 1;
   }

   // View end
   view->viewToUnit(view->getW(), view->getH(), &unitX, &unitY);
   unitToSquare(unitX, unitY, &squareX, &squareY);
   endX = (int)squareX;
   endY = (int)squareY;
   if (endX < 0) {
      endX = 0;
   }
   if (endY < 0) {
      endY = 0;
   }
   if (endX > getW() - 1) {
      endX = getW() - 1;
   }
   if (endY > getH() - 1) {
      endY = getH() - 1;
   }

   if (lightingFlag) {
      for (x = startX; x <= endX + 1; x++) {
         for (y = startY; y <= endY + 1; y++) {
            lightR = lightG = lightB = 0;
            ObjectList::iterator current = objects->begin();
            ObjectList::iterator end = objects->end();
            while (current != end) {
               object = (*current);
               if (object->getLightStrength() > 0.0) {
                  squareToUnit(x, y, &unitX, &unitY);
                  distance = getDistance(unitX, unitY, object->getX(), object->getY());
                  if (distance < object->getLightRadiusNone()) {
                     if (obstructLine(unitX, unitY, object->getX(), object->getY()) == false || lightObstructionFlag == false) {
                        lightR += getLightLevel((int)object->getLightRadiusFull(), (int)(object->getLightStrength() * object->getLightColourR()), (int)object->getLightRadiusNone(), 0, distance);
                        lightG += getLightLevel((int)object->getLightRadiusFull(), (int)(object->getLightStrength() * object->getLightColourG()), (int)object->getLightRadiusNone(), 0, distance);
                        lightB += getLightLevel((int)object->getLightRadiusFull(), (int)(object->getLightStrength() * object->getLightColourB()), (int)object->getLightRadiusNone(), 0, distance);
                     }
                  }
               }
               current++;
            }
            lightR += lightColour.r * lightStrength;
            lightG += lightColour.g * lightStrength;
            lightB += lightColour.b * lightStrength;
            getLighting(x, y)->r = MID(0, (int)lightR, 65535);
            getLighting(x, y)->g = MID(0, (int)lightG, 65535);
            getLighting(x, y)->b = MID(0, (int)lightB, 65535);
         }
      }
   }

   drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
   for (x = startX; x <= endX; x++) {
      for (y = startY; y <= endY; y++) {
         squareToUnit(x, y, &unitX, &unitY);
         view->unitToView(unitX, unitY, &viewX, &viewY);
         tile = &(tileSet->tiles[getSquare(x, y)->tile]);

         if (lightingFlag == true) {
            if (getLighting(x + 0, y + 0)->r == 0 &&
                getLighting(x + 0, y + 0)->g == 0 &&
                getLighting(x + 0, y + 0)->b == 0 &&
                getLighting(x + 1, y + 0)->r == 0 &&
                getLighting(x + 1, y + 0)->g == 0 &&
                getLighting(x + 1, y + 0)->b == 0 &&
                getLighting(x + 1, y + 1)->r == 0 &&
                getLighting(x + 1, y + 1)->g == 0 &&
                getLighting(x + 1, y + 1)->b == 0 &&
                getLighting(x + 0, y + 1)->r == 0 &&
                getLighting(x + 0, y + 1)->g == 0 &&
                getLighting(x + 0, y + 1)->b == 0) {
            }
            else {
               draw_gouraud_col_sprite(view->getDrawBitmap(), tile->bitmap, viewX - tile->x, viewY - tile->y,
                  *getLighting(x + 0, y + 0),
                  *getLighting(x + 1, y + 0),
                  *getLighting(x + 1, y + 1),
                  *getLighting(x + 0, y + 1));
            }
         }
         else {
            draw_sprite(view->getDrawBitmap(), tile->bitmap, viewX - tile->x, viewY - tile->y);
//            squareToUnit(x + 1, y + 1, &square2X, &square2Y);
//            view->unitToView(square2X, square2Y, &squareW, &squareH);
//            stretch_sprite(view->getDrawBitmap(), tile->bitmap, viewX - tile->x, viewY - tile->y, squareW - viewX, squareH - viewY);
         }
         ////////////////////////////////////////////
//         if (getSquare(x, y)->collideTest > 0) {
//         textprintf(view->getDrawBitmap(), font, viewX - tile->x, viewY - tile->y, cursorColour ? makecol_depth(video->getDepth(), 255, 255, 255) : makecol_depth(video->getDepth(), 0, 0, 0), "%d", getSquare(x, y)->collideTest);
//         rect(view->getDrawBitmap(), viewX - tile->x, viewY - tile->y, viewX - tile->x + tile->w - 1, viewY - tile->y + tile->h - 1, cursorColour ? makecol_depth(video->getDepth(), 255, 255, 255) : makecol_depth(video->getDepth(), 0, 0, 0));
//         }
         ////////////////////////////////////////////

         if (gameMode == GAME_MODE_EDIT) {
            if (getSquare(x, y)->obstruct == true) {
               for (i = viewX - tile->x; i < viewX - tile->x + tile->w; i++) {
                  for (j = viewY - tile->y; j < viewY - tile->y + tile->h; j++) {
                     if ((i + j) % 12 == 0) {
                        putpixel(view->getDrawBitmap(), i, j, makecol_depth(video->getDepth(), 255, 255, 255));
                     }
                     else if ((i + j) % 12 == 1) {
                        putpixel(view->getDrawBitmap(), i, j, makecol_depth(video->getDepth(), 0, 0, 0));
                     }
                  }
               }
            }
            if (x == cursorX && y == cursorY) {
               rect(view->getDrawBitmap(), viewX - tile->x, viewY - tile->y, viewX - tile->x + tile->w - 1, viewY - tile->y + tile->h - 1, cursorColour ? makecol_depth(video->getDepth(), 255, 255, 255) : makecol_depth(video->getDepth(), 0, 0, 0));
               rect(view->getDrawBitmap(), viewX - tile->x + 1, viewY - tile->y + 1, viewX - tile->x + tile->w - 2, viewY - tile->y + tile->h - 2, cursorColour ? makecol_depth(video->getDepth(), 0, 0, 0) : makecol_depth(video->getDepth(), 255, 255, 255));
            }
         }
      }
   }
/*
      for (x = startX; x <= endX + 1; x++) {
         for (y = startY; y <= endY + 1; y++) {
            ObjectList::iterator current = objects->begin();
            ObjectList::iterator end = objects->end();
            while (current != end) {
               object = (*current);
               if (object->getLightStrength() > 0.0) {
                  squareToUnit(x, y, &unitX, &unitY);
                  distance = getDistance(unitX, unitY, object->getX(), object->getY());
                  if (distance < object->getLightRadiusNone()) {
                     int objectX, objectY;
                     view->unitToView(unitX, unitY, &viewX, &viewY);
                     view->unitToView(object->getX(), object->getY(), &objectX, &objectY);
                     if (obstructLine(unitX, unitY, object->getX(), object->getY()) == false) {
                        line(view->getDrawBitmap(), viewX, viewY, objectX, objectY, 0xffffff);
                     }
                     else {
                        line(view->getDrawBitmap(), viewX, viewY, objectX, objectY, 0xff0000);
                     }
                  }
               }
               current++;
            }
         }
      }
*/

   ObjectList::iterator current = getObjects()->begin();
   ObjectList::iterator end = getObjects()->end();
   while (current != end) {
      object = (*current);
      object->draw(view);
//      int objectX, objectY;
//      view->unitToView(object->getX() + object->getCollisionRadius(), object->getY() + object->getCollisionRadius(), &viewX, &viewY);
//      view->unitToView(object->getX(), object->getY(), &objectX, &objectY);
//      ellipse(view->getDrawBitmap(), objectX, objectY, viewX - objectX, viewY - objectY, 0xff0000);
      current++;
   }
}

int World::load(char *fileName)
{
   FILE *file;
   int worldW, worldH;
   Square worldSquare;
   int x, y;
   int tile;
   int obstruct;

   unload();

   if ((file = fopen(fileName, "rt")) == NULL) {
      return -1;
   }

   if (fscanf(file, "%d, %d\n", &worldW, &worldH) < 0) {
      return -1;
   }
   destroy();
   w = worldW;
   h = worldH;
   create();

   for (y = 0; y < worldH; y++) {
      for (x = 0; x < worldW; x++) {
         fscanf(file, "%d %d,", &tile, &obstruct);
         if (obstruct > 0) {
            worldSquare.obstruct = true;
         }
         else {
            worldSquare.obstruct = false;
         }
         worldSquare.tile = tile;
         squares[x][y] = worldSquare;
      }
      fscanf(file, "\n");
   }

   fclose(file);

   return 0;

/*   ifstream file;
   int worldW, worldH;
   Square worldSquare;
   int x, y;
   int tile;
   int obstruct;

   file.open(fileName);

   if (file.is_open()) {
      file.scan("%d, %d\n", &worldW, &worldH);
//      file >> worldW >> ", " >> worldH;
      destroy();
      w = worldW;
      h = worldH;
      create();
      for (y = 0; y < worldH; y++) {
         for (x = 0; x < worldW; x++) {
            file.scan("%d %d,", &tile, &obstruct);
//            file >> tile >> obstruct >> ",";
            if (obstruct > 0) {
               worldSquare.obstruct = true;
            }
            else {
               worldSquare.obstruct = false;
            }
            worldSquare.tile = tile;
            squares[x][y] = worldSquare;
         }
         file.scan("\n");
      }
      file.close();

      return 0;
   }

   return -1;*/
}

int World::save(char *fileName)
{
   FILE *file;
   int x, y;
   int tile;
   int obstruct;

   if ((file = fopen(fileName, "wt")) == NULL) {
      return -1;
   }

   if (fprintf(file, "%d, %d\n", w, h) < 0) {
      return -1;
   }

   for (y = 0; y < h; y++) {
      for (x = 0; x < w; x++) {
         if (squares[x][y].obstruct == true) {
            obstruct = 1;
         }
         else {
            obstruct = 0;
         }
         tile = squares[x][y].tile;
         fprintf(file, "%d %d,", tile, obstruct);
      }
      fprintf(file, "\n");
   }

   fclose(file);

   return 0;

/*   ofstream file;
   int x, y;
   int tile;
   int obstruct;

   file.open(fileName);

   if (file.is_open()) {
      file.form("%d, %d\n", w, h);
//      file << w << ", " << h << endl;
      for (y = 0; y < h; y++) {
         for (x = 0; x < w; x++) {
            if (squares[x][y].obstruct == true) {
               obstruct = 1;
            }
            else {
               obstruct = 0;
            }
            tile = squares[x][y].tile;
            file.form("%d, %d\n", tile, obstruct);
//            file << tile << obstruct << ", ";
         }
         file.form("\n");
//         file << endl;
      }
      file.close();

      return 0;
   }

   return -1;*/
}

int World::unload(void)
{
   destroy();
   w = 0;
   h = 0;
   squares = NULL;
   lighting = NULL;

   return 0;
}


int World::create(void)
{
   int x, y;

   // Create squares
   squares = new Square *[w];
   if (squares == NULL) {
      return -1;
   }
   for (x = 0; x < w; x++) {
      squares[x] = NULL;
      squares[x] = new Square[h];
      if (squares[x] == NULL) {
         return -1;
      }
   }
   for (x = 0; x < w; x++) {
      for (y = 0; y < h; y++) {
         squares[x][y].tile = 0;
         squares[x][y].obstruct = false;
      }
   }

   // Create lighting
   lighting = new OVER_RGB *[w + 1];
   if (lighting == NULL) {
      return -1;
   }
   for (x = 0; x < w + 1; x++) {
      lighting[x] = NULL;
      lighting[x] = new OVER_RGB[h + 1];
      if (lighting[x] == NULL) {
         return -1;
      }
   }
   for (x = 0; x < w + 1; x++) {
      for (y = 0; y < h + 1; y++) {
         lighting[x][y].r = 0;
         lighting[x][y].g = 0;
         lighting[x][y].b = 0;
      }
   }

   // Create object list
   objects = new ObjectList;
   if (objects == NULL) {
      return -1;
   }

   return 0;
}

int World::destroy(void)
{
   int i;

   // Destroy squares
   if (squares != NULL) {
      for (i = 0; i < w; i++) {
         if (squares[i] != NULL) {
            delete [] squares[i];
         }
      }
      delete [] squares;
      squares = NULL;
   }

   // Destroy lighting
   if (lighting != NULL) {
      for (i = 0; i < w + 1; i++) {
         if (lighting[i] != NULL) {
            delete [] lighting[i];
         }
      }
      delete [] lighting;
      lighting = NULL;
   }

   // Destroy object list
   if (objects != NULL) {
      delete objects;
      objects = NULL;
   }

   return 0;
}

bool World::obstructPoint(float x, float y)
{
   float squareX, squareY;

   unitToSquare(x, y, &squareX, &squareY);
   if (squareX != (int)squareX || squareY != (int)squareY) {
      if (getSquare((int)(squareX), (int)(squareY))->obstruct == true) {
         return true;
      }
   }

   return false;
}
/*
bool World::obstructLine(float x1, float y1, float x2, float y2)
{
// Problemetrics
// -------------
// Flickering only occurs to the negative x positive y and positive x
// negative y of lighting object.
// Problem might have come in when I removed the half square offset (an
// object at 0, 0 would be standing in the middle of square 0, 0).
// No working version doesn't have that.
// Ahrgh! It works as an inline, but not otherwise. Why the fuck is that?!

   float gradient;
   float rangeX, rangeY;
   int step;
   float position;
   float start, end;
   bool stepX;
   float squareX, squareY;
   float intercept;

   rangeX = x2 - x1;
   rangeY = y2 - y1;

   if (fabs(rangeX) > fabs(rangeY)) {
      stepX = true;
      step = rangeX > 0 ? 1 : -1;
      gradient = rangeY / rangeX;
      start = x1;
      end = x2;
      intercept = y1 - (gradient * x1);
   }
   else {
      stepX = false;
      step = rangeY > 0 ? 1 : -1;
      gradient = rangeX / rangeY;
      start = y1;
      end = y2;
      intercept = x1 - (gradient * y1);
   }

   for (position = start; (step * position) < (step * end); position += step) {
      if (stepX == true) {
         unitToSquare(position, (position * gradient) + intercept, &squareX, &squareY);
      }
      else {
         unitToSquare((position * gradient) + intercept, position, &squareX, &squareY);
      }
//      squareX += 0.5;
//      squareY += 0.5;
      if (squareX != (int)squareX || squareY != (int)squareY) {
//         if (getSquare((int)(squareX + 0.5), (int)(squareY + 0.5))->obstruct == true) {
         if (getSquare((int)(squareX), (int)(squareY))->obstruct == true) {
            return true;
         }
      }
   }

   return false;
}
*/

bool circleSquareObstruct(float x, float y, float r, float x1, float y1, float x2, float y2)
{
   return collide_circle_to_rect(x, y, r, x1, y1, x2, y2);
}

bool World::obstructCircle(float x, float y, float r)
{
   float squareX, squareY;
   float squareR;
   float tempX, tempY;
   int i, j;

   unitToSquare(x, y, &squareX, &squareY);
   unitToSquare(x + r, y, &tempX, &tempY);
   squareR = getDistance(squareX, squareY, tempX, tempY);

   for (i = (int)(squareX - squareR); i <= (int)(squareX + squareR); i++) {
      for (j = (int)(squareY - squareR); j <= (int)(squareY + squareR); j++) {
//////////////////////////
         getSquare(i, j)->collideTest++;
///////////////////////////////
         if (getSquare(i, j)->obstruct == true) {
            if (circleSquareObstruct(squareX, squareY, squareR, i, j, i + 1, j + 1)) {
               return true;
            }
         }
      }
   }

   return false;
}

/*
bool World::obstructCircle(float x, float y, float r)
{
   //////////////////
   // Not finished //
   //////////////////

   float squareX, squareY;
   float squareR;
   float tempX, tempY;
   float i, j;

   unitToSquare(x, y, &squareX, &squareY);
   unitToSquare(x + r, y, &tempX, &tempY);
   squareR = getDistance(squareX, squareY, tempX, tempY);
//   if (getSquare((int)(squareX), (int)(squareY))->obstruct == true) {
//      return true;
//   }
//   else {
{
      for (i = squareX - squareR; i < squareX + squareR; i++) {
         for (j = squareY - squareR; j < squareY + squareR; j++) {
//            if (squareX != (int)squareX || squareY != (int)squareY) {
               if (getSquare((int)(i), (int)(j))->obstruct == true) {
                  if (getDistance(squareX, squareY, i, j) < squareR) {
                     return true;
                  }
               }
//            }
         }
      }
   }

   return false;
}
*/
