#ifndef _VIEW_H
#define _VIEW_H

#include <allegro.h>



class View {
public:
   View(void);
   ~View(void);
   void setX(int _x) { x = _x; }
   int getX(void) { return x; }
   void setY(int _y) { y = _y; }
   int getY(void) { return y; }
   void setW(int _w) { w = _w; }
   int getW(void) { return w; }
   void setH(int _h) { h = _h; }
   int getH(void) { return h; }
   void setFocusX(int _focusX) { focusX = _focusX; }
   int getFocusX(void) { return focusX; }
   void setFocusY(int _focusY) { focusY = _focusY; }
   int getFocusY(void) { return focusY; }
   void setFocus(int _focusX, int _focusY) { focusX = _focusX; focusY = _focusY; }
   void setDestBitmap(BITMAP *_destBitmap)
   {
      destBitmap = _destBitmap;
      destroy_bitmap(drawBitmap);
      drawBitmap = NULL;
      if (destBitmap != NULL) {
         drawBitmap = create_sub_bitmap(destBitmap, x, y, w, h);
      }
   }
   BITMAP *getDestBitmap(void) { return destBitmap; }
   BITMAP *getDrawBitmap(void) { return drawBitmap; }
   void setDisplay(BITMAP *_destBitmap, int _x, int _y, int _w, int _h)
   {
      setX(_x);
      setY(_y);
      setW(_w);
      setH(_h);
      setDestBitmap(_destBitmap);
   }
   void viewToUnit(int vX, int vY, float *uX, float *uY);
   void unitToView(float uX, float uY, int *vX, int *vY);
   void setUnitWPixels(float _unitWPixels) { unitWPixels = _unitWPixels; }
   float getUnitWPixels(void) { return unitWPixels; }
   void setUnitHPixels(float _unitHPixels) { unitHPixels = _unitHPixels; }
   float getUnitHPixels(void) { return unitHPixels; }
   void setUnitPixels(float _unitWPixels, float _unitHPixels) {
      setUnitWPixels(_unitWPixels);
      setUnitHPixels(_unitHPixels);
   }
   void viewToScreen(int vX, int vY, int *uX, int *uY);
   void screenToView(int sX, int sY, int *vX, int *vY);
private:
   BITMAP *destBitmap;
   BITMAP *drawBitmap;
   int x, y;
   int w, h;
   int focusX, focusY;
   float unitWPixels, unitHPixels;
};



#endif
