#ifndef _TILE_H
#define _TILE_H

#include <allegro.h>
#include <string.h>
#include <stdio.h>

typedef struct ANIM_FRAME {
   unsigned short time; // time displayed in ms
   unsigned short tile; // tileset index to display
} ANIM_FRAME;

typedef struct ANIM {
   char *name; // name of animation
   ANIM_FRAME *frames; // array of frames
   int frameCount;
} ANIM;

class Tile {
public:
   Tile(void) {}
   ~Tile(void) {}
   BITMAP *bitmap;
   int x, y;
   int w, h;
   void draw(BITMAP *destination, int _x, int _y);
private:
};

class TileSet {
public:
   TileSet(void) {}
   ~TileSet(void) {}
   Tile *tiles;
   int create(void);
   int destroy(void);
   int tileCount;
   int load(char *file_name);
   int unload(void);
   int preprocess(FILE *in, FILE *out);
   int process(FILE *file);
   ANIM *anims;
   int animCount;
private:
};

#endif
