#include "collide.h"

#include <math.h>

#ifndef M_PI
   #define M_PI 3.14159265358979323846
#endif

int collide_point_to_point(float p1x, float p1y, float p2x, float p2y)
{
   return (p1x == p2x && p1y == p2y);
}

int collide_point_to_circle(float px, float py, float cx, float cy, float cr)
{
   return (sqrt(pow(cx - px, 2) + pow(cy - py, 2)) <= cr);
}

int collide_point_to_rect(float px, float py, float rx1, float ry1, float rx2, float ry2)
{
   return (px >= rx1 && px <= rx2 && py >= ry1 && py <= ry2);
}

int collide_circle_to_circle(float c1x, float c1y, float c1r, float c2x, float c2y, float c2r)
{
   return (sqrt(pow(c1x - c2x, 2) + pow(c1y - c2y, 2)) <= c1r + c2r);
}

int collide_circle_to_rect(float cx, float cy, float cr, float rx1, float ry1, float rx2, float ry2)
{
/*   float rx, ry;

   if (cx < rx1) {
      rx = rx1;
   }
   else if (cx > rx2) {
      rx = rx2;
   }
   else {
      rx = cx;
   }
//   rx = cx < rx1 ? rx1 : cx > rx2 ? rx2 : 0.0;

   if (cy < ry1) {
      ry = ry1;
   }
   else if (cy > ry2) {
      ry = ry2;
   }
   else {
      ry = cy;
   }
//   ry = cy < ry1 ? ry1 : cy > ry2 ? ry2 : 0.0;

   return sqrt(pow(cx - rx, 2) + pow(cy - ry, 2)) <= cr;
*/
   return sqrt(pow(cx - (cx < rx1 ? rx1 : cx > rx2 ? rx2 : cx), 2) + pow(cy - (cy < ry1 ? ry1 : cy > ry2 ? ry2 : cy), 2)) <= cr;
}

int collide_rect_to_rect(float r1x1, float r1y1, float r1x2, float r1y2, float r2x1, float r2y1, float r2x2, float r2y2)
{
   return !((r1x1 < r2x1 && r1x2 < r2x1) ||
            (r1x1 > r2x2 && r1x2 > r2x2) ||
            (r1y1 < r2y1 && r1y2 < r2y1) ||
            (r1y1 > r2y2 && r1y2 > r2y2));
//   return (r1x1 >= r2x1 || r1x2 >= r2x1) &&
//          (r1x1 <= r2x2 || r1x2 <= r2x2) &&
//          (r1y1 >= r2y1 || r1y2 >= r2y1) &&
//          (r1y1 <= r2y2 || r1y2 <= r2y2);
}

#ifndef M_PI
   #define M_PI 3.14159265358979323846
#endif

#define DEG(n)    ((n) * 180.0 / M_PI)
#define RAD(n)    ((n) * M_PI / 180.0)
#define B_DEG(n)  ((n) / (360.0 / 256.0))

#define SIGN(n) ((n) < 0 ? -1 : ((n) > 0 ? 1 : 0))

/*
 * collide_circle_to_circle_ex
 * ---------------------------
 * Input
 * -----
 * x1, y1, r1     - circle 1 position and radius
 * x2, y2, r2     - circle 2 position
 * vx, vy         - relative velocity
 * time           - relative time
 *
 * Output
 * ------
 * cx, cy         - collision position
 * collision_time - collision time
 * rx, ry         - reflection vector
 * nx, ny         - reflection normal
 * Return: collsion occured
 */
int collide_circle_to_circle_ex(float x1, float y1, float r1, float x2, float y2, float r2, float vx, float vy, float time, float *x1_contact, float *y1_contact, float *cx, float *cy, float *collision_time, float *rx, float *ry, float *nx, float *ny)
{
   int in_path; /* Is circle within collision path? */
   int in_time; /* Is circle within collision time frame? */
   int is_collision; /* Has collision occured? */

   float velocity_angle; /* Angle of velocity vector */
   float range_distance; /* Distance to collision */
   float velocity_length; /* Length of velocity vector */
   float contact_angle;
   float normal_angle;
   float reflection_angle;

   float start_distance; /* Distance between circles along velocity vector at start */
   float start_displacement; /* Distance between circles at start */
   float start_angle;
   float offset_distance;
   float offset_angle;

   float collision_distance; /* Distance between circles along velocity vector at collision */
   float collision_displacement; /* Distance between circles at collision */
   float collision_angle;

   is_collision = 0;
   in_path = 0;
   in_time = 0;

   velocity_angle = atan2(vy, vx);

   /* Start state */
   start_displacement = sqrt(pow(x2 - x1, 2) + pow(y2 - y1, 2));
   start_angle = atan2(y2 - y1, x2 - x1);
   offset_angle = M_PI / 2 - velocity_angle + start_angle;
   start_distance = start_displacement * sin(offset_angle);
   offset_distance = start_displacement * cos(offset_angle);

   /* No collision */
   if (fabs(offset_distance) <= r1 + r2) {
      in_path = 1;
   }

   /* Collision state */
   collision_displacement = r1 + r2;
   collision_angle = acos(offset_distance / collision_displacement);
   collision_distance = collision_displacement * sin(collision_angle);

   /* Time */
   range_distance = start_distance - collision_distance;
   velocity_length = sqrt(pow(vx, 2) + pow(vy, 2));
   *collision_time = range_distance / velocity_length;

   /* No collision */
   if (*collision_time >= 0 && *collision_time <= time) {
//   if (*collision_time * SIGN(time) >= 0 && *collision_time * SIGN(time) <= time) {
      in_time = 1;
   }

   *x1_contact = x1 + vx * *collision_time;
   *y1_contact = y1 + vy * *collision_time;

   if (in_path) {
      /* Contact point */
      contact_angle = atan2(y2 - *y1_contact, x2 - *x1_contact);
//      *cx = cos(contact_angle) * r1 + *x1_contact;
//      *cy = sin(contact_angle) * r1 + *y1_contact;
      *cx = cos(contact_angle + M_PI) * r2 + x2;
      *cy = sin(contact_angle + M_PI) * r2 + y2;

      /* Reflection normal */
      normal_angle = contact_angle + M_PI;
      *nx = cos(normal_angle) * r1;
      *ny = sin(normal_angle) * r1;

      /* Reflection vector */
      reflection_angle = normal_angle - (velocity_angle - normal_angle) + M_PI;
      *rx = cos(reflection_angle) * velocity_length;
      *ry = sin(reflection_angle) * velocity_length;
   }
   else {
      /* Reflection normal */
      *nx = 0.0;
      *ny = 0.0;

      /* Reflection vector */
      *rx = 0.0;
      *ry = 0.0;

      /* Contact point */
      *cx = 0.0;
      *cy = 0.0;

      /* Collision time */
      *collision_time = 0.0;
   }

   if (in_path && in_time) {
      is_collision = 1;
   }

   return is_collision;
}

