#include "includes.h"

/* prepares a game for play */
void initialize_game(GAME * gp)
{
	srand(time(0));
    gp->pill.x = BOARD_RX / 2;
    gp->pill.y = 0;
    gp->pill.data[0][0] = 0;
    gp->pill.data[0][1] = 0;
    gp->pill.data[1][0] = rand() % 3 + 1;
    gp->pill.data[1][1] = rand() % 3 + 1;
    gp->pill.active = 1;
    clear_board(gp);
//    generate_board(gp, 10);
    gp->state = GAME_STATE_INTRO;
    gp->timer = 0;
    gp->score = 0;
    gp->combo = 0;
}

/* do game logic */
int do_game(GAME * gp)
{
	int i, j;
	
	if(gp->over)
	{
		gp->refresh = 1;
		return 0;
	}
	gp->level_time++;
	if(gp->state != GAME_STATE_INTRO && gp->state != GAME_STATE_LEVEL && gp->state != GAME_STATE_OVER)
	{
		if(gp->level_time % 2000 == 0)
		{
			if(gp->ticker > 12)
			{
				gp->timer -= 2;
				gp->ticker -= 2;
				gp->level_time = 0;
				play_sample(gp->tp->sound[THEME_SOUND_LEVEL], 255, 127, 1000, 0);
			}
			else if(gp->ticker > 7)
			{
				gp->timer -= 1;
				gp->ticker -= 1;
				gp->level_time = 0;
				play_sample(gp->tp->sound[THEME_SOUND_LEVEL], 255, 127, 1000, 0);
			}
		}
	}
	gp->preview_angle += ftofix(0.75);
	if(gp->preview_angle >= itofix(256))
	{
		gp->preview_angle -= itofix(256);
	}
    switch(gp->state)
    {

        /* do this first */
        case GAME_STATE_INTRO:
        {
            gp->timer++;
	        if(gp->timer == 1)
	        {
		        generate_board_layout(gp);
	            clear_board(gp);
	            generate_pill(gp);
				generate_pill(gp);
	            gp->pill.active = 0;
	        }
	        else if(gp->timer % 5 == 0)
	        {
		        board_add_virus(gp);
	        }
	        if(gp->timer >= gp->level * 4 * 5 + 4)
//	        if(gp->timer >= gp->level * 1 * 5 + 4)
	        {
	            gp->state = GAME_STATE_PLAY;
	            switch(gp->difficulty)
            	{
		            case 0:
	            	{
	            		gp->ticker = 70;
		            	break;
	            	}
	            	case 1:
	            	{
	            		gp->ticker = 36;
            			break;
        			}
        			case 2:
        			{
	            		gp->ticker = 26;
            			break;
        			}
    			}
            	gp->level_time = 0;
	        }
//            generate_board(gp, gp->level * 4);
//            gp->preview_angle = itofix(0);
            break;
        }

        /* normal play */
        case GAME_STATE_PLAY:
        {
            if(!gp->pill.active)
            {
                generate_pill(gp);
//	            gp->preview_angle = itofix(0);
                gp->timer = 0;
                if(gp->controller.was_left > REPEAT_DELAY)
                {
	                gp->controller.was_left = REPEAT_DELAY;
                }
                else if(gp->controller.was_right > REPEAT_DELAY)
                {
	                gp->controller.was_right = REPEAT_DELAY;
                }
            }
            else
            {
                if(gp->controller.left)
                {
                    move_pill(gp, -1, 0);
                }
                if(gp->controller.right)
                {
                    move_pill(gp, 1, 0);
                }
                if(gp->controller.drop)
                {
                    if(!move_pill(gp, 0, 1))
                    {
	                    return 0;
                    }
                    gp->timer = 0;
                }
                if(gp->controller.rleft)
                {
                    lrotate_pill(gp);
                }
                if(gp->controller.rright)
                {
                    rrotate_pill(gp);
                }
            }
            gp->timer++;
            if(gp->timer % gp->ticker == 0)
            {
				if(!move_pill(gp, 0, 1))
				{
					return 0;
				}
            }
            break;
        }

        /* search for matches */
        case GAME_STATE_FIND:
        {
	        gp->timer++;
	        if(gp->timer >= 50)
	        {
            	if(!find_runs(gp))
            	{
	            	gp->combo = 0;
					if(gp->board.data[1][3] || gp->board.data[1][4])
					{
						gp->state = GAME_STATE_OVER;
						return 0;
					}
					for(i = 0; i < BOARD_RX; i++)
					{
						if(gp->board.data[0][i])
						{
							gp->state = GAME_STATE_OVER;
							return 0;
						}
					}
            	}
//            	else
//            	{
//	            	gp->state = GAME_STATE_KILL;
//	            	gp->timer = 0;
//            	}
        	}
            break;
        }

        /* do whatever when matches found */
        case GAME_STATE_MATCHES:
        {
	        if(gp->timer == 0)
	        {
            	gp->pill.active = 0;
            	delete_runs(gp);
                update_board(gp);
	        }
	        gp->timer += 8;
	        if(gp->timer >= 256)
	        {
			    for(i = 0; i < BOARD_RY; i++)
    			{
        			for(j = 0; j < BOARD_RX; j++)
        			{
            			if(gp->board.match_data[i][j])
            			{
                			gp->board.match_data[i][j] = 0; /* make sure it's not counted next time */
            			}
        			}
    			}
            	if(board_cleared(&gp->board))
            	{
	            	gp->state = GAME_STATE_LEVEL;
	            	gp->timer = 0;
	            	ncds_set_position(32);
            	}
            	else
            	{
                	gp->state = GAME_STATE_FALL;
                	gp->timer = 29;
            	}
        	}
            break;
        }

        /* when virii killed do this */
        case GAME_STATE_KILL:
        {
	        gp->timer += 4;
	        if(gp->timer >= 256)
	        {
		        gp->state = GAME_STATE_PLAY;
	        }
            break;
        }

        /* whenever a pill breaks off and needs to fall */
        case GAME_STATE_FALL:
        {
	        gp->timer++;
	        if(gp->timer % 30 == 0)
	        {
            	blocks_fall(gp);
        	}
            break;
        }
        
        case GAME_STATE_LEVEL:
        {
	        gp->timer++;
	        gp->refresh = 1;
	        if(gp->controller.rleft || gp->controller.rright)
	        {
                gp->state = GAME_STATE_INTRO;
                gp->timer = 0;
               	gp->level++;
            	clear_board(gp);
            	gp->pill.active = 0;
               	if(gp->level > 20)
               	{
	               	gp->over = 1;
	               	gp->level = 20;
	               	ncds_stop_music();
               	}
               	else
               	{
               		gp->refresh = 1;
            		ncds_set_position(0);
        		}
	        }
	        break;
        }
        case GAME_STATE_OVER:
        {
        	gp->refresh = 1;
        	break;
        }
    }
    gp->frame++;
    return 1;
}

int get_aid_pos(GAME * gp)
{
	int i;
	
	for(i = gp->pill.y >= 0 ? gp->pill.y : 0; i < BOARD_RY - 1; i++)
	{
		if(gp->board.data[i][gp->pill.x] && gp->pill.data[0][0] ||
		   gp->board.data[i][gp->pill.x + 1] && gp->pill.data[0][1] ||
		   gp->board.data[i + 1][gp->pill.x] && gp->pill.data[1][0] ||
		   gp->board.data[i + 1][gp->pill.x + 1] && gp->pill.data[1][1])
		{
			return i - 1;
		}
	}
	return BOARD_RY - 2;
}

/* update the display */
void draw_game(BITMAP * bp, GAME * gp, THEME * tp)
{
    int i, j;
    int py = get_aid_pos(gp);

    /* draw the board */
    for(i = 0; i < BOARD_RY; i++)
    {
        for(j = 0; j < BOARD_RX; j++)
        {
		    if(gp->state == GAME_STATE_MATCHES)
    		{
				set_trans_blender(0, 0, 0, 255 - gp->timer);
				if(gp->board.match_data[i][j])
            	{
	            	if(gp->board.match_data[i][j] >= 16)
	            	{
		                draw_trans_ani(bp, tp->virus[(int)gp->board.match_data[i][j] - 16], j * 16 + gp->x, i * 16 + gp->y, gp->frame);
	            	}
	            	else
	            	{
		                draw_trans_sprite(bp, tp->block[(int)gp->board.match_data[i][j]], j * 16 + gp->x, i * 16 + gp->y);
		            }
            	}
            	else if(gp->board.data[i][j])
            	{
	            	if(gp->board.data[i][j] >= 16)
	            	{
		                draw_ani(bp, tp->virus[(int)gp->board.data[i][j] - 16], j * 16 + gp->x, i * 16 + gp->y, gp->frame);
	            	}
	            	else
	            	{
	                	draw_sprite(bp, tp->block[(int)gp->board.data[i][j]], j * 16 + gp->x, i * 16 + gp->y);
                	}
            	}
        	}
        	else
        	{
            	if(gp->board.data[i][j])
            	{
	            	if(gp->board.data[i][j] >= 16)
	            	{
		                draw_ani(bp, tp->virus[(int)gp->board.data[i][j] - 16], j * 16 + gp->x, i * 16 + gp->y, gp->frame);
	            	}
	            	else
	            	{
                		draw_sprite(bp, tp->block[(int)gp->board.data[i][j]], j * 16 + gp->x, i * 16 + gp->y);
            		}
	            }
        	}
        }
    }

    /* draw the pill */
//    set_clip_rect(bp, gp->x, gp->y, gp->x + BOARD_RX * 16 - 1, gp->y + BOARD_RY * 16 - 1);
    if(gp->pill.active)
    {
		if(gp->aid && py != gp->pill.y)
		{
			set_trans_blender(0, 0, 0, 127);
	        for(i = 0; i < 2; i++)
        	{
	            for(j = 0; j < 2; j++)
            	{
	                if(gp->pill.data[i][j])
                	{
	                   	draw_trans_sprite(bp, tp->block[(int)gp->pill.data[i][j]], (gp->pill.x + j) * 16 + gp->x, (get_aid_pos(gp) + i) * 16 + gp->y);
                	}
            	}
        	}
		}
        for(i = 0; i < 2; i++)
        {
            for(j = 0; j < 2; j++)
            {
                if(gp->pill.data[i][j])
                {
                   	draw_sprite(bp, tp->block[(int)gp->pill.data[i][j]], (gp->pill.x + j) * 16 + gp->x, (gp->pill.y + i) * 16 + gp->y + 1);
                }
            }
        }
    }
//    set_clip_rect(bp, 0, 0, bp->w - 1, bp->h - 1);
	if(gp->level <= 20)
	{
		clear_to_color(gp->preview, makecol(255, 0, 255));
		draw_sprite(gp->preview, tp->block[(int)gp->next_pill.data[1][0]], 0, 0);
		draw_sprite(gp->preview, tp->block[(int)gp->next_pill.data[1][1]], 16, 0);
		rotate_scaled_sprite(bp, gp->preview, 408, 168, fmul(itofix(8), fsin(gp->preview_angle)), itofix(2));
	}
}
