#include "includes.h"

BITMAP * subscreen;
BITMAP * fbrx_screen;
BITMAP * fbrx_subscreen;
PALETTE  fbrx_palette;
BITMAP * fbrx_frame;
int fbrx_state;

THEME fbrx_theme;
GAME  fbrx_game;

void fbrx_init(void)
{
    allegro_init();
    install_keyboard();
    ncd_joy_install();
    set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0);
    fbrx_frame = load_pcx("fbrx.dat#frame", fbrx_palette);
    subscreen = create_sub_bitmap(screen, 12, 12, 296, 216);
    fbrx_screen = create_bitmap(320, 240);
    fbrx_subscreen = create_sub_bitmap(fbrx_screen, 12, 12, 296, 216);
    set_palette(fbrx_palette);

    /* create blocks (temporary) */
    fbrx_theme.block[0] = create_bitmap(8, 8);
    clear(fbrx_theme.block[0]);
    fbrx_theme.block[1] = load_pcx("fbrx.dat#block_red0", NULL);
    fbrx_theme.block[2] = load_pcx("fbrx.dat#block_red1", NULL);
    fbrx_theme.block[3] = load_pcx("fbrx.dat#block_red2", NULL);
    fbrx_theme.block[4] = load_pcx("fbrx.dat#block_red3", NULL);
    fbrx_theme.block[5] = load_pcx("fbrx.dat#block_red4", NULL);
    fbrx_theme.block[6] = load_pcx("fbrx.dat#block_yellow0", NULL);
    fbrx_theme.block[7] = load_pcx("fbrx.dat#block_yellow1", NULL);
    fbrx_theme.block[8] = load_pcx("fbrx.dat#block_yellow2", NULL);
    fbrx_theme.block[9] = load_pcx("fbrx.dat#block_yellow3", NULL);
    fbrx_theme.block[10] = load_pcx("fbrx.dat#block_yellow4", NULL);
    fbrx_theme.block[11] = load_pcx("fbrx.dat#block_blue0", NULL);
    fbrx_theme.block[12] = load_pcx("fbrx.dat#block_blue1", NULL);
    fbrx_theme.block[13] = load_pcx("fbrx.dat#block_blue2", NULL);
    fbrx_theme.block[14] = load_pcx("fbrx.dat#block_blue3", NULL);
    fbrx_theme.block[15] = load_pcx("fbrx.dat#block_blue4", NULL);
    fbrx_theme.block[16] = load_pcx("fbrx.dat#virus_red", NULL);
    fbrx_theme.block[17] = load_pcx("fbrx.dat#virus_yellow", NULL);
    fbrx_theme.block[18] = load_pcx("fbrx.dat#virus_blue", NULL);
    fbrx_theme.backdrop = load_pcx("fbrx.dat#1p_backdrop", NULL);
}

void fbrx_exit(void)
{
    int i;

    for(i = 0; i < THEME_BLOCK_TYPES; i++)
    {
        destroy_bitmap(fbrx_theme.block[i]);
    }
    destroy_bitmap(fbrx_theme.backdrop);
    destroy_bitmap(fbrx_subscreen);
    destroy_bitmap(fbrx_screen);
    destroy_bitmap(subscreen);
    destroy_bitmap(fbrx_frame);
    ncd_joy_remove();
    remove_keyboard();
    allegro_exit();
}

void fbrx_main(void)
{
    int i, j;

    blit(fbrx_frame, screen, 0, 0, 0, 0, 320, 240);
    clear(fbrx_subscreen);

    initialize_game(&fbrx_game);
    fbrx_game.controller.source = CONTROL_SOURCE_KEY;
    fbrx_game.controller.left_key = KEY_LEFT;
    fbrx_game.controller.right_key = KEY_RIGHT;
    fbrx_game.controller.drop_key = KEY_DOWN;
    fbrx_game.controller.rleft_key = KEY_Z;
    fbrx_game.controller.rright_key = KEY_UP;
    fbrx_game.x = BOTTLE_X_1P;
    fbrx_game.y = BOTTLE_Y_1P;
    fbrx_game.level = 1;
    while(!key[KEY_ESC])
    {
        ncd_joy_poll();
        do_game(&fbrx_game);
//        clear(fbrx_subscreen);
        blit(fbrx_theme.backdrop, fbrx_subscreen, 0, 0, 0, 0, fbrx_subscreen->w, fbrx_subscreen->h);
        draw_game(fbrx_subscreen, &fbrx_game, &fbrx_theme);

        vsync();
        blit(fbrx_subscreen, subscreen, 0, 0, 0, 0, 296, 216);
    }
}

int main(void)
{
    fbrx_init();
    fbrx_main();
    fbrx_exit();

    return 0;
}
END_OF_MAIN()
