#include <allegro.h>
#include <ncd.h>
#include "control.h"

CONTROLLER p1c;
CONTROLLER p2c;

int x = 0;
int y = 0;

int main(void)
{
        allegro_init();
        install_keyboard();
        ncd_joy_install();
        set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0);

        p1c.source = CONTROL_SOURCE_KEY;
        p1c.left_key = KEY_LEFT;
        p1c.right_key = KEY_RIGHT;
        p1c.rleft_key = KEY_LCONTROL;
        p1c.rright_key = KEY_ALT;
        p1c.drop_key = KEY_DOWN;
        p2c.source = CONTROL_SOURCE_JOY1;
        p2c.rleft_key = 0;
        p2c.rright_key = 1;
        while(!key[KEY_ESC])
        {
                read_controller(&p1c);
                read_controller(&p2c);
                if(ncd_joy_left(0) || ncd_joy_left(1))
                {
                        x--;
                }
                if(ncd_joy_right(0) || ncd_joy_right(1))
                {
                        x++;
                }
                if(ncd_joy_up(0) || ncd_joy_up(1))
                {
                        y--;
                }
                if(ncd_joy_down(0) || ncd_joy_down(1))
                {
                        y++;
                }

                vsync();
                if(p1c.left)
                {
                        textprintf(screen, font, 0, 0, makecol(255, 255, 255), "Left");
                }
                if(p1c.right)
                {
                        textprintf(screen, font, 0, 8, makecol(255, 255, 255), "Right");
                }
                if(p1c.drop)
                {
                        textprintf(screen, font, 0, 16, makecol(255, 255, 255), "Drop");
                }
                if(p1c.rleft)
                {
                        textprintf(screen, font, 0, 24, makecol(255, 255, 255), "RLeft");
                }
                if(p1c.rright)
                {
                        textprintf(screen, font, 0, 32, makecol(255, 255, 255), "RRight");
                }
                if(p2c.left)
                {
                        textprintf(screen, font, 160, 0, makecol(255, 255, 255), "Left");
                }
                if(p2c.right)
                {
                        textprintf(screen, font, 160, 8, makecol(255, 255, 255), "Right");
                }
                if(p2c.drop)
                {
                        textprintf(screen, font, 160, 16, makecol(255, 255, 255), "Drop");
                }
                if(p2c.rleft)
                {
                        textprintf(screen, font, 160, 24, makecol(255, 255, 255), "RLeft");
                }
                if(p2c.rright)
                {
                        textprintf(screen, font, 160, 32, makecol(255, 255, 255), "RRight");
                }
        }
        ncd_joy_remove();
        remove_keyboard();
        allegro_exit();
}
