// Compile in MinGW with the following command:
// g++ -o template.dll template.cpp -W -Wall -shared -Wl,--enable-auto-import -Wl,--enable-runtime-pseudo-reloc -s -lalleg
// and in Linux with
// g++ -o template.dll template.cpp -W -Wall -shared -s -fPIC `allegro-config --libs`
// ...or something like that...

#include <IGame.h>
#include "includes.h"

GameSettings av_settings[] =
{
	{ "Aid", "Visual Aid", "On|Off", 0},
	{ "Virus", "Virus Graphics", "Character|Plain", 0},
	{ "Music", "Music", "On|Off", 0 },
	{ "Difficulty", "Difficulty", "Easy|Medium|Hard", 1 },
	{ "Start", "Starting Level", "1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20", 0 },
	{ 0, 0, 0, 0 }
};

class AntiVirus : public IGame
{
	public:
	
		AntiVirus() : IGame()
		{
		}

		~AntiVirus()
		{
		}

		char *GetName()
		{
			return "Anti-Virus";
		}

		char *GetAuthor()
		{
			return "Todd Cope";
		}

		char *GetDescription()
		{
			return "A clone of \"Dr. Mario.\"";
		}

		char *GetVersion()
		{
			return "1.0";
		}

		char *GetIconPath()
		{
			return "icon.pcx";
		}

		bool Init()
		{
			PALETTE temp_pal;
			
			if (!IGame::Init())
			{
				return false;
			}
			
			if(!ncds_install())
			{
				return false;
			}

			// custom initialization goes here
			// ...
   		    av_theme.block[0] = create_bitmap(8, 8);
		    clear(av_theme.block[0]);
		    av_theme.block[1] = load_pcx("games/antivirus/antivirus.dat#pill_red4.pcx", NULL);
		    av_theme.block[2] = load_pcx("games/antivirus/antivirus.dat#pill_red0.pcx", NULL);
		    av_theme.block[3] = load_pcx("games/antivirus/antivirus.dat#pill_red2.pcx", NULL);
		    av_theme.block[4] = load_pcx("games/antivirus/antivirus.dat#pill_red1.pcx", NULL);
		    av_theme.block[5] = load_pcx("games/antivirus/antivirus.dat#pill_red3.pcx", NULL);
		    av_theme.block[6] = load_pcx("games/antivirus/antivirus.dat#pill_yellow4.pcx", NULL);
    		av_theme.block[7] = load_pcx("games/antivirus/antivirus.dat#pill_yellow0.pcx", NULL);
    		av_theme.block[8] = load_pcx("games/antivirus/antivirus.dat#pill_yellow2.pcx", NULL);
    		av_theme.block[9] = load_pcx("games/antivirus/antivirus.dat#pill_yellow1.pcx", NULL);
    		av_theme.block[10] = load_pcx("games/antivirus/antivirus.dat#pill_yellow3.pcx", NULL);
		    av_theme.block[11] = load_pcx("games/antivirus/antivirus.dat#pill_blue4.pcx", NULL);
    		av_theme.block[12] = load_pcx("games/antivirus/antivirus.dat#pill_blue0.pcx", NULL);
    		av_theme.block[13] = load_pcx("games/antivirus/antivirus.dat#pill_blue2.pcx", NULL);
    		av_theme.block[14] = load_pcx("games/antivirus/antivirus.dat#pill_blue1.pcx", NULL);
    		av_theme.block[15] = load_pcx("games/antivirus/antivirus.dat#pill_blue3.pcx", NULL);
    		av_theme.block[16] = load_pcx("games/antivirus/antivirus.dat#virus_red.pcx", NULL);
    		av_theme.block[17] = load_pcx("games/antivirus/antivirus.dat#virus_yellow.pcx", NULL);
    		av_theme.block[18] = load_pcx("games/antivirus/antivirus.dat#virus_blue.pcx", NULL);
    		if(av_settings[1].value == 0)
    		{
    			av_theme.virus[0] = load_ani("games/antivirus/antivirus.dat#virus_red.ani", temp_pal);
    			av_theme.virus[1] = load_ani("games/antivirus/antivirus.dat#virus_yellow.ani", temp_pal);
    			av_theme.virus[2] = load_ani("games/antivirus/antivirus.dat#virus_blue.ani", temp_pal);
			}
			else
			{
    			av_theme.virus[0] = load_ani("games/antivirus/antivirus.dat#virus_red_os.ani", temp_pal);
    			av_theme.virus[1] = load_ani("games/antivirus/antivirus.dat#virus_yellow_os.ani", temp_pal);
    			av_theme.virus[2] = load_ani("games/antivirus/antivirus.dat#virus_blue_os.ani", temp_pal);
			}
    		av_theme.backdrop = load_pcx("games/antivirus/antivirus.dat#backdrop.pcx", NULL);
    		av_theme.sound[THEME_SOUND_MOVE] = load_wav("games/antivirus/antivirus.dat#move.wav");
    		av_theme.sound[THEME_SOUND_ROTATE] = load_wav("games/antivirus/antivirus.dat#rotate.wav");
    		av_theme.sound[THEME_SOUND_LAND] = load_wav("games/antivirus/antivirus.dat#land.wav");
    		av_theme.sound[THEME_SOUND_MATCH] = load_wav("games/antivirus/antivirus.dat#match.wav");
    		av_theme.sound[THEME_SOUND_KILL] = load_wav("games/antivirus/antivirus.dat#kill.wav");
    		av_theme.sound[THEME_SOUND_LEVEL] = load_wav("games/antivirus/antivirus.dat#levelup.wav");
    		av_theme.sound[THEME_SOUND_PAUSE] = load_wav("games/antivirus/antivirus.dat#pause.wav");
    		av_font = load_font("games/antivirus/antivirus.dat#font.pcx", NULL, NULL);
    		av_game.preview = create_bitmap(32, 16);
    		av_game.tp = &av_theme;
    		av_game.frame = 0;

		    initialize_game(&av_game);
		    av_game.x = BOTTLE_X_1P;
    		av_game.y = BOTTLE_Y_1P;
		    av_game.level = av_settings[4].value + 1;
		    av_game.difficulty = av_settings[3].value;
		    av_game.board.layout = NULL;
		    av_game.aid = !av_settings[0].value;
		    av_game.refresh = 1;
		    av_game.over = 0;
		    paused = 0;
		    if(av_settings[2].value == 0)
		    {
			    ncds_play_music("games/antivirus/antivirus.dat#bgm2.xm", 1);
		    }
			return true;
		}

		void Deinit()
		{
			// custom deinitialization goes here
			// ...
		    for(int i = 0; i < THEME_BLOCK_TYPES; i++)
    		{
        		destroy_bitmap(av_theme.block[i]);
    		}
    		for(int i = 0; i < THEME_SOUND_TYPES; i++)
    		{
	    		destroy_sample(av_theme.sound[i]);
    		}
    		destroy_bitmap(av_theme.backdrop);
    		ncds_stop_music();
    		ncds_remove();

			// no more Allegro calls after this line!
			IGame::Deinit();
		}

		void Draw(BITMAP *canvas)
		{
			// Do all the drawing here. Draw only to the canvas bitmap.
			// ...
			if(av_game.refresh || paused)
			{
	        	blit(av_theme.backdrop, canvas, 0, 0, 0, 0, canvas->w, canvas->h);
	        	av_game.refresh = 0;
        	}
        	else
        	{
	        	blit(av_theme.backdrop, canvas, av_game.x, av_game.y - 16, av_game.x, av_game.y - 16, BOARD_RX * 16, (BOARD_RY + 1) * 16 + 1);
	        	blit(av_theme.backdrop, canvas, 408, 168 - 16, 408, 168 - 16, 64, 64);
        	}
        	if(!paused && av_game.state != GAME_STATE_LEVEL)
        	{
        		draw_game(canvas, &av_game, &av_theme);
    		}
        	textprintf_ex(canvas, av_font, 400, 320, makecol(0, 0, 0), -1, "SCORE");
        	textprintf_centre_ex(canvas, av_font, 400 + 40, 336, makecol(0, 0, 0), makecol(255, 255, 255), "%d", av_game.score);
        	textprintf_ex(canvas, av_font, 400, 376, makecol(0, 0, 0), -1, "LEVEL");
        	textprintf_centre_ex(canvas, av_font, 400 + 40, 392, makecol(0, 0, 0), makecol(255, 255, 255), "%d", av_game.level);
        	if(av_game.state == GAME_STATE_LEVEL && (av_game.timer / 15) % 2 == 0)
        	{
	        	textprintf_centre_ex(canvas, av_font, 320 + 2, 232 + 2, makecol(0, 0, 0), -1, "LEVEL COMPLETE");
	        	textprintf_centre_ex(canvas, av_font, 320, 232, makecol(255, 255, 255), -1, "LEVEL COMPLETE");
        	}
		}

		int Logic(int keys[8], int mouse[4], float dT)
		{
			if(!paused)
			{
				// Do all input processing and game logic here. Refer to the
				// comments in IGame.h for details on the format of the input
				// parameters and the requirements for the output.
				// ...
				read_controller(&av_game.controller, keys);
				if(!do_game(&av_game))
				{
					return 1;
				}
			}
			ncds_update_music();
			return 0;
		}

		void Pause()
		{
			play_sample(av_game.tp->sound[THEME_SOUND_PAUSE], 255, 127, 1000, 0);
			paused = 1;
			ncds_pause_music();
		}
		
		void Resume()
		{
			paused = 0;
			av_game.refresh = 1;
			ncds_resume_music();
		}
		
		int Score()
		{
			// Return -1 if this game doesn't have points, otherwise the last
			// valid score where more points is better.
			return av_game.score;
		}

		bool UseSystemMouse()
		{
			// Return false if the game draws its own cursor or doesn't use
			// the mouse at all.
			return false;
		}

		// Should return true if keys can be redefined (otherwise
		// global keys are used)
		bool RedefinesKeys()
		{
			return true;
		}

		// Should return names of redefinable keys or NULL if
		// key can't be redefined. i = [0,7]
		const char *KeyName(int i)
		{
			switch (i)
			{
				case 0:
				{
					return "Left";
				}
				case 1:
				{
					return "Right";
				}
				case 3:
				{
					return "Drop";
				}
				case 4:
				{
					return "Rotate Left";
				}
				case 5:
				{
					return "Rotate Right";
				}
				default:
				{
					return NULL;
				}
			};
		}

		// Should return to a NULL terminated array of GameSettings structures.
		// For example you could define the array like this:
		//
		//	GameSettings my_settings[] = {
		//		{ "name1", "option 1", "first|second|third", 1 },
		//		{ "name2", "option 2", "first|second|third", 0 },
		//		{ "name3", "option 3", "first|second|third", 2 },
		//		{ 0, 0, 0, 0 }
		//	};
		//
		// and then return my_settings in this function.
		GameSettings* GetSettings()
		{
			return av_settings;
		}
		
	private:
	
		BITMAP * subscreen;
		PALETTE  av_palette;
		int av_state;
		FONT * av_font;

		THEME av_theme;
		GAME  av_game;
		int paused;
		
};



extern "C" DLLEXPORT IGame* GetPlugin()
{
	return new AntiVirus;
}
