#ifndef _VIEW_H
#define _VIEW_H

#include <allegro.h>

typedef struct view_t {
   int x, y;
   int w, h;
   int offset_x, offset_y;
   float focus_x, focus_y;
   BITMAP *draw;
   BITMAP *dest;
   float unit_w_pixels, unit_h_pixels;
} view_t;

void view_init(view_t *view);
void view_set(view_t *view, BITMAP *dest, int x, int y, int w, int h, int offset_x, int offset_y);
int view_create_draw(view_t *view);
void view_destroy_draw(view_t *view);
void view_to_unit(const view_t *view, float view_x, float view_y, float *unit_x, float *unit_y);
void unit_to_view(const view_t *view, float unit_x, float unit_y, float *view_x, float *view_y);
void view_to_screen(const view_t *view, float view_x, float view_y, float *screen_x, float *screen_y);
void screen_to_view(const view_t *view, float screen_x, float screen_y, float *view_x, float *view_y);
void view_clean(view_t *view);

#endif
