#ifndef _UNIT_H
#define _UNIT_H

#define UNIT_MOVE_METHOD_WALK 0
#define UNIT_MOVE_METHOD_FLY  1
#define UNIT_MOVE_METHOD_SWIM 2

#include <stdio.h>

#include "terrain.h"
#include "view.h"
#include "list.h"

#define UNIT_TYPE_NAME_SIZE 32
#define UNIT_TYPE_DESC_SIZE 32
#define UNIT_TYPE_COUNT 32

typedef struct unit_type_t {
   char name[UNIT_TYPE_NAME_SIZE];
   char desc[UNIT_TYPE_DESC_SIZE];
   int move;
   int move_method;
   int attack;
   int defend;
   int sight;
   int tile;
} unit_type_t;

#define UNIT_NAME_SIZE 64

typedef struct unit_t {
   char name[UNIT_NAME_SIZE];
   int type;
   int move;
   int has_fought;
   int attack_bonus;
   int move_bonus;
   int sight_bonus;
} unit_t;

/* Initialise */
void unit_init(unit_t *unit);

/* Draw */
void unit_draw(const unit_t *unit, const view_t *view, float x, float y);

/* Create/destroy */
unit_t *unit_create(void);
void unit_destroy(unit_t *unit);

/* File I/O */
int unit_write(const unit_t *unit, FILE *file);
int unit_read(unit_t *unit, FILE *file);
int unit_list_reader(void *unit, FILE *file);
int unit_list_writer(void *unit, FILE *file);
int unit_list_read(list_t **list, FILE *file);
int unit_list_write(list_t **list, FILE *file);

/* Push/pop */
unit_t *unit_list_push(list_t **list, unit_t *unit);
unit_t *unit_list_pop(list_t **list, unit_t *unit);

/* Clean */
void unit_list_clean(list_t **list);
void unit_list_cleaner(void *unit);

#endif
